/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.internal.RetryPolicy;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.publishing.AbstractFilePublisher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ContentPublisher
extends AbstractFilePublisher {
    private static final int MAX_RETRIES = 5;
    private final String fContentType;
    private final String fCharacterEncoding;

    public ContentPublisher(String typeId, String fileLocation, String label, String contentType, String characterEncoding) {
        super(typeId, fileLocation, label);
        this.fContentType = contentType;
        this.fCharacterEncoding = characterEncoding;
    }

    @Override
    protected IContent getFileContent(ITeamRepository teamRepository) throws TeamRepositoryException, TeamBuildException {
        File file = new File(this.getFilePath());
        IContent content = null;
        try {
            String contentType = this.getContentType();
            int retryNumber = 0;
            while (content == null && retryNumber <= 5) {
                try {
                    if (ContentUtil.isTextContentType((String)contentType)) {
                        content = this.storeTextContent(contentType, file, teamRepository);
                        continue;
                    }
                    content = this.storeContent(contentType, file, teamRepository);
                }
                catch (TeamRepositoryException e) {
                    if (this.isRetryable(++retryNumber, e)) {
                        this.pause(retryNumber);
                        continue;
                    }
                    throw e;
                }
            }
        }
        catch (FileNotFoundException exception) {
            throw new TeamBuildException((Throwable)exception);
        }
        return content;
    }

    protected boolean isRetryable(int retryNumber, TeamRepositoryException e) {
        return RetryPolicy.isRetryEnabled() && RetryPolicy.isRetryable(e) && retryNumber <= 5;
    }

    public String getContentType() {
        String contentType = this.fContentType;
        if (contentType == null) {
            contentType = ContentUtil.getContentTypeFromFileName((String)this.getFilePath());
        }
        if (contentType == null) {
            contentType = this.getDefaultContentType() == null ? "application/unknown" : this.getDefaultContentType();
        }
        return contentType;
    }

    protected IContent storeContent(String contentType, File file, ITeamRepository teamRepository) throws TeamRepositoryException, FileNotFoundException {
        IContent content = teamRepository.contentManager().storeContent(contentType, null, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)new FileInputStream(file), null, (IProgressMonitor)new NullProgressMonitor());
        return content;
    }

    protected IContent storeTextContent(String contentType, File textFile, ITeamRepository teamRepository) throws FileNotFoundException, TeamRepositoryException {
        FileInputStream inputStream = new FileInputStream(textFile);
        String encoding = this.fCharacterEncoding;
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return teamRepository.contentManager().storeText(contentType, encoding, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)inputStream, null, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void pause(int retryNumber) {
        assert (retryNumber >= 1);
        try {
            int secs = 60;
            if (retryNumber < 6) {
                secs = 1 << retryNumber;
            }
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException exception) {
            throw new OperationCanceledException();
        }
    }

    public String getCharacterEncoding() {
        return this.fCharacterEncoding;
    }

    public String getDefaultContentType() {
        return null;
    }
}

