/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.ComponentMapParser;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ComponentMapRegistry {
    private ComponentMapParser fParser;

    public ComponentMapRegistry(String mappingFilePath) throws IOException, SAXException, ParserConfigurationException {
        ValidationHelper.validateNotEmpty((String)mappingFilePath, (String)mappingFilePath);
        this.fParser = new ComponentMapParser(new File(mappingFilePath));
        this.fParser.parse();
    }

    public String mapPackageToComponent(String packageName) {
        ValidationHelper.validateNotNull((String)"packageName", (Object)packageName);
        Hashtable<String, String> packageNameToComponentMappings = this.fParser.getPackageNameToComponentMappings();
        Hashtable<String, String> packagePrefixToComponentMappings = this.fParser.getPackagePrefixToComponentMappings();
        String componentName = packageNameToComponentMappings.get(packageName);
        int longestMatch = 0;
        if (componentName == null) {
            for (String packagePrefix : packagePrefixToComponentMappings.keySet()) {
                if (!packageName.startsWith(packagePrefix) || packagePrefix.length() <= longestMatch) continue;
                componentName = packagePrefixToComponentMappings.get(packagePrefix);
                longestMatch = packagePrefix.length();
            }
        }
        return componentName == null ? this.fParser.getDefaultComponentName() : componentName;
    }
}

