/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.parser.AbstractMSBuildCompileLogParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;

public class MSBuildSimpleCompileLogParser
extends AbstractMSBuildCompileLogParser {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PROJECT_START = "--- Project Start ---";
    private static final String PROJECT_END = "--- Project End ---";
    private static final String ERRORS_START = "--- Errors Start ---";
    private static final String ERRORS_END = "--- Errors End ---";
    private static final String WARNINGS_START = "--- Warnings Start ---";
    private static final String WARNINGS_END = "--- Warnings End ---";
    private static final String SOLUTION_NAME = "SolutionName:";
    private static final String PROJECT_NAME = "ProjectName:";

    public MSBuildSimpleCompileLogParser(String logDirectory) {
        super(logDirectory);
    }

    @Override
    public void parse() throws IOException {
        String[] logFiles = this.getLogFiles();
        if (logFiles != null && logFiles.length >= 1) {
            int index = 0;
            while (index < logFiles.length) {
                String contents = FileHelper.fileToString((File)new File(this.fLogDirectory, logFiles[index]));
                this.parseErrorsAndWarnings(contents);
                ++index;
            }
        }
    }

    protected void parseErrorsAndWarnings(String contents) throws IOException {
        BufferedReader reader = null;
        String projectName = null;
        String solutionName = null;
        StringBuilder errors = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        int errorCount = 0;
        int warningCount = 0;
        try {
            reader = new BufferedReader(new StringReader(contents));
            String line = reader.readLine();
            if (!PROJECT_START.equals(line)) {
                return;
            }
            line = reader.readLine();
            if (line == null || !line.startsWith(SOLUTION_NAME)) {
                return;
            }
            solutionName = line.substring(SOLUTION_NAME.length());
            line = reader.readLine();
            if (line == null || !line.startsWith(PROJECT_NAME)) {
                return;
            }
            projectName = line.substring(PROJECT_NAME.length());
            line = reader.readLine();
            while (line != null && !line.equals(PROJECT_END)) {
                if (line.equals(ERRORS_START)) {
                    line = reader.readLine();
                    while (line != null && !line.equals(ERRORS_END)) {
                        ++errorCount;
                        errors.append(line);
                        errors.append(NEW_LINE);
                        line = reader.readLine();
                    }
                } else if (line.equals(WARNINGS_START)) {
                    line = reader.readLine();
                    while (line != null && !line.equals(WARNINGS_END)) {
                        ++warningCount;
                        warnings.append(line);
                        warnings.append(NEW_LINE);
                        line = reader.readLine();
                    }
                }
                line = reader.readLine();
            }
            AbstractMSBuildCompileLogParser.ProjectData prjData = new AbstractMSBuildCompileLogParser.ProjectData(this);
            prjData.setProjectName(projectName);
            prjData.setSolutionName(solutionName);
            prjData.setErrorCount(errorCount);
            prjData.setErrors(errors.toString());
            prjData.setWarningCount(warningCount);
            prjData.setWarnings(warnings.toString());
            this.fProjectsData.add(prjData);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

