/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.parser.AbstractParserHandlerBase;
import com.ibm.team.build.internal.parser.ParserMessages;
import com.ibm.team.build.internal.parser.SkipElementException;
import com.ibm.team.build.internal.parser.data.JdtParserCompileData;
import com.ibm.team.build.internal.parser.data.JdtParserProblemData;
import com.ibm.team.build.internal.parser.data.JdtParserSourceData;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JdtXmlCompileLogParser
extends AbstractParserHandlerBase {
    private JdtParserCompileData fCompileData;
    private JdtParserSourceData fCurrentSource;
    private JdtParserProblemData fCurrentProblem;
    private boolean fFoundMessage;
    private boolean fFoundSourceContext;
    protected static final String TAG_COMPILER = "compiler";
    protected static final String TAG_OPTIONS = "options";
    protected static final String TAG_COMMAND_LINE = "command_line";
    protected static final String TAG_ARGUMENTS = "arguments";
    protected static final String TAG_CLASSPATHS = "classpaths";
    protected static final String TAG_CLASSFILE = "classfile";
    protected static final String TAG_ID = "id";
    protected static final String TAG_PROBLEMS = "problems";
    protected static final String TAG_PROBLEM = "problem";
    protected static final String TAG_CHAR_START = "charStart";
    protected static final String TAG_CHAR_END = "charEnd";
    protected static final String TAG_SOURCES = "sources";
    protected static final String TAG_SOURCE = "source";
    protected static final String TAG_OUTPUT = "output";
    protected static final String TAG_PACKAGE = "package";
    protected static final String TAG_PATH = "path";
    protected static final String TAG_SEVERITY = "severity";
    protected static final String TAG_MESSAGE = "message";
    protected static final String TAG_VALUE = "value";
    protected static final String TAG_LINE = "line";
    protected static final String TAG_STATS = "stats";
    protected static final String TAG_TIME = "time";
    protected static final String TAG_SOURCE_CONTEXT = "source_context";
    protected static final String TAG_NUMBER_OF_LINES = "number_of_lines";
    protected static final String TAG_PROBLEM_SUMMARY = "problem_summary";
    protected static final String TAG_NUMBER_OF_CLASSFILES = "number_of_classfiles";
    protected static final String TAG_SOURCE_START = "sourceStart";
    protected static final String TAG_SOURCE_END = "sourceEnd";
    protected static final String ERROR = "ERROR";
    protected static final String WARNING = "WARNING";
    protected static final String[] VALID_SEVERITY_ATTRIBUTE_VALUES = new String[]{"WARNING", "ERROR"};

    public JdtXmlCompileLogParser(File logFile) {
        super(logFile);
    }

    public JdtParserCompileData getParsedData() {
        return this.fCompileData;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (systemId == null) {
            return;
        }
        String compilerPrefix = "compiler_";
        Pattern dtdNamePattern = Pattern.compile(String.valueOf(compilerPrefix) + "[0-9][0-9]_[0-9][0-9][0-9]\\.dtd");
        Matcher dtdNameMatcher = dtdNamePattern.matcher(systemId);
        if (!dtdNameMatcher.find()) {
            return;
        }
        String dtdName = dtdNameMatcher.group();
        String dtdVersion = dtdName.substring(compilerPrefix.length(), compilerPrefix.length() + 6);
        int majorVersion = Integer.valueOf(dtdVersion.substring(0, 2));
        int minorVersion = Integer.valueOf(dtdVersion.substring(3, 6));
        if (majorVersion < 32 || majorVersion == 32 && minorVersion == 1) {
            throw new SAXException(ParserMessages.JdtXmlCompileLogParser_UNSUPPORTED_COMPILER_VERSION);
        }
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getValidRootElementContext(AbstractParserHandlerBase.ContextType rootContext) {
        if (rootContext != JdtXmlContextType.PARSING_COMPILER) {
            return null;
        }
        return rootContext;
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getValidChildElementContext(AbstractParserHandlerBase.ContextType childContext, AbstractParserHandlerBase.ContextType parentContext) {
        switch ((JdtXmlContextType)parentContext) {
            case PARSING_COMPILER: {
                if (childContext == JdtXmlContextType.PARSING_COMMAND_LINE || childContext == JdtXmlContextType.PARSING_OPTIONS || childContext == JdtXmlContextType.PARSING_CLASSPATHS) {
                    return this.getIgnoreContext();
                }
                if (childContext != JdtXmlContextType.PARSING_SOURCES && childContext != JdtXmlContextType.PARSING_STATS) break;
                return childContext;
            }
            case PARSING_SOURCES: {
                if (childContext != JdtXmlContextType.PARSING_SOURCE) break;
                return childContext;
            }
            case PARSING_SOURCE: {
                if (childContext != JdtXmlContextType.PARSING_PROBLEMS && childContext != JdtXmlContextType.PARSING_CLASSFILE) break;
                return childContext;
            }
            case PARSING_PROBLEMS: {
                if (childContext != JdtXmlContextType.PARSING_PROBLEM) break;
                return childContext;
            }
            case PARSING_PROBLEM: {
                if (childContext == JdtXmlContextType.PARSING_MESSAGE || childContext == JdtXmlContextType.PARSING_SOURCE_CONTEXT) {
                    return childContext;
                }
                if (childContext != JdtXmlContextType.PARSING_ARGUMENTS) break;
                return this.getIgnoreContext();
            }
            case PARSING_STATS: {
                if (childContext != JdtXmlContextType.PARSING_TIME && childContext != JdtXmlContextType.PARSING_NUMBER_OF_LINES && childContext != JdtXmlContextType.PARSING_NUMBER_OF_CLASSFILES && childContext != JdtXmlContextType.PARSING_PROBLEM_SUMMARY) break;
                return childContext;
            }
        }
        return null;
    }

    @Override
    protected void startChildElement(Attributes attributes) throws SAXException, SkipElementException {
        switch ((JdtXmlContextType)this.getCurrentContext()) {
            case PARSING_COMPILER: {
                this.fCompileData = new JdtParserCompileData();
                break;
            }
            case PARSING_SOURCE: {
                this.handleStartSource(attributes);
                break;
            }
            case PARSING_PROBLEM: {
                this.handleStartProblem(attributes);
                break;
            }
            case PARSING_SOURCE_CONTEXT: {
                this.handleStartSourceContext(attributes);
                break;
            }
            case PARSING_CLASSFILE: {
                this.fCurrentSource.addClassfileName(this.getRequiredAttribute(attributes, TAG_PATH, true));
                break;
            }
            case PARSING_MESSAGE: {
                this.fCurrentProblem.setMessage(this.getRequiredAttribute(attributes, TAG_VALUE, false));
                this.fFoundMessage = true;
                break;
            }
            case PARSING_TIME: {
                this.fCompileData.setCompileTime(this.getOptionalWholeNumberAttribute(attributes, TAG_VALUE, true, true));
                break;
            }
            case PARSING_NUMBER_OF_LINES: {
                Long value = this.getOptionalWholeNumberAttribute(attributes, TAG_VALUE, true, false);
                if (value == null) break;
                this.fCompileData.setLinesCompiled(value.intValue());
                break;
            }
            case PARSING_NUMBER_OF_CLASSFILES: {
                Long value = this.getOptionalWholeNumberAttribute(attributes, TAG_VALUE, true, false);
                if (value == null) break;
                this.fCompileData.setNumberOfClassfiles(value.intValue());
            }
        }
    }

    private void handleStartSource(Attributes attributes) throws SkipElementException {
        String path = this.getRequiredAttribute(attributes, TAG_PATH, true);
        String className = path.substring(path.lastIndexOf(47) + 1);
        className = className.substring(path.lastIndexOf(92) + 1);
        String packageName = this.getOptionalAttribute(attributes, TAG_PACKAGE, true);
        if (packageName == null) {
            String output = this.getOptionalAttribute(attributes, TAG_OUTPUT, true);
            if (output == null) {
                throw new SkipElementException();
            }
            packageName = "";
        }
        packageName = packageName.replace('/', '.');
        packageName = packageName.replace('\\', '.');
        this.fCurrentSource = new JdtParserSourceData(className, packageName, path);
    }

    private void handleStartProblem(Attributes attributes) throws SkipElementException {
        int charStart = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_CHAR_START, true, false, 0L);
        int charEnd = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_CHAR_END, true, true, 0L);
        int lineNumber = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_LINE, true, true, 0L);
        String id = this.getRequiredAttribute(attributes, TAG_ID, true);
        String severityValue = this.getRequiredAttribute(attributes, TAG_SEVERITY, VALID_SEVERITY_ATTRIBUTE_VALUES, true);
        JdtParserProblemData.Severity severity = severityValue.equals(ERROR) ? JdtParserProblemData.Severity.ERROR : JdtParserProblemData.Severity.WARNING;
        this.fCurrentProblem = new JdtParserProblemData(charStart, charEnd, lineNumber, id, severity);
        this.fFoundMessage = false;
        this.fFoundSourceContext = false;
    }

    private void handleStartSourceContext(Attributes attributes) throws SkipElementException {
        int sourceStart = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_SOURCE_START, true, false, 0L);
        int sourceEnd = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_SOURCE_END, true, true, 0L);
        String value = this.getRequiredAttribute(attributes, TAG_VALUE, true);
        this.fCurrentProblem.setSource(value);
        this.fCurrentProblem.setSourceStart(sourceStart);
        this.fCurrentProblem.setSourceEnd(sourceEnd);
        this.fFoundSourceContext = true;
    }

    @Override
    protected void endChildElement() throws SAXException, SkipElementException {
        switch ((JdtXmlContextType)this.getCurrentContext()) {
            case PARSING_PROBLEM: {
                this.verifySubElement(TAG_MESSAGE, this.fFoundMessage, true);
                this.verifySubElement(TAG_SOURCE_CONTEXT, this.fFoundSourceContext, false);
                this.fCurrentSource.addProblem(this.fCurrentProblem);
                break;
            }
            case PARSING_SOURCE: {
                this.fCompileData.addSource(this.fCurrentSource);
            }
        }
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getContextForElement(String elementName) {
        if (elementName.equals(TAG_COMPILER)) {
            return JdtXmlContextType.PARSING_COMPILER;
        }
        if (elementName.equals(TAG_COMMAND_LINE)) {
            return JdtXmlContextType.PARSING_COMMAND_LINE;
        }
        if (elementName.equals(TAG_CLASSPATHS)) {
            return JdtXmlContextType.PARSING_CLASSPATHS;
        }
        if (elementName.equals(TAG_SOURCES)) {
            return JdtXmlContextType.PARSING_SOURCES;
        }
        if (elementName.equals(TAG_SOURCE)) {
            return JdtXmlContextType.PARSING_SOURCE;
        }
        if (elementName.equals(TAG_PROBLEMS)) {
            return JdtXmlContextType.PARSING_PROBLEMS;
        }
        if (elementName.equals(TAG_PROBLEM)) {
            return JdtXmlContextType.PARSING_PROBLEM;
        }
        if (elementName.equals(TAG_STATS)) {
            return JdtXmlContextType.PARSING_STATS;
        }
        if (elementName.equals(TAG_ARGUMENTS)) {
            return JdtXmlContextType.PARSING_ARGUMENTS;
        }
        if (elementName.equals(TAG_CLASSFILE)) {
            return JdtXmlContextType.PARSING_CLASSFILE;
        }
        if (elementName.equals(TAG_MESSAGE)) {
            return JdtXmlContextType.PARSING_MESSAGE;
        }
        if (elementName.equals(TAG_TIME)) {
            return JdtXmlContextType.PARSING_TIME;
        }
        if (elementName.equals(TAG_NUMBER_OF_LINES)) {
            return JdtXmlContextType.PARSING_NUMBER_OF_LINES;
        }
        if (elementName.equals(TAG_PROBLEM_SUMMARY)) {
            return JdtXmlContextType.PARSING_PROBLEM_SUMMARY;
        }
        if (elementName.equals(TAG_NUMBER_OF_CLASSFILES)) {
            return JdtXmlContextType.PARSING_NUMBER_OF_CLASSFILES;
        }
        if (elementName.equals(TAG_OPTIONS)) {
            return JdtXmlContextType.PARSING_OPTIONS;
        }
        if (elementName.equals(TAG_SOURCE_CONTEXT)) {
            return JdtXmlContextType.PARSING_SOURCE_CONTEXT;
        }
        return null;
    }

    static enum JdtXmlContextType implements AbstractParserHandlerBase.ContextType
    {
        PARSING_COMPILER,
        PARSING_COMMAND_LINE,
        PARSING_OPTIONS,
        PARSING_OPTION,
        PARSING_CLASSPATHS,
        PARSING_CLASSPATH,
        PARSING_SOURCES,
        PARSING_SOURCE,
        PARSING_PROBLEMS,
        PARSING_PROBLEM,
        PARSING_STATS,
        PARSING_ARGUMENTS,
        PARSING_ARGUMENT,
        PARSING_CLASSFILE,
        PARSING_MESSAGE,
        PARSING_TIME,
        PARSING_NUMBER_OF_LINES,
        PARSING_PROBLEM_SUMMARY,
        PARSING_NUMBER_OF_CLASSFILES,
        PARSING_SOURCE_CONTEXT;

    }
}

