/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.common.helper.FileHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class JdtSimpleCompileLogParser {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private int fErrorCount;
    private int fWarningCount;
    private String fErrors = "";
    private String fWarnings = "";
    private String fFilePath;

    public JdtSimpleCompileLogParser(String filePath) {
        this.fFilePath = filePath;
    }

    public void parse() throws IOException {
        String contents = FileHelper.fileToString((String)this.fFilePath);
        this.parseErrorsAndWarnings(contents);
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public String getErrors() {
        return this.fErrors;
    }

    public int getWarningCount() {
        return this.fWarningCount;
    }

    public String getWarnings() {
        return this.fWarnings;
    }

    protected void parseErrorsAndWarnings(String contents) throws IOException {
        BufferedReader reader = null;
        try {
            int warningCount = 0;
            int errorCount = 0;
            StringBuffer warnings = new StringBuffer();
            StringBuffer errors = new StringBuffer();
            reader = new BufferedReader(new StringReader(contents));
            String line = reader.readLine();
            while (line != null) {
                if (this.lineContains(line, ". WARNING in")) {
                    ++warningCount;
                    warnings.append(line);
                    warnings.append(NEW_LINE);
                    line = reader.readLine();
                    while (line != null && !line.equals("----------")) {
                        warnings.append(line);
                        warnings.append(NEW_LINE);
                        line = reader.readLine();
                    }
                    if (line != null && line.equals("----------")) {
                        warnings.append(line);
                        warnings.append(NEW_LINE);
                    }
                } else if (this.lineContains(line, ". ERROR in")) {
                    ++errorCount;
                    errors.append(line);
                    errors.append(NEW_LINE);
                    line = reader.readLine();
                    while (line != null && !line.equals("----------")) {
                        errors.append(line);
                        errors.append(NEW_LINE);
                        line = reader.readLine();
                    }
                    if (line != null && line.equals("----------")) {
                        errors.append(line);
                        errors.append(NEW_LINE);
                    }
                }
                line = reader.readLine();
            }
            this.fErrorCount = errorCount;
            this.fWarningCount = warningCount;
            this.fErrors = errors.toString();
            this.fWarnings = warnings.toString();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean lineContains(String line, String subString) {
        return line.indexOf(subString) >= 0;
    }
}

