/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.parser.AbstractMSBuildCompileLogParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class DevenvBuildSimpleCompileLogParser
extends AbstractMSBuildCompileLogParser {
    private String buildFile;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String projectNumberContentSeperator = ">";
    private static final String contentSeparator = ": ";
    private static final String commaString = ",";
    private static final String lineEndIndicator = ".";
    private static final String buildEndedIndicator = "========== Build:";
    private static final String projectBuildStartIndicator = "------ Build";
    private static final String projectReBuildStartIndicator = "------ Rebuild";
    private static final String PROJECT_STRING = "Project";
    private static final String ERROR_STRING = "error";
    private static final String WARNING_STRING = "warning";
    private HashMap<Integer, DevenvCompileInfo> projectNumberMessagesMap;

    public DevenvBuildSimpleCompileLogParser(String logDirectory, String buildFile) {
        super(logDirectory);
        this.buildFile = buildFile;
        this.projectNumberMessagesMap = new HashMap();
    }

    @Override
    public void parse() throws IOException {
        String[] logFiles = this.getLogFiles();
        if (logFiles != null && logFiles.length == 1) {
            int index = 0;
            while (index < logFiles.length) {
                String contents = FileHelper.fileToString((File)new File(this.fLogDirectory, logFiles[index]));
                this.parseErrorsAndWarnings(contents);
                ++index;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void parseErrorsAndWarnings(String contents) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getPathToDisplay(String path, String projectName) {
        int index = path.indexOf(projectName);
        if (index >= 0) {
            return path.substring(index + projectName.length());
        }
        return path;
    }

    private class DevenvCompileInfo {
        private String projectName;
        private LinkedHashSet<String> errorSet;
        private LinkedHashSet<String> warningSet;
        private int errorCount;
        private int warningCount;

        public DevenvCompileInfo(String projectName) {
            this.projectName = projectName;
            this.errorSet = new LinkedHashSet();
            this.warningSet = new LinkedHashSet();
            this.warningCount = 0;
            this.errorCount = 0;
        }

        public void appendError(String error) {
            if (!this.errorSet.contains(error)) {
                this.errorSet.add(error);
                ++this.errorCount;
            }
        }

        public void appendWarning(String warning) {
            if (!this.warningSet.contains(warning)) {
                this.warningSet.add(warning);
                ++this.warningCount;
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getErrors() {
            StringBuilder errors = new StringBuilder();
            Iterator iter = this.errorSet.iterator();
            while (iter.hasNext()) {
                errors.append((String)iter.next());
                errors.append(NEW_LINE);
            }
            return errors.toString();
        }

        public String getWarnings() {
            StringBuilder warnings = new StringBuilder();
            Iterator iter = this.warningSet.iterator();
            while (iter.hasNext()) {
                warnings.append((String)iter.next());
                warnings.append(NEW_LINE);
            }
            return warnings.toString();
        }

        static /* synthetic */ String access$0(DevenvCompileInfo devenvCompileInfo) {
            return devenvCompileInfo.projectName;
        }
    }
}

