/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMSBuildCompileLogParser {
    protected String fLogDirectory;
    protected List<ProjectData> fProjectsData;

    public AbstractMSBuildCompileLogParser(String logDirectory) {
        this.fLogDirectory = logDirectory;
        this.fProjectsData = new ArrayList<ProjectData>();
    }

    public List<ProjectData> getProjectsData() {
        return this.fProjectsData;
    }

    protected String[] getLogFiles() {
        File lDir;
        if (this.fLogDirectory != null && (lDir = new File(this.fLogDirectory)).exists() && lDir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jbemslog");
                }
            };
            return lDir.list(filter);
        }
        return null;
    }

    public abstract void parse() throws IOException;

    public class ProjectData {
        private int fErrorCount;
        private int fWarningCount;
        private String fErrors = "";
        private String fWarnings = "";
        private String fProjectName = "";
        private String fSolutionName = "";

        public int getErrorCount() {
            return this.fErrorCount;
        }

        void setErrorCount(int errorCount) {
            this.fErrorCount = errorCount;
        }

        public int getWarningCount() {
            return this.fWarningCount;
        }

        void setWarningCount(int warningCount) {
            this.fWarningCount = warningCount;
        }

        public String getErrors() {
            return this.fErrors;
        }

        void setErrors(String errors) {
            this.fErrors = errors;
        }

        public String getWarnings() {
            return this.fWarnings;
        }

        void setWarnings(String warnings) {
            this.fWarnings = warnings;
        }

        public String getProjectName() {
            return this.fProjectName;
        }

        void setProjectName(String projectName) {
            this.fProjectName = projectName;
        }

        public String getSolutionName() {
            return this.fSolutionName;
        }

        void setSolutionName(String solutionName) {
            this.fSolutionName = solutionName;
        }
    }
}

