/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal;

import com.ibm.team.repository.client.IRetryPolicy;
import com.ibm.team.repository.common.RetryableDatabaseException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.transport.client.NoResponseException;
import java.lang.reflect.Method;

public class RetryPolicy
implements IRetryPolicy {
    private static final String ENABLE_RETRY_VARIABLE = "team.build.retry";
    private static final boolean ENABLE_RETRY = Boolean.parseBoolean(System.getProperty("team.build.retry", "false"));

    public boolean autoReLogin() {
        return true;
    }

    public int getMaxRetries(String serviceName, Method method) {
        return 5;
    }

    public void pauseBeforeRetry(String serviceName, Method method, int retryNumber) {
        assert (retryNumber >= 1);
        try {
            int secs = 60;
            if (retryNumber < 6) {
                secs = 1 << retryNumber;
            }
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRetryable(String serviceName, Method method, Throwable failure) {
        if ("ITeamContentService".equals(serviceName) && "put".equals(method)) {
            return false;
        }
        return RetryPolicy.isRetryable(failure);
    }

    public static boolean isRetryable(Throwable failure) {
        while (failure != null) {
            if (failure instanceof RetryableDatabaseException) {
                return true;
            }
            if (failure instanceof ConnectionException) {
                return true;
            }
            if (failure instanceof HostUnknownException) {
                return true;
            }
            if (failure instanceof NoResponseException) {
                return true;
            }
            if (failure instanceof ServiceNotAvailableException) {
                return true;
            }
            failure = failure.getCause();
        }
        return false;
    }

    public static boolean isRetryEnabled() {
        return ENABLE_RETRY;
    }
}

