/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.setup.junit.internal;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.setup.junit.constants.JUnitBuildDefinition;
import com.ibm.team.build.setup.junit.constants.JUnitBuildEngine;
import com.ibm.team.build.setup.junit.internal.Messages;
import com.ibm.team.filesystem.setup.junit.constants.JUnitWorkspaces;
import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.ProcessDescription;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.setup.junit.constants.JUnitProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BuildContribution
implements IProjectSetupContribution {
    private ISetupContext fContext;

    public void contributeToProcessSpec(ISetupContext setup, ProcessDescription processSpec, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    public void contributeArtifacts(ISetupContext setup, ProcessDescription processDescription, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.BuildContribution_PROGRESS, (int)100);
        try {
            try {
                this.createBuildDefinitions(setup, (IProgressMonitor)progress.newChild(25));
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createBuildDefinitions(ISetupContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fContext = context;
        ITeamRepository repo = context.getTeamRepository();
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repo);
        IProcessArea processArea = (IProcessArea)context.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit);
        IWorkspaceConnection buildWorkspace = (IWorkspaceConnection)context.getArtifact((IPredefinedArtifact)JUnitWorkspaces.Build);
        if (processArea == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.BuildContribution_NO_TEAM_AREA, (Object)"JUnitTeamArea.Junit", (Object[])new Object[0]));
        }
        if (buildWorkspace == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.BuildContribution_NO_WORKSPACE, (Object)"JUnitWorkspaces.Build", (Object[])new Object[0]));
        }
        IBuildDefinition buildDefinition = buildClient.getBuildDefinition(JUnitBuildDefinition.JUnit.getId(), monitor);
        if (buildDefinition == null) {
            buildDefinition = BuildItemFactory.createBuildDefinition((IProcessArea)processArea);
            buildDefinition.setId(this.decorateForTVT(JUnitBuildDefinition.JUnit.getId()));
            buildDefinition.setIgnoreWarnings(true);
            IBuildDefinitionTemplate template = BuildConfigurationRegistry.getInstance().getBuildDefinitionTemplate("com.ibm.team.build.ant");
            buildDefinition.initializeConfiguration(template);
            IBuildConfigurationElement jazzScmElement = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement("com.ibm.team.build.jazzscm");
            buildDefinition.initializeConfiguration(jazzScmElement);
            IBuildConfigurationElement antElement = buildDefinition.getConfigurationElement("com.ibm.team.build.ant");
            String fetchDestination = "sandbox";
            String buildFilePath = String.valueOf(fetchDestination) + File.separator + "releng" + File.separator + "build.xml";
            this.addProperty(antElement, "com.ibm.team.build.ant.buildFile", buildFilePath);
            this.addProperty(antElement, "com.ibm.team.build.ant.antArgs", "-lib " + fetchDestination + File.separator + "releng" + File.separator + "compiler" + File.separator + "ecj.jar");
            this.addProperty(buildDefinition, "team.scm.fetchDestination", fetchDestination);
            this.addProperty(buildDefinition, "team.scm.workspaceUUID", buildWorkspace.getResolvedWorkspace().getItemId().getUuidValue());
            this.addProperty(buildDefinition, "team.scm.acceptBeforeFetch", "true");
            this.addProperty(buildDefinition, "team.scm.deleteDestinationBeforeFetch", "true");
            this.addProperty(buildDefinition, "buildLabelPrefix", "I", true);
            buildClient.save(buildDefinition, monitor);
        }
        context.registerArtifact((IPredefinedArtifact)JUnitBuildDefinition.JUnit, (Object)buildDefinition);
        IBuildEngine buildEngine = buildClient.getBuildEngine(JUnitBuildEngine.JUnit.getId(), monitor);
        if (buildEngine == null) {
            buildEngine = BuildItemFactory.createBuildEngine((IProcessArea)processArea);
            buildEngine.setId(this.decorateForTVT(JUnitBuildEngine.JUnit.getId()));
            buildEngine.setActive(true);
            buildEngine.setMonitoringThreshold(3);
            buildEngine.getSupportedBuildDefinitions().add(buildDefinition);
            buildClient.save(buildEngine, monitor);
        }
        context.registerArtifact((IPredefinedArtifact)JUnitBuildEngine.JUnit, (Object)buildEngine);
    }

    private void addProperty(IBuildConfigurationElement element, String name, String value) {
        IConfigurationProperty property = element.getConfigurationProperty(name);
        if (property == null) {
            property = BuildItemFactory.createConfigurationProperty();
            property.setName(name);
            element.getConfigurationProperties().add(property);
        }
        property.setValue(value);
    }

    private void addProperty(IBuildDefinition buildDefinition, String name, String value, boolean isGenericEditAllowed) {
        IBuildProperty property = buildDefinition.getProperty(name);
        if (property == null) {
            property = BuildItemFactory.createBuildProperty();
            property.setName(name);
            property.setGenericEditAllowed(isGenericEditAllowed);
            buildDefinition.getProperties().add(property);
        }
        property.setValue(value);
    }

    private void addProperty(IBuildDefinition buildDefinition, String name, String value) {
        this.addProperty(buildDefinition, name, value, false);
    }

    private String decorateForTVT(String input) {
        if (!this.fContext.createForTVTUse()) {
            return input;
        }
        return "ZZZ" + input + "ZZZ";
    }
}

