/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.build.internal.ui.notification.RoleSelectionDialog;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RoleTypesFetchJob
extends Job {
    private final ITeamRepository fTeamRepository;
    private final IProcessAreaHandle fProcessAreaHandle;
    private final RoleSelectionDialog fRoleSelectionDialog;

    public RoleTypesFetchJob(ITeamRepository teamRepository, IProcessAreaHandle processAreaHandle, RoleSelectionDialog dialog) {
        super(Messages.EditEmailNotificationCriteriaDialog_RoleTypesQueryJobName);
        this.fTeamRepository = teamRepository;
        this.fProcessAreaHandle = processAreaHandle;
        this.fRoleSelectionDialog = dialog;
    }

    protected boolean isRoleSelectionSelectionDialogDisposed() {
        return this.fRoleSelectionDialog.getShell() == null || this.fRoleSelectionDialog.getShell().isDisposed();
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected IStatus run(IProgressMonitor monitor) {
        final ArrayList<String> roleDefinitions = new ArrayList<String>();
        try {
            IProcessArea fProcessArea = (IProcessArea)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)this.fProcessAreaHandle, 1, monitor);
            IProcessItemService service = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
            IClientProcess clientProcess = service.getClientProcess(fProcessArea, monitor);
            IRole[] availableRoles = clientProcess.getRoles(fProcessArea, monitor);
            int i = 0;
            while (i < availableRoles.length) {
                roleDefinitions.add(availableRoles[i].getId());
                ++i;
            }
        }
        catch (TeamRepositoryException e) {
            return new Status(4, "com.ibm.team.build.notification.ui", Messages.EditEmailNotificationCriteriaDialog_RoleTypesQueryJobError, (Throwable)e);
        }
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RoleTypesFetchJob.this.isRoleSelectionSelectionDialogDisposed()) {
                    return;
                }
                RoleTypesFetchJob.this.fRoleSelectionDialog.setFetchingDone();
                RoleTypesFetchJob.this.fRoleSelectionDialog.setListElements(roleDefinitions.toArray(new String[roleDefinitions.size()]));
            }
        });
        return Status.OK_STATUS;
    }
}

