/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.build.internal.ui.notification.RoleTypesFetchJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RoleSelectionDialog
extends ElementListSelectionDialog {
    private Job fRoleFetchingJob;
    private boolean fJobRequired = false;
    private boolean fFetchingDone;
    private final ITeamRepository fTeamRepository;
    private final IProcessAreaHandle fProcessAreaHandle;
    private final String[] fRoleDefinitions;
    IStatus fStatus = null;
    IStatus fRealStatus = null;

    public RoleSelectionDialog(Shell parent, ITeamRepository teamRepository, IProcessAreaHandle processAreaHandle, String[] roleDefinitions) {
        super(parent, (ILabelProvider)new LabelProvider());
        this.fTeamRepository = teamRepository;
        this.fProcessAreaHandle = processAreaHandle;
        this.fRoleDefinitions = roleDefinitions;
        String title = Messages.EditEmailNotificationCriteriaDialog_RolesSelectionDialogTitle;
        String message = Messages.EditEmailNotificationCriteriaDialog_RolesSelectionDialogMessage;
        this.init(title, message);
    }

    protected void init(String title, String message) {
        this.setTitle(title);
        this.setMessage(message);
        this.setStatusLineAboveButtons(true);
        this.setMultipleSelection(true);
        this.setEmptyListMessage(Messages.EditEmailNotificationCriteriaDialog_RolesSelectionDialogNoRolesFoundMessage);
        if (this.fRoleDefinitions == null || this.fRoleDefinitions.length == 0) {
            this.fJobRequired = true;
            this.fRoleFetchingJob = this.createFetchRoleJob();
        }
    }

    protected Job createFetchRoleJob() {
        return new RoleTypesFetchJob(this.fTeamRepository, this.fProcessAreaHandle, this);
    }

    public void setListElements(Object[] elements) {
        super.setListElements(elements);
    }

    protected void updateStatus(IStatus status) {
        this.fRealStatus = status;
        super.updateStatus(status);
    }

    protected void setStatus(IStatus status) {
        super.updateStatus(status);
        this.fStatus = status;
    }

    protected void handleSelectionChanged() {
        if (this.fJobRequired) {
            if (this.fFetchingDone) {
                super.handleSelectionChanged();
                if (this.fStatus != null) {
                    super.updateStatus(this.fStatus);
                    this.updateButtonsEnableState(this.fRealStatus);
                }
            } else {
                this.getOkButton().setEnabled(false);
            }
        } else {
            super.handleSelectionChanged();
        }
    }

    public int open() {
        if (this.fJobRequired) {
            this.fRoleFetchingJob.schedule();
            this.fJobRequired = true;
            this.setElements(new Object[]{Messages.EditEmailNotificationCriteriaDialog_RolesSelectionDialogFetchingRolesMessage});
        } else {
            this.setElements(this.fRoleDefinitions);
        }
        return super.open();
    }

    public boolean close() {
        if (this.fRoleFetchingJob != null) {
            this.fRoleFetchingJob.cancel();
        }
        return super.close();
    }

    public void setFetchingDone() {
        this.fFetchingDone = true;
    }

    public boolean isFetchingDone() {
        return this.fFetchingDone;
    }
}

