/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.common.notification.NotificationCriteria;
import com.ibm.team.build.common.notification.NotificationCriteriaFromProjectConfigHelper;
import com.ibm.team.build.internal.ui.notification.AbstractUserNameRetrievalRunnable;
import com.ibm.team.build.internal.ui.notification.ContributorFetchJob;
import com.ibm.team.build.internal.ui.notification.EditEmailNotificationCriteriaDialog;
import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.AbstractConfigurationDataAspectEditor;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NotificationProcessAspectEditor
extends AbstractConfigurationDataAspectEditor {
    public static final String STATIC_CONFIGURATION_DATA_ID = "com.ibm.team.build.configuration.notification";
    public static final String PROCESS_ROLE_DEFINITIONS_NODE_NAME = "role-definitions";
    public static final String PROCESS_ROLE_ID_ATTRIBUTE_NAME = "role-id";
    private FormToolkit fToolkit;
    private CheckboxTableViewer fCriteriasViewer;
    private Button fAddCriteriaButton;
    private Button fEditCriteriaButton;
    private Button fRemoveCriteriaButton;
    private Text fCriteriaSummaryText;
    private ContributorFetchJob fSummaryJob;
    private List<String> fRoleDefinitions;
    private List<NotificationCriteria> fCriterias;
    private String fConfigurationDataId;

    public NotificationProcessAspectEditor(String configurationDataId) {
        if (!configurationDataId.equals(STATIC_CONFIGURATION_DATA_ID)) {
            throw new IllegalArgumentException("The configuration data id should be com.ibm.team.build.configuration.notification, not " + configurationDataId);
        }
        this.fConfigurationDataId = configurationDataId;
        this.fCriterias = new ArrayList<NotificationCriteria>();
        this.fRoleDefinitions = new ArrayList<String>();
    }

    private ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readXML();
    }

    private void reset() {
        this.fCriterias.clear();
        this.fRoleDefinitions.clear();
    }

    private void readXML() {
        this.reset();
        this.readRoleDefinitionsFromProcess();
        ModelElement configurationData = this.getSite().getConfigurationData(this.fConfigurationDataId);
        if (configurationData != null) {
            this.fCriterias.addAll(NotificationCriteriaFromProjectConfigHelper.getAllCriterias((ModelElement)configurationData));
        }
    }

    private void readRoleDefinitionsFromProcess() {
        ModelElement configurationElement = this.getAspect().getConfigurationRoot();
        List elements = configurationElement.getChildElements();
        for (Object element : elements) {
            ModelElement me = (ModelElement)element;
            if (!me.getName().equals(PROCESS_ROLE_DEFINITIONS_NODE_NAME)) continue;
            elements = me.getChildElements();
            for (Object e : elements) {
                String role = ((ModelElement)e).getAttribute(PROCESS_ROLE_ID_ATTRIBUTE_NAME);
                if (role == null) continue;
                this.fRoleDefinitions.add(role);
            }
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Composite composite = this.fToolkit.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Section notificationCriteriaSection = this.fToolkit.createSection(composite, 384);
        notificationCriteriaSection.setLayoutData((Object)new GridData(4, 4, true, true));
        notificationCriteriaSection.setText(Messages.NotificationProcessAspectEditor_NotificationSectionHeader);
        Composite outer = this.fToolkit.createComposite((Composite)notificationCriteriaSection);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outer.setLayout((Layout)layout);
        outer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fCriteriasViewer = new CheckboxTableViewer(this.fToolkit.createTable(outer, 2850));
        this.fCriteriasViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.fCriteriasViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fCriteriasViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                NotificationCriteria criteria = (NotificationCriteria)element;
                return criteria.getCriteriaName();
            }
        });
        this.fCriteriasViewer.setInput(this.fCriterias);
        for (NotificationCriteria criteria : this.fCriterias) {
            if (!criteria.isEnabled()) continue;
            this.fCriteriasViewer.setChecked((Object)criteria, true);
        }
        this.fAddCriteriaButton = this.fToolkit.createButton(outer, Messages.NotificationProcessAspectEditor_CriteriaAddButton, 8);
        this.fAddCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fCriteriaSummaryText = this.fToolkit.createText(outer, null, 16968);
        this.fCriteriaSummaryText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.fCriteriaSummaryText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.NotificationProcessAspectEditor_CriteriaSummaryAccessibilityLabel;
                }
            }
        });
        this.fEditCriteriaButton = this.fToolkit.createButton(outer, Messages.NotificationProcessAspectEditor_CriteriaEditButton, 8);
        this.fEditCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fEditCriteriaButton.setEnabled(false);
        this.fRemoveCriteriaButton = this.fToolkit.createButton(outer, Messages.NotificationProcessAspectEditor_CriteriaRemoveButton, 8);
        this.fRemoveCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveCriteriaButton.setEnabled(false);
        notificationCriteriaSection.setClient((Control)outer);
        this.attachListeners();
        this.fSummaryJob = new ContributorFetchJob(this.getTeamRepository(), (Control)this.fCriteriaSummaryText, new AbstractUserNameRetrievalRunnable(){

            @Override
            public void run() {
                NotificationProcessAspectEditor.this.updateCriteriaSummary(this.getUserNameMap());
            }
        });
        this.getSite().reflow();
    }

    protected void updateCriteriaSummary(Map<String, String> userNameMap) {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        NotificationCriteria criteria = (NotificationCriteria)selection.getFirstElement();
        if (criteria != null) {
            String summary = criteria.getCriteriaSummary(userNameMap, Text.DELIMITER);
            this.fCriteriaSummaryText.setText(summary);
        }
    }

    protected void handleCriteriaViewersSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        int size = selection.size();
        if (size == 1) {
            NotificationCriteria criteria = (NotificationCriteria)selection.getFirstElement();
            this.fSummaryJob.cancel();
            this.fSummaryJob.setUserIds(criteria.getUsers());
            this.fSummaryJob.schedule();
            String summary = criteria.getCriteriaSummary(null, Text.DELIMITER);
            this.fCriteriaSummaryText.setText(summary);
            this.fEditCriteriaButton.setEnabled(true);
        } else {
            this.fCriteriaSummaryText.setText("");
            this.fEditCriteriaButton.setEnabled(false);
        }
        this.fRemoveCriteriaButton.setEnabled(size != 0);
    }

    protected void handleCriteriaViewerCheckStateChanged(NotificationCriteria criteria, boolean checked) {
        criteria.setEnabled(checked);
        this.setDirty();
    }

    protected EditEmailNotificationCriteriaDialog createDialog(Control control, ITeamRepository teamRepository, IProcessAreaHandle processAreaHandle, NotificationCriteria criteria, String[] roleDefinitions) {
        return new EditEmailNotificationCriteriaDialog((Control)control.getShell(), teamRepository, null, criteria, roleDefinitions);
    }

    private EditEmailNotificationCriteriaDialog createDialog(Control control, NotificationCriteria criteria) {
        return this.createDialog((Control)control.getShell(), this.getTeamRepository(), null, criteria, this.fRoleDefinitions.toArray(new String[this.fRoleDefinitions.size()]));
    }

    protected void handleAddCriteriaButtonSelected() {
        NotificationCriteria criteria = new NotificationCriteria();
        EditEmailNotificationCriteriaDialog dialog = this.createDialog((Control)this.fAddCriteriaButton, criteria);
        if (dialog.open() == 0) {
            this.fCriterias.add(criteria);
            this.fCriteriasViewer.add((Object)criteria);
            if (criteria.isEnabled()) {
                this.fCriteriasViewer.setChecked((Object)criteria, true);
            }
            this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)criteria), true);
            this.setDirty();
        }
    }

    protected void handleEditCriteriaButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        this.editCriteria(selection);
    }

    protected void handleOpenCriteria(IStructuredSelection selection) {
        this.editCriteria(selection);
    }

    protected void editCriteria(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        NotificationCriteria criteria = (NotificationCriteria)selection.getFirstElement();
        EditEmailNotificationCriteriaDialog dialog = this.createDialog((Control)this.fEditCriteriaButton, criteria);
        if (dialog.open() == 0) {
            this.fCriteriasViewer.update((Object)criteria, null);
            this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)criteria));
            this.setDirty();
        }
    }

    protected void handleRemoveCriteriaButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        this.fCriterias.removeAll(selection.toList());
        this.fCriteriasViewer.refresh();
        this.setDirty();
    }

    private void attachListeners() {
        this.fCriteriasViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NotificationProcessAspectEditor.this.handleCriteriaViewersSelectionChanged();
            }
        });
        this.fCriteriasViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NotificationProcessAspectEditor.this.handleCriteriaViewerCheckStateChanged((NotificationCriteria)event.getElement(), event.getChecked());
            }
        });
        this.fCriteriasViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NotificationProcessAspectEditor.this.handleOpenCriteria((IStructuredSelection)event.getSelection());
            }
        });
        this.fAddCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationProcessAspectEditor.this.handleAddCriteriaButtonSelected();
            }
        });
        this.fEditCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationProcessAspectEditor.this.handleEditCriteriaButtonSelected();
            }
        });
        this.fRemoveCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationProcessAspectEditor.this.handleRemoveCriteriaButtonSelected();
            }
        });
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        if (this.fCriterias.isEmpty()) {
            return false;
        }
        NotificationCriteriaFromProjectConfigHelper.saveCriteriasIntoMemento((String)this.fConfigurationDataId, (IMemento)memento, this.fCriterias);
        return true;
    }

    public void revert() {
        super.revert();
        this.readXML();
        this.fCriteriasViewer.refresh();
        for (NotificationCriteria criteria : this.fCriterias) {
            if (!criteria.isEnabled()) continue;
            this.fCriteriasViewer.setChecked((Object)criteria, true);
        }
        this.fEditCriteriaButton.setEnabled(false);
        this.fRemoveCriteriaButton.setEnabled(false);
    }

    protected List<NotificationCriteria> getCriterias() {
        return this.fCriterias;
    }

    protected Collection<String> getRoleDefinitions() {
        return this.fRoleDefinitions;
    }

    protected CheckboxTableViewer getCriteriasViewer() {
        return this.fCriteriasViewer;
    }

    protected Button getAddCriteriaButton() {
        return this.fAddCriteriaButton;
    }

    protected Button getEditCriteriaButton() {
        return this.fEditCriteriaButton;
    }

    protected Button getRemoveCriteriaButton() {
        return this.fRemoveCriteriaButton;
    }
}

