/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.notification.NotificationCriteria;
import com.ibm.team.build.common.notification.NotificationCriteriaFromBuildDefinition;
import com.ibm.team.build.common.notification.NotificationCriteriaFromBuildDefinitionHelper;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.internal.ui.notification.AbstractUserNameRetrievalRunnable;
import com.ibm.team.build.internal.ui.notification.ContributorFetchJob;
import com.ibm.team.build.internal.ui.notification.EditEmailNotificationCriteriaDialog;
import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class NotificationConfigurationEditor
extends BasicConfigurationElementEditor {
    private FormToolkit fToolkit;
    private Section fNotificationCriteriaSection;
    private CheckboxTableViewer fCriteriasViewer;
    private Button fAddCriteriaButton;
    private Button fEditCriteriaButton;
    private Button fRemoveCriteriaButton;
    private Text fCriteriaSummaryText;
    private ContributorFetchJob fSummaryJob;
    private List<String> fRoleDefinitions;
    private List<NotificationCriteriaFromBuildDefinition> fCriterias = new ArrayList<NotificationCriteriaFromBuildDefinition>();

    public NotificationConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        this.fRoleDefinitions = new ArrayList<String>();
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.reset();
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fNotificationCriteriaSection = this.createSection(parent, Messages.NotificationConfigurationEditor_NotificationSectionHeader, Messages.NotificationConfigurationEditor_NotificationSectionDescription, true, 1);
        this.fNotificationCriteriaSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        Composite sectionContents = this.fToolkit.createComposite((Composite)this.fNotificationCriteriaSection);
        GridLayout sectionContentsLayout = new GridLayout(3, false);
        sectionContents.setLayout((Layout)sectionContentsLayout);
        this.fCriteriasViewer = new CheckboxTableViewer(this.fToolkit.createTable(sectionContents, 2850));
        GridDataFactory.fillDefaults().grab(true, true).span(1, 3).hint(100, this.fCriteriasViewer.getTable().getItemHeight() * 25).applyTo((Control)this.fCriteriasViewer.getTable());
        this.fCriteriasViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fCriteriasViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                NotificationCriteriaFromBuildDefinition criteria = (NotificationCriteriaFromBuildDefinition)element;
                return criteria.getCriteriaName();
            }
        });
        this.fCriteriasViewer.setInput(this.fCriterias);
        this.fAddCriteriaButton = this.fToolkit.createButton(sectionContents, Messages.NotificationConfigurationEditor_CriteriaAddButton, 8);
        this.fAddCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fCriteriaSummaryText = this.fToolkit.createText(sectionContents, null, 16968);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 3).hint(100, this.fCriteriaSummaryText.getLineHeight() * 25).applyTo((Control)this.fCriteriaSummaryText);
        this.fCriteriaSummaryText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.NotificationConfigurationEditor_CriteriaSummaryAccessibilityLabel;
                }
            }
        });
        this.fEditCriteriaButton = this.fToolkit.createButton(sectionContents, Messages.NotificationConfigurationEditor_CriteriaEditButton, 8);
        this.fEditCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fEditCriteriaButton.setEnabled(false);
        this.fRemoveCriteriaButton = this.fToolkit.createButton(sectionContents, Messages.NotificationConfigurationEditor_CriteriaRemoveButton, 8);
        this.fRemoveCriteriaButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveCriteriaButton.setEnabled(false);
        this.fNotificationCriteriaSection.setClient((Control)sectionContents);
        this.createNewCriteriasFromProperties();
        this.attachListeners();
        this.fSummaryJob = new ContributorFetchJob(this.getTeamRepository(), (Control)this.fCriteriaSummaryText, new AbstractUserNameRetrievalRunnable(){

            @Override
            public void run() {
                NotificationConfigurationEditor.this.updateCriteriaSummary(this.getUserNameMap());
            }
        });
        this.handleCriteriaViewersSelectionChanged();
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionemailnotification";
    }

    public boolean validate() {
        return true;
    }

    public Control getFocusControl() {
        return this.fCriteriasViewer.getTable();
    }

    private void reset() {
        this.fCriterias.clear();
        this.fRoleDefinitions.clear();
    }

    protected void updateCriteriaSummary(Map<String, String> userNameMap) {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        NotificationCriteriaFromBuildDefinition criteria = (NotificationCriteriaFromBuildDefinition)selection.getFirstElement();
        if (criteria != null) {
            String summary = criteria.getCriteriaSummary(userNameMap, Text.DELIMITER);
            this.fCriteriaSummaryText.setText(summary);
        }
    }

    protected void handleCriteriaViewersSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        int size = selection.size();
        if (size == 1) {
            NotificationCriteriaFromBuildDefinition criteria = (NotificationCriteriaFromBuildDefinition)selection.getFirstElement();
            this.fSummaryJob.cancel();
            this.fSummaryJob.setUserIds(criteria.getUsers());
            this.fSummaryJob.schedule();
            String summary = criteria.getCriteriaSummary(null, Text.DELIMITER);
            this.fCriteriaSummaryText.setText(summary);
            this.fEditCriteriaButton.setEnabled(true);
        } else {
            this.fCriteriaSummaryText.setText("");
            this.fEditCriteriaButton.setEnabled(false);
        }
        this.fRemoveCriteriaButton.setEnabled(size != 0);
    }

    protected void handleCriteriaViewerCheckStateChanged(NotificationCriteriaFromBuildDefinition criteria, boolean checked) {
        criteria.setEnabled(checked);
        NotificationCriteriaFromBuildDefinitionHelper.createPropertiesFromCriteria((IBuildDefinition)this.fWorkingCopy, (NotificationCriteriaFromBuildDefinition)criteria);
        this.setDirty(true);
    }

    protected EditEmailNotificationCriteriaDialog createDialog(Control control, ITeamRepository teamRepository, IProcessAreaHandle processArea, NotificationCriteriaFromBuildDefinition criteria, String[] roleDefinitions) {
        return new EditEmailNotificationCriteriaDialog((Control)control.getShell(), teamRepository, processArea, (NotificationCriteria)criteria, roleDefinitions);
    }

    private EditEmailNotificationCriteriaDialog createDialog(Control control, NotificationCriteriaFromBuildDefinition criteria) {
        return this.createDialog((Control)control.getShell(), this.getTeamRepository(), this.fWorkingCopy.getProcessArea(), criteria, this.fRoleDefinitions.toArray(new String[this.fRoleDefinitions.size()]));
    }

    protected void handleAddCriteriaButtonSelected() {
        NotificationCriteriaFromBuildDefinition newCriteria = new NotificationCriteriaFromBuildDefinition();
        EditEmailNotificationCriteriaDialog dialog = this.createDialog((Control)this.fAddCriteriaButton, newCriteria);
        if (dialog.open() == 0) {
            this.fCriterias.add(newCriteria);
            this.fCriteriasViewer.add((Object)newCriteria);
            if (newCriteria.isEnabled()) {
                this.fCriteriasViewer.setChecked((Object)newCriteria, true);
            }
            this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)newCriteria), true);
            this.fCriteriasViewer.update((Object)newCriteria, null);
            this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)newCriteria));
            int numCriterias = NotificationCriteriaFromBuildDefinitionHelper.getNumCriteriasProperty((IBuildDefinition)this.fWorkingCopy);
            newCriteria.setPropertyNamePrefixNumber(numCriterias);
            NotificationCriteriaFromBuildDefinitionHelper.createPropertiesFromCriteria((IBuildDefinition)this.fWorkingCopy, (NotificationCriteriaFromBuildDefinition)newCriteria);
            this.fWorkingCopy.setConfigurationProperty("com.ibm.team.build.email", "build.email.numCriteria", Integer.toString(numCriterias + 1));
            this.setDirty(true);
        }
    }

    protected void handleEditCriteriaButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        this.editCriteria(selection);
    }

    protected void handleOpenCriteria(IStructuredSelection selection) {
        this.editCriteria(selection);
    }

    protected void editCriteria(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        NotificationCriteriaFromBuildDefinition modifiedCriteria = (NotificationCriteriaFromBuildDefinition)selection.getFirstElement();
        EditEmailNotificationCriteriaDialog dialog = this.createDialog((Control)this.fEditCriteriaButton, modifiedCriteria);
        if (dialog.open() == 0) {
            this.fCriteriasViewer.update((Object)modifiedCriteria, null);
            this.fCriteriasViewer.refresh();
            this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)modifiedCriteria));
            NotificationCriteriaFromBuildDefinitionHelper.createPropertiesFromCriteria((IBuildDefinition)this.fWorkingCopy, (NotificationCriteriaFromBuildDefinition)modifiedCriteria);
            this.setDirty(true);
        }
    }

    protected void handleRemoveCriteriaButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fCriteriasViewer.getSelection();
        this.fCriterias.removeAll(selection.toList());
        this.fCriteriasViewer.refresh();
        this.createNewPropertiesFromExistingCriteria();
        this.setDirty(true);
    }

    private void attachListeners() {
        this.fCriteriasViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NotificationConfigurationEditor.this.handleCriteriaViewersSelectionChanged();
            }
        });
        this.fCriteriasViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NotificationConfigurationEditor.this.handleCriteriaViewerCheckStateChanged((NotificationCriteriaFromBuildDefinition)event.getElement(), event.getChecked());
            }
        });
        this.fCriteriasViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NotificationConfigurationEditor.this.handleOpenCriteria((IStructuredSelection)event.getSelection());
            }
        });
        this.fAddCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationConfigurationEditor.this.handleAddCriteriaButtonSelected();
            }
        });
        this.fEditCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationConfigurationEditor.this.handleEditCriteriaButtonSelected();
            }
        });
        this.fRemoveCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationConfigurationEditor.this.handleRemoveCriteriaButtonSelected();
            }
        });
    }

    protected List<NotificationCriteriaFromBuildDefinition> getCriterias() {
        return this.fCriterias;
    }

    protected Collection<String> getRoleDefinitions() {
        return this.fRoleDefinitions;
    }

    protected CheckboxTableViewer getCriteriasViewer() {
        return this.fCriteriasViewer;
    }

    protected Button getAddCriteriaButton() {
        return this.fAddCriteriaButton;
    }

    protected Button getEditCriteriaButton() {
        return this.fEditCriteriaButton;
    }

    protected Button getRemoveCriteriaButton() {
        return this.fRemoveCriteriaButton;
    }

    protected Text getSummaryLabel() {
        return this.fCriteriaSummaryText;
    }

    protected void createNewCriteriasFromProperties() {
        int numCriterias = NotificationCriteriaFromBuildDefinitionHelper.getNumCriteriasProperty((IBuildDefinition)this.fWorkingCopy);
        int i = 0;
        while (i < numCriterias) {
            NotificationCriteriaFromBuildDefinition newCriteria = NotificationCriteriaFromBuildDefinitionHelper.getCriteriaFromProperties((IBuildDefinition)this.fWorkingCopy, (int)i);
            if (newCriteria != null) {
                this.fCriterias.add(newCriteria);
                this.fCriteriasViewer.add((Object)newCriteria);
                if (newCriteria.isEnabled()) {
                    this.fCriteriasViewer.setChecked((Object)newCriteria, true);
                }
                this.fCriteriasViewer.update((Object)newCriteria, null);
                this.fCriteriasViewer.setSelection((ISelection)new StructuredSelection((Object)newCriteria));
            }
            ++i;
        }
    }

    protected void createNewPropertiesFromExistingCriteria() {
        int numCriterias = NotificationCriteriaFromBuildDefinitionHelper.getNumCriteriasProperty((IBuildDefinition)this.fWorkingCopy);
        int i = 0;
        while (i < numCriterias) {
            NotificationCriteriaFromBuildDefinitionHelper.deleteCriteriaProperties((IBuildDefinition)this.fWorkingCopy, (int)i);
            ++i;
        }
        this.fWorkingCopy.setConfigurationProperty("com.ibm.team.build.email", "build.email.numCriteria", Integer.toString(0));
        TableItem[] children = this.fCriteriasViewer.getTable().getItems();
        ArrayList<NotificationCriteriaFromBuildDefinition> criterias = new ArrayList<NotificationCriteriaFromBuildDefinition>();
        int i2 = 0;
        while (i2 < children.length) {
            TableItem item = children[i2];
            if (item.getData() instanceof NotificationCriteriaFromBuildDefinition) {
                criterias.add((NotificationCriteriaFromBuildDefinition)item.getData());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < criterias.size()) {
            ((NotificationCriteriaFromBuildDefinition)criterias.get(i2)).setPropertyNamePrefixNumber(i2);
            NotificationCriteriaFromBuildDefinitionHelper.createPropertiesFromCriteria((IBuildDefinition)this.fWorkingCopy, (NotificationCriteriaFromBuildDefinition)((NotificationCriteriaFromBuildDefinition)criterias.get(i2)));
            this.fWorkingCopy.setConfigurationProperty("com.ibm.team.build.email", "build.email.numCriteria", Integer.toString(i2 + 1));
            ++i2;
        }
    }
}

