/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.common.notification.NotificationCriteria;
import com.ibm.team.build.internal.ui.notification.AbstractUserNameRetrievalRunnable;
import com.ibm.team.build.internal.ui.notification.ContributorFetchJob;
import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.build.internal.ui.notification.RoleSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditEmailNotificationCriteriaDialog
extends Dialog {
    private NotificationCriteria fCriteria;
    private Button fPersonalBuildButton;
    private Text fCriteriaText;
    private Button fCompletedBuildButton;
    private Button fCompletedBuildReportAlwaysButton;
    private Button fCompletedBuildReportErrorsButton;
    private Button fAbandonedBuildButton;
    private Button fAbandonedBuildReportAlwaysButton;
    private Button fAbandonedBuildReportErrorsButton;
    private TableViewer fEmailsViewer;
    private Button fAddEmailButton;
    private Button fRemoveEmailButton;
    private TableViewer fUsersViewer;
    private Button fAddUsersButton;
    private Button fRemoveUserButton;
    private TableViewer fRolesViewer;
    private Button fAddRolesButton;
    private Button fRemoveRolesButton;
    private Button fChangesDelivererButton;
    private Button fBuildRequestorButton;
    private Button okButton;
    private ContributorsQueryJob fContributorsQueryJob = new ContributorsQueryJob();
    private ITeamRepository fTeamRepository;
    private IProcessAreaHandle fProcessAreaHandle;
    private String[] fRoleDefinitions;
    private Set<String> fSelectedRoles;
    private Map<String, String> fUserIds;
    private Set<String> fEmails;

    public EditEmailNotificationCriteriaDialog(Control control, ITeamRepository teamRepository, IProcessAreaHandle processAreaHandle, NotificationCriteria criteria, String[] roleDefinitions) {
        super(control.getShell());
        this.fTeamRepository = teamRepository;
        this.fProcessAreaHandle = processAreaHandle;
        this.fCriteria = criteria;
        this.fRoleDefinitions = roleDefinitions;
        this.fSelectedRoles = new HashSet<String>();
        this.fUserIds = new HashMap<String, String>();
        this.fEmails = new HashSet<String>();
        this.fSelectedRoles.addAll(Arrays.asList(this.fCriteria.getRoles()));
        String[] stringArray = this.fCriteria.getUsers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            this.fUserIds.put(user, "");
            ++n2;
        }
        this.fEmails.addAll(Arrays.asList(this.fCriteria.getEmails()));
    }

    public void create() {
        super.create();
        this.okButton.setEnabled(!this.fCriteria.getCriteriaName().trim().equals(""));
        final String[] userIds = this.fUserIds.keySet().toArray(new String[this.fUserIds.size()]);
        ContributorFetchJob job = new ContributorFetchJob(this.fTeamRepository, (Control)this.fUsersViewer.getTable(), new AbstractUserNameRetrievalRunnable(){

            @Override
            public void run() {
                Map<String, String> userNameMap = this.getUserNameMap();
                int i = 0;
                while (i < userIds.length) {
                    if (EditEmailNotificationCriteriaDialog.this.fUserIds.containsKey(userIds[i])) {
                        EditEmailNotificationCriteriaDialog.this.fUserIds.put(userIds[i], userNameMap.get(userIds[i]));
                    }
                    ++i;
                }
                EditEmailNotificationCriteriaDialog.this.fUsersViewer.refresh();
            }
        });
        job.setUserIds(userIds);
        job.schedule();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EditEmailNotificationCriteriaDialog_DialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = true;
        GC gc = new GC((Drawable)composite);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics metrics = gc.getFontMetrics();
        int widthHint = metrics.getAverageCharWidth() * 8;
        gc.dispose();
        this.fPersonalBuildButton = new Button(composite, 32);
        this.fPersonalBuildButton.setText(Messages.EditEmailNotificationCriteriaDialog_PersonalBuildButtonText);
        this.fPersonalBuildButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fPersonalBuildButton.setSelection(this.fCriteria.isPersonalCriteria());
        this.createNotificationCriteriaGroup(composite, widthHint);
        this.createEmailAddressesGroup(composite);
        this.createUsersGroup(composite);
        this.createRolesGroup(composite);
        this.fCriteriaText.setFocus();
        this.addListeners();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
    }

    private void createNotificationCriteriaGroup(Composite composite, int widthHint) {
        Group group = new Group(composite, 0);
        group.setText(Messages.EditEmailNotificationCriteriaDialog_EmailNotificationCriteriaHeader);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 16384);
        label.setText(Messages.EditEmailNotificationCriteriaDialog_CriteriaNameLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fCriteriaText = new Text((Composite)group, 2048);
        this.fCriteriaText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fCriteriaText.setText(this.fCriteria.getCriteriaName());
        Composite nested = new Composite((Composite)group, 0);
        nested.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nested.setLayout((Layout)layout);
        new Label(nested, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        this.fCompletedBuildButton = new Button(nested, 32);
        this.fCompletedBuildButton.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fCompletedBuildButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationCompletedCriteria);
        this.fCompletedBuildButton.setSelection(this.fCriteria.getNotifyCompletedCondition() != NotificationCriteria.NotifyCondition.NEVER);
        GridData data = new GridData(1, 1, false, false);
        data.widthHint = widthHint;
        Composite radioComposite = new Composite(nested, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        radioComposite.setLayout((Layout)layout);
        new Label(radioComposite, 0).setLayoutData((Object)data);
        this.fCompletedBuildReportAlwaysButton = new Button(radioComposite, 16);
        this.fCompletedBuildReportAlwaysButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationAlways);
        this.fCompletedBuildReportAlwaysButton.setEnabled(this.fCriteria.getNotifyCompletedCondition() != NotificationCriteria.NotifyCondition.NEVER);
        this.fCompletedBuildReportErrorsButton = new Button(radioComposite, 16);
        this.fCompletedBuildReportErrorsButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationErrors);
        this.fCompletedBuildReportErrorsButton.setEnabled(this.fCriteria.getNotifyCompletedCondition() != NotificationCriteria.NotifyCondition.NEVER);
        if (this.fCriteria.getNotifyCompletedCondition() != NotificationCriteria.NotifyCondition.NEVER) {
            this.fCompletedBuildReportAlwaysButton.setEnabled(true);
            this.fCompletedBuildReportErrorsButton.setEnabled(true);
            this.fCompletedBuildReportAlwaysButton.setSelection(this.fCriteria.getNotifyCompletedCondition() == NotificationCriteria.NotifyCondition.ALWAYS);
            this.fCompletedBuildReportErrorsButton.setSelection(this.fCriteria.getNotifyCompletedCondition() == NotificationCriteria.NotifyCondition.ON_ERROR);
        } else {
            this.fCompletedBuildReportAlwaysButton.setEnabled(false);
            this.fCompletedBuildReportErrorsButton.setEnabled(false);
            this.fCompletedBuildReportAlwaysButton.setSelection(false);
            this.fCompletedBuildReportErrorsButton.setSelection(true);
        }
        this.fAbandonedBuildButton = new Button(nested, 32);
        this.fAbandonedBuildButton.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fAbandonedBuildButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationAbandonedCriteria);
        this.fAbandonedBuildButton.setSelection(this.fCriteria.getNotifyAbandonedCondition() != NotificationCriteria.NotifyCondition.NEVER);
        radioComposite = new Composite(nested, 0);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        radioComposite.setLayout((Layout)layout);
        data = new GridData(1, 1, false, false);
        data.widthHint = widthHint;
        new Label(radioComposite, 0).setLayoutData((Object)data);
        this.fAbandonedBuildReportAlwaysButton = new Button(radioComposite, 16);
        this.fAbandonedBuildReportAlwaysButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationAlways);
        this.fAbandonedBuildReportErrorsButton = new Button(radioComposite, 16);
        this.fAbandonedBuildReportErrorsButton.setText(Messages.EditEmailNotificationCriteriaDialog_NotificationErrors);
        if (this.fCriteria.getNotifyAbandonedCondition() != NotificationCriteria.NotifyCondition.NEVER) {
            this.fAbandonedBuildReportAlwaysButton.setEnabled(true);
            this.fAbandonedBuildReportErrorsButton.setEnabled(true);
            this.fAbandonedBuildReportAlwaysButton.setSelection(this.fCriteria.getNotifyAbandonedCondition() == NotificationCriteria.NotifyCondition.ALWAYS);
            this.fAbandonedBuildReportErrorsButton.setSelection(this.fCriteria.getNotifyAbandonedCondition() == NotificationCriteria.NotifyCondition.ON_ERROR);
        } else {
            this.fAbandonedBuildReportAlwaysButton.setEnabled(false);
            this.fAbandonedBuildReportErrorsButton.setEnabled(false);
            this.fAbandonedBuildReportAlwaysButton.setSelection(true);
            this.fAbandonedBuildReportErrorsButton.setSelection(false);
        }
    }

    private void createEmailAddressesGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.EditEmailNotificationCriteriaDialog_EmailAddressesHeader);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        this.fEmailsViewer = new TableViewer((Composite)group, 2050);
        this.fEmailsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fEmailsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fEmailsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fEmailsViewer.setComparator(new ViewerComparator());
        this.fEmailsViewer.setInput(this.fEmails);
        this.fAddEmailButton = new Button((Composite)group, 8);
        this.fAddEmailButton.setText(Messages.EditEmailNotificationCriteriaDialog_EmailAddressesAddButton);
        this.fAddEmailButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveEmailButton = new Button((Composite)group, 8);
        this.fRemoveEmailButton.setText(Messages.EditEmailNotificationCriteriaDialog_EmailAddressesRemoveButton);
        this.fRemoveEmailButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveEmailButton.setEnabled(false);
    }

    private void createUsersGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.EditEmailNotificationCriteriaDialog_UsersHeader);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        this.fUsersViewer = new TableViewer((Composite)group, 2050);
        this.fUsersViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fUsersViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals("")) {
                    return key;
                }
                return String.valueOf(key) + " (" + value + ")";
            }
        });
        this.fUsersViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Map)inputElement).entrySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fUsersViewer.setComparator(new ViewerComparator());
        this.fUsersViewer.setInput(this.fUserIds);
        this.fAddUsersButton = new Button((Composite)group, 8);
        this.fAddUsersButton.setText(Messages.EditEmailNotificationCriteriaDialog_UsersAddButton);
        this.fAddUsersButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveUserButton = new Button((Composite)group, 8);
        this.fRemoveUserButton.setText(Messages.EditEmailNotificationCriteriaDialog_UsersRemoveButton);
        this.fRemoveUserButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveUserButton.setEnabled(false);
        this.fChangesDelivererButton = new Button((Composite)group, 32);
        this.fChangesDelivererButton.setText(Messages.EditEmailNotificationCriteriaDialog_UsersChangesCriteria);
        this.fChangesDelivererButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fChangesDelivererButton.setSelection(this.fCriteria.isNotifySCM());
        this.fBuildRequestorButton = new Button((Composite)group, 32);
        this.fBuildRequestorButton.setText(Messages.EditEmailNotificationCriteriaDialog_UsersRequestCriteria);
        this.fBuildRequestorButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fBuildRequestorButton.setSelection(this.fCriteria.isNotifyRequestor());
    }

    private void createRolesGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.EditEmailNotificationCriteriaDialog_RolesHeader);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        this.fRolesViewer = new TableViewer((Composite)group, 2050);
        this.fRolesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.fRolesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fRolesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fRolesViewer.setComparator(new ViewerComparator());
        this.fRolesViewer.setInput(this.fSelectedRoles);
        this.fAddRolesButton = new Button((Composite)group, 8);
        this.fAddRolesButton.setText(Messages.EditEmailNotificationCriteriaDialog_RolesAddButton);
        this.fAddRolesButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveRolesButton = new Button((Composite)group, 8);
        this.fRemoveRolesButton.setText(Messages.EditEmailNotificationCriteriaDialog_RolesRemoveButton);
        this.fRemoveRolesButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fRemoveRolesButton.setEnabled(false);
    }

    protected void handleCompletedBuildButtonSelected() {
        boolean enabled = this.fCompletedBuildButton.getSelection();
        this.fCompletedBuildReportAlwaysButton.setEnabled(enabled);
        this.fCompletedBuildReportErrorsButton.setEnabled(enabled);
    }

    protected void handleAbandonedBuildButtonSelected() {
        boolean enabled = this.fAbandonedBuildButton.getSelection();
        this.fAbandonedBuildReportAlwaysButton.setEnabled(enabled);
        this.fAbandonedBuildReportErrorsButton.setEnabled(enabled);
    }

    protected void handleEmailSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fEmailsViewer.getSelection();
        this.fRemoveEmailButton.setEnabled(!selection.isEmpty());
    }

    protected IInputValidator getEmailValidator() {
        return new IInputValidator(){

            public String isValid(String email) {
                if (email.trim().length() == 0) {
                    return "";
                }
                if (email.contains(",")) {
                    return NLS.bind((String)Messages.EditEmailNotificationCriteriaDialog_EmailAddressesSeparatorCharactersNotAllowedMessage, (Object)",");
                }
                Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
                Matcher m = p.matcher(email);
                boolean matchFound = m.matches();
                if (matchFound) {
                    return null;
                }
                return Messages.EditEmailNotificationCriteriaDialog_EmailAddressesInvalidEmailMessage;
            }
        };
    }

    protected InputDialog getEmailInputDialog() {
        return new InputDialog(this.fAddEmailButton.getShell(), Messages.EditEmailNotificationCriteriaDialog_EmailAddressesPromptTitle, Messages.EditEmailNotificationCriteriaDialog_EmailAddressesPromptDescription, null, this.getEmailValidator());
    }

    protected void handleAddEmailButtonSelected() {
        InputDialog inputDialog = this.getEmailInputDialog();
        if (inputDialog.open() == 0 && this.fEmails.add(inputDialog.getValue().trim())) {
            this.fEmailsViewer.refresh();
        }
    }

    protected void handleRemoveEmailButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fEmailsViewer.getSelection();
        this.fEmails.removeAll(selection.toList());
        this.fEmailsViewer.refresh();
    }

    protected void handleUserSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fUsersViewer.getSelection();
        this.fRemoveUserButton.setEnabled(!selection.isEmpty());
    }

    protected void handleAddUserButtonSelected() {
        TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.fAddUsersButton.getShell(), this.fTeamRepository);
        dialog.setShellTitle(Messages.EditEmailNotificationCriteriaDialog_TeamContributorSelectionDialogTitle);
        dialog.setTitle(Messages.EditEmailNotificationCriteriaDialog_TeamContributorSelectionDialogTitle);
        dialog.setMessage(Messages.EditEmailNotificationCriteriaDialog_TeamContributorSelectionDialogMessage);
        if (dialog.open() == 0) {
            IContributorHandle[] result = dialog.getContributorResult();
            this.addSelectedContributors(result);
        }
    }

    protected void handleRemoveUserButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fUsersViewer.getSelection();
        for (Map.Entry entry : selection) {
            this.fUserIds.remove(entry.getKey());
        }
        this.fUsersViewer.refresh();
    }

    protected void handleRoleSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fRolesViewer.getSelection();
        this.fRemoveRolesButton.setEnabled(!selection.isEmpty());
    }

    protected void handleRemoveRoleButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fRolesViewer.getSelection();
        this.fSelectedRoles.removeAll(selection.toList());
        this.fRolesViewer.refresh();
    }

    private void addListeners() {
        this.fCriteriaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditEmailNotificationCriteriaDialog.this.okButton.setEnabled(!EditEmailNotificationCriteriaDialog.this.fCriteriaText.getText().trim().equals(""));
            }
        });
        this.fCompletedBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleCompletedBuildButtonSelected();
            }
        });
        this.fAbandonedBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleAbandonedBuildButtonSelected();
            }
        });
        this.fEmailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditEmailNotificationCriteriaDialog.this.handleEmailSelectionChanged();
            }
        });
        this.fAddEmailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleAddEmailButtonSelected();
            }
        });
        this.fRemoveEmailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleRemoveEmailButtonSelected();
            }
        });
        this.fUsersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditEmailNotificationCriteriaDialog.this.handleUserSelectionChanged();
            }
        });
        this.fAddUsersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleAddUserButtonSelected();
            }
        });
        this.fRemoveUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleRemoveUserButtonSelected();
            }
        });
        this.fRolesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditEmailNotificationCriteriaDialog.this.handleRoleSelectionChanged();
            }
        });
        this.fAddRolesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleAddRolesButtonSelected();
            }
        });
        this.fRemoveRolesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEmailNotificationCriteriaDialog.this.handleRemoveRoleButtonSelected();
            }
        });
    }

    protected NotificationCriteria getCriteria() {
        return this.fCriteria;
    }

    protected Button getPersonalBuildButton() {
        return this.fPersonalBuildButton;
    }

    protected Text getCriteriaText() {
        return this.fCriteriaText;
    }

    protected Button getCompletedBuildButton() {
        return this.fCompletedBuildButton;
    }

    protected Button getCompletedBuildReportAlwaysButton() {
        return this.fCompletedBuildReportAlwaysButton;
    }

    protected Button getCompletedBuildReportErrorsButton() {
        return this.fCompletedBuildReportErrorsButton;
    }

    protected Button getAbandonedBuildButton() {
        return this.fAbandonedBuildButton;
    }

    protected Button getAbandonedBuildReportAlwaysButton() {
        return this.fAbandonedBuildReportAlwaysButton;
    }

    protected Button getAbandonedBuildReportErrorsButton() {
        return this.fAbandonedBuildReportErrorsButton;
    }

    protected TableViewer getEmailsViewer() {
        return this.fEmailsViewer;
    }

    protected Button getAddEmailButton() {
        return this.fAddEmailButton;
    }

    protected Button getRemoveEmailButton() {
        return this.fRemoveEmailButton;
    }

    protected TableViewer getUsersViewer() {
        return this.fUsersViewer;
    }

    protected Button getAddUsersButton() {
        return this.fAddUsersButton;
    }

    protected Button getRemoveUserButton() {
        return this.fRemoveUserButton;
    }

    protected TableViewer getRolesViewer() {
        return this.fRolesViewer;
    }

    protected Button getAddRolesButton() {
        return this.fAddRolesButton;
    }

    protected Button getRemoveRolesButton() {
        return this.fRemoveRolesButton;
    }

    protected Button getChangesDelivererButton() {
        return this.fChangesDelivererButton;
    }

    protected Button getBuildRequestorButton() {
        return this.fBuildRequestorButton;
    }

    protected Button getOKButton() {
        return this.okButton;
    }

    protected void okPressed() {
        this.fCriteria.setPersonalCriteria(this.fPersonalBuildButton.getSelection());
        this.fCriteria.setCriteriaName(this.fCriteriaText.getText());
        NotificationCriteria.NotifyCondition completedCondition = !this.fCompletedBuildButton.getSelection() ? NotificationCriteria.NotifyCondition.NEVER : (this.fCompletedBuildReportAlwaysButton.getSelection() ? NotificationCriteria.NotifyCondition.ALWAYS : NotificationCriteria.NotifyCondition.ON_ERROR);
        this.fCriteria.setNotifyCompletedCondition(completedCondition);
        NotificationCriteria.NotifyCondition abandonedCondition = !this.fAbandonedBuildButton.getSelection() ? NotificationCriteria.NotifyCondition.NEVER : (this.fAbandonedBuildReportAlwaysButton.getSelection() ? NotificationCriteria.NotifyCondition.ALWAYS : NotificationCriteria.NotifyCondition.ON_ERROR);
        this.fCriteria.setNotifyAbandonedCondition(abandonedCondition);
        this.fCriteria.setEmails(this.fEmails.toArray(new String[this.fEmails.size()]));
        this.fCriteria.setNotifySCM(this.fChangesDelivererButton.getSelection());
        this.fCriteria.setNotifyRequestor(this.fBuildRequestorButton.getSelection());
        this.fCriteria.setUsers(this.fUserIds.keySet().toArray(new String[this.fUserIds.size()]));
        this.fCriteria.setRoles(this.fSelectedRoles.toArray(new String[this.fSelectedRoles.size()]));
        super.okPressed();
    }

    private void addSelectedContributors(IContributorHandle[] result) {
        this.fContributorsQueryJob.addHandles(result);
        this.fContributorsQueryJob.setSystem(true);
        this.fContributorsQueryJob.schedule();
    }

    private void refreshContributors() {
        Control control = this.fUsersViewer.getControl();
        if (!control.isDisposed()) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!EditEmailNotificationCriteriaDialog.this.fUsersViewer.getControl().isDisposed()) {
                        EditEmailNotificationCriteriaDialog.this.fUsersViewer.refresh();
                    }
                }
            });
        }
    }

    protected RoleSelectionDialog getRoleSelectionDialog(Shell shell) {
        return new RoleSelectionDialog(shell, this.fTeamRepository, this.fProcessAreaHandle, this.fRoleDefinitions);
    }

    protected void handleAddRolesButtonSelected() {
        RoleSelectionDialog dialog = this.getRoleSelectionDialog(this.fAddRolesButton.getShell());
        if (dialog.open() == 0) {
            boolean modified = false;
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                modified |= this.fSelectedRoles.add((String)o);
                ++n2;
            }
            if (modified) {
                this.fRolesViewer.refresh();
            }
        }
    }

    class ContributorsQueryJob
    extends Job {
        private List<IContributorHandle> fHandles;

        public ContributorsQueryJob() {
            super(Messages.EditEmailNotificationCriteriaDialog_ContributorsQueryJobName);
            this.fHandles = Collections.synchronizedList(new ArrayList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHandles(IContributorHandle[] handles) {
            List<IContributorHandle> list = this.fHandles;
            synchronized (list) {
                this.fHandles.addAll(Arrays.asList(handles));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<IContributorHandle> getHandles() {
            List<IContributorHandle> list = this.fHandles;
            synchronized (list) {
                ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>(this.fHandles);
                this.fHandles.clear();
                return handles;
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                List<IContributorHandle> handles = this.getHandles();
                List items = EditEmailNotificationCriteriaDialog.this.fTeamRepository.itemManager().fetchCompleteItems(handles, 0, monitor);
                for (Object object : items) {
                    IContributor contributor = (IContributor)object;
                    if (EditEmailNotificationCriteriaDialog.this.fUserIds.containsKey(contributor.getUserId())) continue;
                    EditEmailNotificationCriteriaDialog.this.fUserIds.put(contributor.getUserId(), contributor.getName());
                }
                EditEmailNotificationCriteriaDialog.this.refreshContributors();
                if (!this.fHandles.isEmpty()) {
                    this.schedule();
                }
            }
            catch (TeamRepositoryException e) {
                return new Status(4, "com.ibm.team.build.notification.ui", Messages.EditEmailNotificationCriteriaDialog_ContributorsQueryJobError, (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

