/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.notification;

import com.ibm.team.build.internal.ui.notification.AbstractUserNameRetrievalRunnable;
import com.ibm.team.build.internal.ui.notification.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ContributorFetchJob
extends Job {
    private final ITeamRepository fTeamRepository;
    private final Control fControl;
    private final Display fDisplay;
    private final AbstractUserNameRetrievalRunnable fRunnable;
    private String[] fUserIds = new String[0];

    public ContributorFetchJob(ITeamRepository teamRepository, Control control, AbstractUserNameRetrievalRunnable runnable) {
        super(Messages.EditEmailNotificationCriteriaDialog_ContributorsQueryJobName);
        this.fTeamRepository = teamRepository;
        this.fControl = control;
        this.fDisplay = control.getDisplay();
        this.fRunnable = runnable;
    }

    public synchronized void setUserIds(String[] userIds) {
        this.fUserIds = userIds;
    }

    private synchronized String[] getUserIds() {
        return this.fUserIds;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String[] userIds = this.getUserIds();
        final HashMap<String, String> userNames = new HashMap<String, String>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)userIds.length);
        int i = 0;
        while (i < userIds.length) {
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                userNames.put(userIds[i], this.fTeamRepository.contributorManager().fetchContributorByUserId(userIds[i], (IProgressMonitor)subMonitor.newChild(1)).getName());
            }
            catch (TeamRepositoryException e) {
                return Status.CANCEL_STATUS;
            }
            ++i;
        }
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ContributorFetchJob.this.fControl.isDisposed()) {
                    ContributorFetchJob.this.fRunnable.setUserNameMap(userNames);
                    ContributorFetchJob.this.fRunnable.run();
                }
            }
        });
        return Status.OK_STATUS;
    }
}

