/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.ui;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.jface.JazzResources;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LiveLogUIPlugin
extends AbstractUIPlugin {
    private static LiveLogUIPlugin fLiveLogPlugin;
    private ResourceManager fResourceManager;
    public static final String PLUGIN_ID = "com.ibm.team.build.logging.ui";
    public static final String PREF_CONSOLE_VERBOSE = "com.ibm.team.build.console.verbose";
    public static final String PREF_CONSOLE_SHOW_TIMESTAMPS = "com.ibm.team.build.console.timestamp";
    public static final String PREF_CONSOLE_PREPROCESSING_LEVEL = "com.ibm.team.build.console.preprocessingLevel";
    private static final String SYSPROP_LIVELOGGING_FEATURE_ENABLED = "com.ibm.team.build.logging.enabled";
    private static final String SYSPROP_LIVELOGGING_BUILD_MONITORING_ENABLED = "com.ibm.team.build.logging.buildmonitoring.enabled";

    public LiveLogUIPlugin() {
        fLiveLogPlugin = this;
    }

    public static boolean isLiveLoggingFeatureEnabled() {
        return Boolean.valueOf(System.getProperty(SYSPROP_LIVELOGGING_FEATURE_ENABLED));
    }

    public static LiveLogUIPlugin getDefault() {
        return fLiveLogPlugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        LiveLogUIPlugin.log((IStatus)new Status(4, LiveLogUIPlugin.getUniqueIdentifier(), 4, message, exception));
    }

    public static void log(String message) {
        if (message == null) {
            message = "";
        }
        LiveLogUIPlugin.log((IStatus)new Status(4, LiveLogUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = LiveLogUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)LiveLogUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
            image = imageRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageRegistry imageRegistry = LiveLogUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor descriptor = imageRegistry.getDescriptor(path);
        if (descriptor == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)LiveLogUIPlugin.getUniqueIdentifier(), (String)path);
            imageRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)LiveLogUIPlugin.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            Job.getJobManager().cancel((Object)fLiveLogPlugin);
        }
        finally {
            super.stop(context);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PREF_CONSOLE_VERBOSE, true);
        store.setDefault(PREF_CONSOLE_SHOW_TIMESTAMPS, true);
        store.setDefault(PREF_CONSOLE_PREPROCESSING_LEVEL, -1);
    }

    public static void log(String message, Throwable exception) {
        LiveLogUIPlugin.log((IStatus)new Status(4, LiveLogUIPlugin.getUniqueIdentifier(), 4, message, exception));
    }
}

