/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.editors.result.log;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class LiveLogLineStyleListener
implements LineStyleListener {
    public static final Pattern pattern = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}\\ \\p{Upper}{3}");

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange style = null;
        Matcher m = pattern.matcher(event.lineText);
        if (m.find() && event.styles != null) {
            LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
            StyleRange[] styleRangeArray = event.styles;
            int n = event.styles.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange sr = styleRangeArray[n2];
                styleRanges.add(sr);
                if (event.lineOffset == sr.start) {
                    style = sr;
                }
                ++n2;
            }
            if (style != null) {
                style.start += m.end();
                style.length -= m.end();
                StyleRange style1 = (StyleRange)style.clone();
                int red = style1.foreground.getRed();
                int green = style1.foreground.getGreen();
                int blue = style1.foreground.getBlue();
                int grey = (red + green + blue) / 3;
                style1.foreground = new Color(null, grey, grey, grey);
                style1.start = event.lineOffset;
                style1.length = m.end();
                styleRanges.addFirst(style1);
                event.styles = styleRanges.toArray(new StyleRange[styleRanges.size()]);
            }
        }
    }
}

