/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.editors.result.log;

import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.AbandonBuildActionDelegate;
import com.ibm.team.build.logging.internal.ui.Messages;
import com.ibm.team.build.logging.internal.ui.editors.result.log.LiveLogConsole;
import com.ibm.team.build.logging.internal.ui.editors.result.log.LiveLogLineStyleListener;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class LiveLogConsolePageParticipant
implements IConsolePageParticipant {
    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
    }

    public void init(IPageBookViewPage page, final IConsole console) {
        IActionBars bars = page.getSite().getActionBars();
        Action abandon = new Action(Messages.LiveLogConsole_ACTION_ABANDON){

            public void run() {
                AbandonBuildActionDelegate delegate = new AbandonBuildActionDelegate();
                delegate.selectionChanged((IAction)this, (ISelection)new StructuredSelection((Object)((LiveLogConsole)console).getBuildResultRecord()));
                delegate.run((IAction)this);
            }
        };
        abandon.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        abandon.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_TERMINATE"));
        abandon.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        abandon.setToolTipText(Messages.LiveLogConsole_ACTION_ABANDON_TOOLTIP);
        ((LiveLogConsole)console).setAbandonAction(abandon);
        bars.getToolBarManager().appendToGroup("launchGroup", (IAction)abandon);
        Action remove = new Action(Messages.LiveLogConsole_ACTION_REMOVE){

            public void run() {
                IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                manager.removeConsoles(new IConsole[]{console});
            }
        };
        remove.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_REMOVE"));
        remove.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_REMOVE"));
        remove.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_REMOVE"));
        remove.setToolTipText(Messages.LiveLogConsole_ACTION_REMOVE_TOOLTIP);
        bars.getToolBarManager().appendToGroup("launchGroup", (IAction)remove);
        Action openBuildResult = new Action(Messages.LiveLogConsole_ACTION_OPEN_BUILD){

            public void run() {
                IBuildResult result = ((LiveLogConsole)console).getBuildResult();
                BuildUI.getDefault().open((IBuildResultHandle)result, (ITeamRepository)result.getOrigin(), null);
            }
        };
        openBuildResult.setImageDescriptor(BuildUIPlugin.getImageDescriptor((String)"icons/obj16/bld_rslt.gif"));
        openBuildResult.setToolTipText(Messages.LiveLogConsole_ACTION_OPEN_BUILD_TOOLTIP);
        ((LiveLogConsole)console).setOpenBuildResultAction(openBuildResult);
        bars.getToolBarManager().appendToGroup("launchGroup", (IAction)openBuildResult);
        boolean pprActionEnabled = false;
        if (pprActionEnabled) {
            final PreprocessingMenuAction ppr = new PreprocessingMenuAction();
            ((LiveLogConsole)console).setPreprocessAction(ppr);
            bars.getToolBarManager().appendToGroup("outputGroup", (IAction)ppr);
            if (bars.getToolBarManager() instanceof ToolBarManager) {
                ToolBarManager mgr = (ToolBarManager)bars.getToolBarManager();
                final ToolBar toolBar = mgr.getControl();
                toolBar.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        ActionContributionItem actionContributionItem;
                        IAction action;
                        ToolItem item = toolBar.getItem(new Point(e.x, e.y));
                        if (item != null && item.getData() instanceof ActionContributionItem && (action = (actionContributionItem = (ActionContributionItem)item.getData()).getAction()) == ppr) {
                            Event event = new Event();
                            event.widget = item;
                            event.x = e.x;
                            event.y = e.y;
                            action.runWithEvent(event);
                        }
                    }
                });
            }
        }
        Action timestamp = new Action(Messages.LiveLogConsole_ACTION_TIMESTAMP, 2){

            public void run() {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.build.console.timestamp", this.isChecked());
            }
        };
        timestamp.setImageDescriptor(BuildUIPlugin.getImageDescriptor((String)"icons/obj16/timestamp.gif"));
        timestamp.setToolTipText(Messages.LiveLogConsole_ACTION_TIMESTAMP_TOOLTIP);
        ((LiveLogConsole)console).setTimestampAction(timestamp);
        bars.getToolBarManager().appendToGroup("outputGroup", (IAction)timestamp);
        if (page.getControl() instanceof StyledText) {
            StyledText viewer = (StyledText)page.getControl();
            viewer.addLineStyleListener((LineStyleListener)new LiveLogLineStyleListener());
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public static class PreprocessingMenuAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private int fCurrentLevel = -1;

        public PreprocessingMenuAction() {
            this.setText(Messages.LiveLogConsole_ACTION_PPR_LEVEL);
            this.setToolTipText(Messages.LiveLogConsole_ACTION_PPR_LEVEL_TOOLTIP);
            this.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ACT_DEBUG"));
            this.setMenuCreator(this);
            this.fCurrentLevel = BuildUIPlugin.getDefault().getPreferenceStore().getInt("com.ibm.team.build.console.preprocessingLevel");
        }

        public int getCurrentLevel() {
            return this.fCurrentLevel;
        }

        public void runWithEvent(Event event) {
            if (event.widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar control = toolItem.getParent();
                Menu menu = this.getMenu((Control)control);
                Rectangle bounds = toolItem.getBounds();
                Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
                menu.setLocation(control.toDisplay(topLeft));
                menu.setVisible(true);
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            PreprocessingAction noneAction = new PreprocessingAction(Messages.LiveLogConsole_ACTION_PPR_LEVEL_NONE, -1);
            PreprocessingAction errorAction = new PreprocessingAction(Messages.LiveLogConsole_ACTION_PPR_LEVEL_ERROR, -1);
            PreprocessingAction warnAction = new PreprocessingAction(Messages.LiveLogConsole_ACTION_PPR_LEVEL_WARNING, -1);
            PreprocessingAction infoAction = new PreprocessingAction(Messages.LiveLogConsole_ACTION_PPR_LEVEL_INFO, -1);
            PreprocessingAction debugAction = new PreprocessingAction(Messages.LiveLogConsole_ACTION_PPR_LEVEL_DEBUG, -1);
            this.addAction(noneAction, this.fMenu);
            this.addAction(errorAction, this.fMenu);
            this.addAction(warnAction, this.fMenu);
            this.addAction(infoAction, this.fMenu);
            this.addAction(debugAction, this.fMenu);
            return this.fMenu;
        }

        private void addAction(Action action, Menu parent) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
        }

        private class PreprocessingAction
        extends Action {
            private int fPreferenceValue;

            public PreprocessingAction(String label, int preferenceValue) {
                super(label, 8);
                this.fPreferenceValue = preferenceValue;
                this.setChecked(preferenceValue == PreprocessingMenuAction.this.fCurrentLevel);
            }

            public void run() {
                PreprocessingMenuAction.this.fCurrentLevel = this.fPreferenceValue;
                BuildUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.build.console.preprocessingLevel", this.fPreferenceValue);
            }
        }
    }
}

