/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.editors.result.log;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogMessageFactory;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildResultRecordListener;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildStatusTextHelper;
import com.ibm.team.build.logging.client.ILiveLogListener;
import com.ibm.team.build.logging.client.ILiveLogMessageCallback;
import com.ibm.team.build.logging.client.LiveLogConfigurationException;
import com.ibm.team.build.logging.client.LiveLogConnectionException;
import com.ibm.team.build.logging.internal.ui.Messages;
import com.ibm.team.build.logging.internal.ui.editors.result.log.LiveLogConsolePageParticipant;
import com.ibm.team.build.logging.ui.LiveLogUIPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.IOConsolePartitioner;

public class LiveLogConsole
extends MessageConsole
implements ILiveLogMessageCallback,
ILiveLogMessageCallback.ILiveLogClientEventsListener,
IBuildResultRecordListener {
    private static final String EMPTY_STRING = "";
    private static final String MESSAGE_NEWLINE = "\n";
    private static final String NEWLINE = System.lineSeparator();
    private static final String BUILD_RESULT_ICON = "icons/obj16/build_result_obj.gif";
    protected static final ILiveLogMessage.Level STATUS = null;
    public static Log logger = LogFactory.getLog(LiveLogConsole.class);
    private static SimpleDateFormat normalTimestamp = new SimpleDateFormat("kk:mm:ss z");
    private static SimpleDateFormat verboseTimestamp = new SimpleDateFormat("kk:mm:ss z");
    private MessageConsoleStream verboseStream;
    private MessageConsoleStream infoStream;
    private MessageConsoleStream warningStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream statusStream;
    private MessageConsoleStream debugStream;
    private MessageConsoleStream[] streams;
    private IBuildDefinition buildDefinition;
    private Action abandon;
    private Action openBuildResult;
    private Action verbose;
    private Action timestamp;
    private Action debug;
    private LiveLogConsolePageParticipant.PreprocessingMenuAction ppr;
    private boolean firstMessage = true;
    private boolean finished = false;
    private boolean timestampPreference;
    private boolean verbosePreference;
    private ILiveLogListener fLogListener;
    private boolean disposed = false;
    private IBuildResultRecord buildResultRecord;

    public LiveLogConsole(IBuildResultRecord buildResultRecord, ILiveLogListener logListener) {
        super(Messages.LiveLogConsole_BUILD, LiveLogUIPlugin.getImageDescriptor(BUILD_RESULT_ICON));
        this.fLogListener = logListener;
        this.buildResultRecord = buildResultRecord;
        this.timestampPreference = LiveLogUIPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.build.console.timestamp");
        this.verbosePreference = LiveLogUIPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.build.console.verbose");
        this.streams = new MessageConsoleStream[]{this.verboseStream, this.infoStream, this.warningStream, this.errorStream, this.statusStream, this.debugStream};
        try {
            this.buildDefinition = (IBuildDefinition)((ITeamRepository)this.getBuildResult().getOrigin()).itemManager().fetchPartialItem((IItemHandle)this.getBuildResult().getBuildDefinition(), 0, Arrays.asList(IBuildDefinition.PROPERTY_ID), null);
        }
        catch (TeamRepositoryException e) {
            logger.error((Object)"Couldn't retrieve build definition", (Throwable)e);
        }
    }

    protected void init() {
        super.init();
        this.infoStream = this.newMessageStream();
        this.errorStream = this.newMessageStream();
        this.warningStream = this.newMessageStream();
        this.verboseStream = this.newMessageStream();
        this.statusStream = this.newMessageStream();
        this.debugStream = this.newMessageStream();
        this.verboseStream.setColor(AntUIPlugin.getPreferenceColor((String)"org.eclipse.ant.ui.verboseColor"));
        this.infoStream.setColor(AntUIPlugin.getPreferenceColor((String)"org.eclipse.ant.ui.informationColor"));
        this.errorStream.setColor(AntUIPlugin.getPreferenceColor((String)"org.eclipse.ant.ui.errorColor"));
        this.warningStream.setColor(AntUIPlugin.getPreferenceColor((String)"org.eclipse.ant.ui.warningColor"));
        Color debugColor = AntUIPlugin.getPreferenceColor((String)"org.eclipse.ant.ui.debugColor");
        this.debugStream.setColor(debugColor);
        Color statusColor = new Color(null, 110, 110, 110);
        this.statusStream.setColor(statusColor);
        this.connect();
    }

    protected void dispose() {
        super.dispose();
        this.disposed = true;
        this.closeConsole();
    }

    public void endLiveLogging() {
        this.disconnect();
    }

    public void closeConsole() {
        this.endLiveLogging();
        this.stopBuildMonitor();
        this.flushAndCloseStreams();
    }

    private void disconnect() {
        if (this.fLogListener != null) {
            try {
                try {
                    this.fLogListener.unsubscribeToBuild((IBuildResultHandle)this.getBuildResult());
                }
                catch (TeamRepositoryException e) {
                    logger.info((Object)"Exception while trying to disconnect", (Throwable)e);
                    this.fLogListener = null;
                }
            }
            finally {
                this.fLogListener = null;
            }
        }
    }

    public void connect() {
        Job job = new Job(Messages.LiveLogConsole_INIT){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    LiveLogConsole.this.fLogListener.subscribeToBuild((IBuildResultHandle)LiveLogConsole.this.getBuildResult(), (ILiveLogMessageCallback)LiveLogConsole.this);
                    return new Status(0, "com.ibm.team.build.ui", 0, LiveLogConsole.EMPTY_STRING, null);
                }
                catch (LiveLogConfigurationException confEx) {
                    BuildUIPlugin.log((String)Messages.LiveLogConsole_INVALID_CONFIG, (Throwable)confEx);
                    LiveLogConsole.this.showMessage(STATUS, "BUILD_END", Messages.LiveLogConsole_INVALID_CONFIG);
                    return new Status(4, "com.ibm.team.build.ui", 0, Messages.LiveLogConsole_INVALID_CONFIG, (Throwable)confEx);
                }
                catch (LiveLogConnectionException connEx) {
                    String msg = NLS.bind((String)Messages.LiveLogConsole_ERROR_CONNECTING, (Object)LiveLogConsole.this.getBuildResult().getLabel(), (Object[])new Object[0]);
                    BuildUIPlugin.log((String)msg, (Throwable)connEx);
                    return new Status(4, "com.ibm.team.build.ui", 0, msg, (Throwable)connEx);
                }
                catch (Exception e) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(0, "com.ibm.team.build.ui", 0, LiveLogConsole.EMPTY_STRING, null);
                }
            }
        };
        job.schedule();
    }

    public String getBuild() {
        return this.getBuildResult().getLabel();
    }

    public IBuildResult getBuildResult() {
        return this.buildResultRecord.getBuildResult();
    }

    public IBuildResultRecord getBuildResultRecord() {
        return this.buildResultRecord;
    }

    public void setAbandonAction(Action abandon) {
        this.abandon = abandon;
        this.enableAbandon(!this.finished && this.getBuildResult().getState() == BuildState.IN_PROGRESS);
    }

    public void setOpenBuildResultAction(Action openBuildResult) {
        this.openBuildResult = openBuildResult;
        openBuildResult.setEnabled(this.getBuildResult().getState() != BuildState.CANCELED && this.getBuildResult().getState() != BuildState.NOT_STARTED);
    }

    public void setVerboseAction(Action verbose) {
        this.verbose = verbose;
        verbose.setChecked(this.verbosePreference);
    }

    public void setTimestampAction(Action timestamp) {
        this.timestamp = timestamp;
        timestamp.setChecked(this.timestampPreference);
    }

    public void setDebug(Action debug) {
        this.debug = debug;
    }

    public void setPreprocessAction(LiveLogConsolePageParticipant.PreprocessingMenuAction ppr) {
        this.ppr = ppr;
    }

    public Action getVerboseAction() {
        return this.verbose;
    }

    private boolean isVerbose() {
        if (this.verbose == null) {
            return this.verbosePreference;
        }
        return this.verbose.isChecked();
    }

    private boolean isTimestamp() {
        if (this.timestamp == null) {
            return this.timestampPreference;
        }
        return this.timestamp.isChecked();
    }

    public String getName() {
        String buildId = this.buildDefinition != null ? this.buildDefinition.getId() : Messages.LiveLogConsole_BUILD;
        String buildLabel = EMPTY_STRING;
        String label = this.getBuildResult().getLabel();
        if (label != null && !label.isEmpty()) {
            buildLabel = label;
        }
        String result = NLS.bind((String)Messages.LiveLogConsole_BUILD_NAME, (Object)buildId, (Object[])new Object[]{buildLabel});
        return result;
    }

    public String format(long timestamp) {
        return normalTimestamp.format(new Date(timestamp));
    }

    public void enableAbandon(boolean abandon) {
        if (this.abandon != null) {
            this.abandon.setEnabled(abandon);
        }
    }

    public static void openOrActivate(IBuildResultRecord resultRecord, ITeamRepository repository) {
        try {
            LiveLogConsole console = LiveLogConsole.findOrCreateConsole(resultRecord, repository);
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception trying to open livelog console", (Throwable)ex);
        }
    }

    private static LiveLogConsole findOrCreateConsole(IBuildResultRecord resultRecord, ITeamRepository repository) throws URISyntaxException {
        LiveLogConsole result = null;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = manager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (existing[i] instanceof LiveLogConsole && resultRecord.getBuildResult().sameItemId((IItemHandle)((LiveLogConsole)existing[i]).getBuildResult())) {
                result = (LiveLogConsole)existing[i];
                break;
            }
            ++i;
        }
        if (result == null) {
            ILiveLogListener logListener = (ILiveLogListener)repository.getClientLibrary(ILiveLogListener.class);
            result = new LiveLogConsole(resultRecord, logListener);
            manager.addConsoles(new IConsole[]{result});
            boolean liveLoggingIsEnabledInBuild = Boolean.valueOf(resultRecord.getBuildDefinition().getConfigurationPropertyValue("com.ibm.team.build.logging.ILiveLogBuildConfigurationElement", "com.ibm.team.build.logging", "false"));
            if (!liveLoggingIsEnabledInBuild) {
                result.logMessage(NLS.bind((String)Messages.LiveLogConsole_BUILD_DEF_NOT_ENABLED, (Object)resultRecord.getBuildDefinition().getId(), (Object[])new Object[0]), ILiveLogMessage.Level.STATUS, System.currentTimeMillis());
            } else {
                BuildState buildState = resultRecord.getBuildResult().getState();
                if (LiveLogConsole.isBuildUnfinished(buildState)) {
                    result.startBuildMonitor(repository);
                    if (buildState == BuildState.NOT_STARTED) {
                        result.logMessage(Messages.LiveLogConsole_WAITING_ON_BUILD_QUEUE, ILiveLogMessage.Level.STATUS, System.currentTimeMillis());
                    }
                }
            }
        }
        return result;
    }

    private static boolean isBuildUnfinished(BuildState buildState) {
        return buildState == BuildState.NOT_STARTED || buildState == BuildState.IN_PROGRESS;
    }

    private void startBuildMonitor(ITeamRepository repository) {
        BuildRecordEventManager.getInstance().addListener((IBuildResultRecordListener)this);
    }

    private void stopBuildMonitor() {
        BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
    }

    private void logMessage(String message, ILiveLogMessage.Level state, long ts) {
        if (message == null || this.disposed) {
            return;
        }
        this.printMessageToConsole(message, state, ts);
    }

    private void printMessageToConsole(String message, ILiveLogMessage.Level state, long ts) {
        block21: {
            if (this.getDocument() != null && ((IOConsolePartitioner)this.getPartitioner()).getDocument() != null) {
                StringBuffer msgBuffer = new StringBuffer();
                String[] stringArray = message.split(MESSAGE_NEWLINE);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (this.isTimestamp()) {
                        msgBuffer.append(this.isVerbose() ? verboseTimestamp.format(ts) : normalTimestamp.format(ts));
                        msgBuffer.append(' ');
                    }
                    msgBuffer.append(String.valueOf(line) + NEWLINE);
                    ++n2;
                }
                String messageString = msgBuffer.toString();
                if (state == null) {
                    if (!this.statusStream.isClosed()) {
                        this.statusStream.print(messageString);
                    }
                } else {
                    try {
                        switch (state) {
                            case INFO: {
                                if (!this.infoStream.isClosed()) {
                                    this.infoStream.print(messageString);
                                }
                                break;
                            }
                            case WARNING: {
                                if (!this.warningStream.isClosed()) {
                                    this.warningStream.print(messageString);
                                }
                                break;
                            }
                            case ERROR: {
                                if (!this.errorStream.isClosed()) {
                                    this.errorStream.print(messageString);
                                }
                                break;
                            }
                            case DEBUG: {
                                if (!this.debugStream.isClosed()) {
                                    this.debugStream.print(messageString);
                                }
                                break;
                            }
                            case VERBOSE: {
                                if (this.isVerbose() && !this.verboseStream.isClosed()) {
                                    this.verboseStream.print(messageString);
                                }
                                break;
                            }
                            default: {
                                if (!this.statusStream.isClosed()) {
                                    this.statusStream.print(messageString);
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (this.statusStream.isClosed()) break block21;
                        this.statusStream.print(NLS.bind((String)Messages.LiveLogConsole_ERROR_REFRESHING_BUILD_RESULT, (Object)e, (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void receiveMessage(ILiveLogMessage message) {
        if (this.firstMessage) {
            this.firstMessage = false;
            this.refreshBuildResult();
        }
        try {
            if (message != null) {
                String msgText = message.getMessage();
                long msgTimestamp = message.getTimestamp();
                ILiveLogMessage.Level msgState = message.getLevel();
                if ("BUILD_START".equals(message.getMessageId())) {
                    this.finished = false;
                }
                if ("BUILD_END".equals(message.getMessageId())) {
                    this.logMessage(Messages.LiveLogConsole_BUILD_ENDED, ILiveLogMessage.Level.STATUS, msgTimestamp);
                    this.enableAbandon(false);
                    this.endLiveLogging();
                } else {
                    this.logMessage(msgText, msgState, msgTimestamp);
                }
            }
        }
        catch (Exception e) {
            LiveLogUIPlugin.log("An error occurred while processing a log message", e);
        }
    }

    private boolean isDevDebug() {
        return false;
    }

    public void refreshBuildResult() {
        if (!this.finished) {
            ITeamRepository repo = (ITeamRepository)this.getBuildResult().getOrigin();
            ITeamBuildRecordClient recordClient = (ITeamBuildRecordClient)repo.getClientLibrary(ITeamBuildRecordClient.class);
            ITeamBuildClient buildClient = (ITeamBuildClient)repo.getClientLibrary(ITeamBuildClient.class);
            String[] properties = new String[]{IBuildResult.PROPERTY_BUILD_STATE, IBuildResult.PROPERTY_BUILD_STATUS, IItem.MODIFIED_PROPERTY};
            try {
                long currentTime = System.currentTimeMillis();
                recordClient.getBuildResultRecord((IBuildResultHandle)this.getBuildResult(), properties, null);
                if (this.isDevDebug()) {
                    this.showMessage(STATUS, null, "refreshBuildResult() took " + (System.currentTimeMillis() - currentTime) + "ms");
                }
            }
            catch (ItemNotFoundException inf) {
                this.finished = true;
                this.buildResultRecord = null;
                this.showMessage(STATUS, "BUILD_END", Messages.LiveLogConsole_BUILD_DELETED);
            }
            catch (TeamRepositoryException e) {
                this.showMessage(STATUS, NLS.bind((String)Messages.LiveLogConsole_ERROR_REFRESHING_BUILD_RESULT, (Object)e.getMessage(), (Object[])new Object[0]));
            }
        }
    }

    private void showMessage(ILiveLogMessage.Level msgLevel, String msg) {
        this.showMessage(msgLevel, null, msg);
    }

    private void showMessage(ILiveLogMessage.Level msgLevel, long timestamp, String msg) {
        ILiveLogMessage llmsg = this.createMessage(msgLevel, null, msg);
        llmsg.setTimestamp(timestamp);
        this.receiveMessage(llmsg);
    }

    private void showMessage(ILiveLogMessage.Level msgLevel, String msgId, String msg) {
        ILiveLogMessage llmsg = this.createMessage(msgLevel, msgId, msg);
        this.receiveMessage(llmsg);
    }

    private ILiveLogMessage createMessage(ILiveLogMessage.Level msgLevel, String msgId, String msg) {
        ILiveLogMessage llmsg = LiveLogMessageFactory.getInstance().createLiveLogMessage((IBuildResultHandle)this.getBuildResult());
        llmsg.setMessageId(msgId);
        llmsg.setMessage(msg);
        llmsg.setLevel(msgLevel);
        return llmsg;
    }

    private void flushAndCloseStreams() {
        try {
            if (this.streams != null) {
                MessageConsoleStream[] messageConsoleStreamArray = this.streams;
                int n = this.streams.length;
                int n2 = 0;
                while (n2 < n) {
                    MessageConsoleStream stream = messageConsoleStreamArray[n2];
                    if (stream != null && !stream.isClosed()) {
                        stream.flush();
                        stream.close();
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            LiveLogUIPlugin.log("Error trying to close live logging console output streams", e);
        }
    }

    public void recordsReceived(IBuildResultRecord[] records) {
        if (records != null) {
            UUID buildResultId = this.buildResultRecord.getBuildResult().getItemId();
            IBuildResultRecord[] iBuildResultRecordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultRecord record = iBuildResultRecordArray[n2];
                if (record.getBuildResult().getItemId().equals((Object)buildResultId)) {
                    this.updateBuildResult(record);
                    break;
                }
                ++n2;
            }
        }
    }

    private void updateBuildResult(IBuildResultRecord record) {
        this.buildResultRecord = record;
        IBuildResult buildResult = this.buildResultRecord.getBuildResult();
        boolean wasFinished = this.finished;
        boolean bl = this.finished = this.finished || buildResult == null || buildResult.getState() == BuildState.CANCELED || buildResult.getState() == BuildState.COMPLETED || buildResult.getState() == BuildState.INCOMPLETE;
        if (!wasFinished && this.finished) {
            this.endLiveLogging();
            this.stopBuildMonitor();
            long timestamp = buildResult.getBuildStartTime() + buildResult.getBuildTimeTaken();
            switch (buildResult.getState()) {
                case CANCELED: {
                    this.logMessage(Messages.LiveLogConsole_BUILD_CANCELED, STATUS, timestamp);
                    break;
                }
                case COMPLETED: {
                    String buildStatus = BuildStatusTextHelper.getText((BuildStatus)buildResult.getStatus());
                    String buildMessage = NLS.bind((String)Messages.LiveLogConsole_BUILD_COMPLETED, (Object)buildStatus, (Object[])new Object[0]);
                    this.logMessage(buildMessage, STATUS, timestamp);
                    break;
                }
                case INCOMPLETE: {
                    this.logMessage(Messages.LiveLogConsole_BUILD_INCOMPLETE, STATUS, timestamp);
                    break;
                }
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!LiveLogConsole.this.disposed) {
                    LiveLogConsole.this.setName(LiveLogConsole.this.getName());
                    LiveLogConsole.this.enableAbandon(!LiveLogConsole.this.finished && LiveLogConsole.this.getBuildResult().getState() == BuildState.IN_PROGRESS);
                    if (LiveLogConsole.this.openBuildResult != null) {
                        LiveLogConsole.this.openBuildResult.setEnabled(LiveLogConsole.this.getBuildResult().getState() != BuildState.CANCELED && LiveLogConsole.this.getBuildResult().getState() != BuildState.NOT_STARTED);
                    }
                }
            }
        });
    }

    public void connectionLost(TeamRepositoryException e) {
        this.showMessage(ILiveLogMessage.Level.ERROR, Messages.LiveLogConsole_CONNECTION_LOST, e.getMessage());
    }

    private static class BuildMonitorTerminator {
        private ScheduledFuture<?> future;

        private BuildMonitorTerminator() {
        }

        public synchronized void setFuture(ScheduledFuture<?> f) {
            this.future = f;
        }

        public synchronized void stop() {
            if (!this.future.isDone()) {
                this.future.cancel(false);
            }
        }
    }
}

