/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.editors;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.editors.builddefinition.BasicConfigurationElementEditor;
import com.ibm.team.build.logging.internal.ui.Messages;
import com.ibm.team.build.logging.ui.LiveLogUIPlugin;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.IMQTTInfoClientLibrary;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.StringUtils;
import com.ibm.team.repository.common.model.MQTTBrokerConfigDTO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LiveLoggingConfigurationEditor
extends BasicConfigurationElementEditor {
    private IBuildDefinition fWorkingCopy;
    private Section fLiveLoggingSection;
    private Button fEnablementButton;
    private Combo fLoggingLevelCombo;
    private LiveLoggingEnableValidator fConfigValidator;
    private FormToolkit fToolkit;

    public LiveLoggingConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fLiveLoggingSection = this.createSection(parent, Messages.BuildDefinitionEditor_LIVE_LOGGING_TITLE, Messages.BuildDefinitionEditor_LIVE_LOGGING_DESCRIPTION, false, 1);
        this.fLiveLoggingSection.setLayoutData((Object)new TableWrapData(256, 256, 1, 1));
        Composite composite = this.fToolkit.createComposite((Composite)this.fLiveLoggingSection);
        TableWrapData layoutData = new TableWrapData(256, 256);
        composite.setLayoutData((Object)layoutData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fEnablementButton = this.fToolkit.createButton(composite, Messages.BuildDefinitionEditor_LIVE_LOGGING_CHECKBOX_LABEL, 32);
        this.fEnablementButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
        boolean enableLifeLogging = Boolean.valueOf(this.fWorkingCopy.getConfigurationPropertyValue("com.ibm.team.build.logging.ILiveLogBuildConfigurationElement", "com.ibm.team.build.logging", "false"));
        this.fEnablementButton.setSelection(enableLifeLogging);
        this.fEnablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveLoggingConfigurationEditor.this.validate();
                boolean selected = LiveLoggingConfigurationEditor.this.fEnablementButton.getSelection();
                LiveLoggingConfigurationEditor.this.fWorkingCopy.setConfigurationProperty("com.ibm.team.build.logging.ILiveLogBuildConfigurationElement", "com.ibm.team.build.logging", Boolean.toString(selected));
                LiveLoggingConfigurationEditor.this.fLoggingLevelCombo.setEnabled(selected);
                LiveLoggingConfigurationEditor.this.setDirty(true);
            }
        });
        Label logLevelLabel = this.fToolkit.createLabel(composite, Messages.BuildDefinitionEditor_LIVE_LOGGING_COMBOLEVEL_LABEL);
        layoutData = new TableWrapData(256, 256);
        layoutData.indent = 18;
        logLevelLabel.setLayoutData((Object)layoutData);
        this.fLoggingLevelCombo = new Combo(composite, 8);
        layoutData = new TableWrapData();
        layoutData.indent = 18;
        this.fLoggingLevelCombo.setLayoutData((Object)layoutData);
        String selectedLevel = this.fWorkingCopy.getPropertyValue("com.ibm.team.build.logging.level", ILiveLogMessage.Level.VERBOSE.name());
        ILiveLogMessage.Level[] levels = ILiveLogMessage.Level.values();
        int i = 0;
        while (i < levels.length) {
            if (levels[i].isUserSelectable()) {
                this.fLoggingLevelCombo.add(levels[i].getNameLiteral(), i);
                if (levels[i].name().equalsIgnoreCase(selectedLevel)) {
                    this.fLoggingLevelCombo.select(i);
                }
            }
            ++i;
        }
        this.fLoggingLevelCombo.setEnabled(enableLifeLogging);
        this.fLoggingLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveLoggingConfigurationEditor.this.validate();
                String selected = LiveLoggingConfigurationEditor.this.fLoggingLevelCombo.getItem(LiveLoggingConfigurationEditor.this.fLoggingLevelCombo.getSelectionIndex());
                String selectedLevel = ILiveLogMessage.Level.fromString((String)selected).name();
                LiveLoggingConfigurationEditor.this.fWorkingCopy.setProperty("com.ibm.team.build.logging.level", selectedLevel);
                LiveLoggingConfigurationEditor.this.setDirty(true);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.fLiveLoggingSection.setClient((Control)composite);
        this.validate();
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fWorkingCopy = definition;
    }

    public boolean validate() {
        if (this.fConfigValidator == null && this.getTeamRepository() != null) {
            this.fConfigValidator = new LiveLoggingEnableValidator(Messages.BuildDefinitionEditor_LIVE_LOGGING_CONFIGURATION_VALIDATOR_JOB, this.getTeamRepository());
        }
        if (this.fConfigValidator != null) {
            this.fConfigValidator.validate();
        }
        return true;
    }

    public void dispose() {
        this.fConfigValidator.cancel();
        super.dispose();
    }

    private class LiveLoggingEnableValidator
    extends UIUpdaterJob
    implements ITeamRepository.ILoginParticipant {
        private ITeamRepository fTeamRepo;
        private Boolean fIsBrokerConfigured;
        private IMQTTInfoClientLibrary fMqttInfoClient;

        public LiveLoggingEnableValidator(String name, ITeamRepository teamRepo) {
            super(name);
            this.fTeamRepo = teamRepo;
            this.fIsBrokerConfigured = null;
            this.fTeamRepo.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
        }

        public void handleLogin(ITeamRepository repository) {
        }

        public void handleLogout(ITeamRepository repository) {
            this.fMqttInfoClient = null;
            this.fIsBrokerConfigured = null;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            if (this.fIsBrokerConfigured == null) {
                if (this.fMqttInfoClient == null) {
                    this.fMqttInfoClient = (IMQTTInfoClientLibrary)LiveLoggingConfigurationEditor.this.getTeamRepository().getClientLibrary(IMQTTInfoClientLibrary.class);
                }
                try {
                    MQTTBrokerConfigDTO mqttBrokerInfo = this.fMqttInfoClient.getMQTTBrokerInfo();
                    this.fIsBrokerConfigured = !StringUtils.isEmpty((String)mqttBrokerInfo.getBrokerURL()) || !StringUtils.isEmpty((String)mqttBrokerInfo.getBrokerURLSecure());
                }
                catch (TeamRepositoryException e) {
                    LiveLogUIPlugin.log(e);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (LiveLoggingConfigurationEditor.this.fEnablementButton != null && !LiveLoggingConfigurationEditor.this.fEnablementButton.isDisposed()) {
                if (LiveLoggingConfigurationEditor.this.fEnablementButton.getSelection() && !this.fIsBrokerConfigured.booleanValue()) {
                    LiveLoggingConfigurationEditor.this.setPageStatusIndicator(false, true);
                    LiveLoggingConfigurationEditor.this.addWarningMessage(LiveLoggingConfigurationEditor.this.fEnablementButton, Messages.BuildDefinitionEditor_LIVE_LOGGING_NOBROKER_WARNING_MSG, (Control)LiveLoggingConfigurationEditor.this.fEnablementButton);
                } else {
                    LiveLoggingConfigurationEditor.this.setPageStatusIndicator(false, false);
                    LiveLoggingConfigurationEditor.this.removeMessage(LiveLoggingConfigurationEditor.this.fEnablementButton, (Control)LiveLoggingConfigurationEditor.this.fEnablementButton);
                }
            }
            return super.runInUI(monitor);
        }

        public void validate() {
            if (LiveLoggingConfigurationEditor.this.fEnablementButton != null && !LiveLoggingConfigurationEditor.this.fEnablementButton.isDisposed()) {
                if (this.fIsBrokerConfigured == null) {
                    this.schedule();
                } else if (!LiveLoggingConfigurationEditor.this.fEnablementButton.getSelection() || this.fIsBrokerConfigured.booleanValue()) {
                    LiveLoggingConfigurationEditor.this.setPageStatusIndicator(false, false);
                    LiveLoggingConfigurationEditor.this.removeMessage(LiveLoggingConfigurationEditor.this.fEnablementButton, (Control)LiveLoggingConfigurationEditor.this.fEnablementButton);
                } else {
                    LiveLoggingConfigurationEditor.this.setPageStatusIndicator(false, true);
                    LiveLoggingConfigurationEditor.this.addWarningMessage(LiveLoggingConfigurationEditor.this.fEnablementButton, Messages.BuildDefinitionEditor_LIVE_LOGGING_NOBROKER_WARNING_MSG, (Control)LiveLoggingConfigurationEditor.this.fEnablementButton);
                }
            }
        }
    }
}

