/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.dialogs;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.logging.ui.LiveLogUIPlugin;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.Section;

public class LiveLogRequestBuildSection
extends RequestBuildSection {
    public static final String PREFERENCE_SHOW_BUILDS_VIEW = "showBuildsViewAfterRequest";
    public static final String PREFERENCE_SHOW_BUILD_CONSOLE = "showBuildConsoleAfterRequest";
    private IWorkbenchPartSite fPartSite;
    private Composite fLiveLogComposite;
    private Button fShowBuildConsoleCheckbox;
    protected boolean fShowBuildConsole = false;

    protected LiveLogRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return "Build Live Log";
    }

    protected void createSectionContent(Section section) {
        if (this.fLiveLogComposite != null && !this.fLiveLogComposite.isDisposed()) {
            this.fLiveLogComposite.dispose();
        }
        this.fLiveLogComposite = new Composite((Composite)section, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 0).applyTo(this.fLiveLogComposite);
        section.setClient((Control)this.fLiveLogComposite);
        this.fShowBuildConsoleCheckbox = new Button(this.fLiveLogComposite, 32);
        this.fShowBuildConsoleCheckbox.setText("Monitor build output in the Build Console");
        this.fShowBuildConsole = LiveLogUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_BUILD_CONSOLE);
        this.fShowBuildConsoleCheckbox.setSelection(this.fShowBuildConsole);
        this.fShowBuildConsoleCheckbox.addSelectionListener(this.getShowBuildConsoleListener());
        GridDataFactory.fillDefaults().span(3, -1).indent(40, 0).grab(false, false).applyTo((Control)this.fShowBuildConsoleCheckbox);
    }

    protected boolean grabVertical() {
        return true;
    }

    public void setWorkbenchPartSite(IWorkbenchPartSite partSite) {
        this.fPartSite = partSite;
    }

    private SelectionListener getShowBuildConsoleListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveLogRequestBuildSection.this.fShowBuildConsole = LiveLogRequestBuildSection.this.fShowBuildConsoleCheckbox.getSelection();
                LiveLogUIPlugin.getDefault().getPreferenceStore().setValue(LiveLogRequestBuildSection.PREFERENCE_SHOW_BUILD_CONSOLE, LiveLogRequestBuildSection.this.fShowBuildConsole);
                LiveLogUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    private IBuildProperty getLiveLogBuildProperty() {
        List buildProps = this.getSite().getBuildDefinition().getProperties();
        IBuildProperty buildProp = null;
        for (IBuildProperty prop : buildProps) {
            if (!prop.getName().equals("BuildLiveLog")) continue;
            buildProp = prop;
            break;
        }
        if (buildProp == null) {
            buildProp = BuildItemFactory.createBuildProperty();
            buildProp.setName("BuildLiveLog");
            this.getSite().getBuildDefinition().getProperties().add(buildProp);
        }
        return buildProp;
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        IBuildProperty llBuildProp = this.getLiveLogBuildProperty();
        llBuildProp.setValue(Boolean.toString(this.fShowBuildConsole));
    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new LiveLogRequestBuildSection(site);
        }
    }
}

