/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.logging.internal.ui.actions;

import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.logging.internal.ui.Messages;
import com.ibm.team.build.logging.internal.ui.editors.result.log.LiveLogConsole;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class LiveLogViewAction
extends ActionDelegate {
    private IBuildResultRecord fBuildResultRecord;
    private Shell fShell;

    public void run(IAction action) {
        String jobName = NLS.bind((String)Messages.LiveLogConsole_VIEW_ACTION_OPENING, (Object)this.fBuildResultRecord.getBuildResult().getLabel());
        UIUpdaterJob job = new UIUpdaterJob(jobName){
            ITeamRepository repository;
            {
                this.repository = null;
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                if (LiveLogViewAction.this.fBuildResultRecord != null && LiveLogViewAction.this.fShell != null && !LiveLogViewAction.this.fShell.isDisposed()) {
                    this.repository = (ITeamRepository)LiveLogViewAction.this.fBuildResultRecord.getBuildResult().getOrigin();
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.repository != null) {
                    LiveLogConsole.openOrActivate(LiveLogViewAction.this.fBuildResultRecord, this.repository);
                }
                return super.runInUI(monitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fBuildResultRecord = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.fShell = window.getShell();
        }
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IBuildResultRecord) {
                IBuildResultRecord record;
                this.fBuildResultRecord = record = (IBuildResultRecord)object;
            } else if (object instanceof BuildQueryRow) {
                BuildQueryRow row = (BuildQueryRow)object;
                this.fBuildResultRecord = row.getBuildResultRecord();
            }
        }
    }
}

