/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.logging.client;

import com.ibm.team.build.internal.logging.client.Messages;
import com.ibm.team.build.logging.client.LiveLogClientException;
import com.ibm.team.build.logging.client.LiveLogConfigurationException;
import com.ibm.team.build.logging.client.LiveLogConnectionException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.StringUtils;
import com.ibm.team.repository.common.model.MQTTBrokerConfigDTO;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttClientBuilder {
    public IMqttAsyncClient createPahoClient(MQTTBrokerConfigDTO mqttBrokerInfo, String clientId) throws LiveLogConfigurationException {
        if (StringUtils.isEmpty((String)clientId)) {
            throw new LiveLogConfigurationException(new IllegalArgumentException(Messages.MqttClientBuilder_INVALID_CLIENT_ID));
        }
        if (mqttBrokerInfo == null || StringUtils.isEmpty((String)mqttBrokerInfo.getBrokerURL()) && StringUtils.isEmpty((String)mqttBrokerInfo.getBrokerURLSecure())) {
            throw new LiveLogConfigurationException(new TeamRepositoryException(Messages.MqttClientBuilder_MISSING_BROKER_URL));
        }
        try {
            String brokerUrl = StringUtils.isEmpty((String)mqttBrokerInfo.getBrokerURL()) ? mqttBrokerInfo.getBrokerURLSecure() : mqttBrokerInfo.getBrokerURL();
            MqttAsyncClient client = new MqttAsyncClient(brokerUrl, clientId, (MqttClientPersistence)new MemoryPersistence());
            return client;
        }
        catch (MqttException e) {
            throw new LiveLogConfigurationException(e);
        }
    }

    public void connectPahoClient(MqttAsyncClient client, MqttConnectOptions connectionOptions, DisconnectedBufferOptions bufferOptions) throws LiveLogClientException {
        if (client == null) {
            throw new LiveLogClientException(Messages.MqttClientBuilder_NULL_PAHO_CLIENT);
        }
        if (connectionOptions == null) {
            connectionOptions = new MqttConnectOptions();
            connectionOptions.setCleanSession(false);
            connectionOptions.setAutomaticReconnect(true);
        }
        if (bufferOptions == null) {
            bufferOptions = new DisconnectedBufferOptions();
            bufferOptions.setBufferEnabled(true);
            bufferOptions.setDeleteOldestMessages(true);
            client.setBufferOpts(bufferOptions);
        }
        try {
            client.connect(connectionOptions).waitForCompletion();
        }
        catch (MqttException e) {
            throw new LiveLogConnectionException(e);
        }
    }
}

