/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.logging.client;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogMessageFactory;
import com.ibm.team.build.internal.logging.client.Messages;
import com.ibm.team.build.internal.logging.client.MqttBuildClient;
import com.ibm.team.build.internal.logging.client.MqttClientBuilder;
import com.ibm.team.build.logging.client.Activator;
import com.ibm.team.build.logging.client.ILiveLogger;
import com.ibm.team.build.logging.client.LiveLogClientException;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.StringUtils;

public class MqttBuildLiveLogger
extends MqttBuildClient
implements ILiveLogger {
    public MqttBuildLiveLogger(IClientLibraryContext context) {
        this(context, new MqttClientBuilder());
    }

    public MqttBuildLiveLogger(IClientLibraryContext context, MqttClientBuilder pahoBuilder) {
        super(context, pahoBuilder);
    }

    @Override
    public void publishBuildProgress(ILiveLogMessage progressMessage) throws TeamRepositoryException {
        if (progressMessage == null || StringUtils.isEmpty((String)progressMessage.getMessage()) && StringUtils.isEmpty((String)progressMessage.getMessageId())) {
            Activator.getLog().warn((Object)Messages.MqttBuildLiveLogger_NULL_MESSAGE_PUBLISH);
            return;
        }
        if (progressMessage.getBuildResult() == null) {
            String errorMsg = Messages.MqttBuildLiveLogger_BUILD_ORPHANED_MSG_PUBLISH;
            throw new LiveLogClientException(errorMsg);
        }
        String topic = LiveLogMessageFactory.getInstance().generateTopicFromBuild(progressMessage.getBuildResult());
        this.publishMessage(topic, progressMessage);
    }
}

