/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.logging.client;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogMessageFactory;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.logging.client.Messages;
import com.ibm.team.build.internal.logging.client.MqttBuildClient;
import com.ibm.team.build.internal.logging.client.MqttClientBuilder;
import com.ibm.team.build.logging.client.Activator;
import com.ibm.team.build.logging.client.ILiveLogListener;
import com.ibm.team.build.logging.client.ILiveLogMessageCallback;
import com.ibm.team.build.logging.client.LiveLogConnectionException;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttBuildLiveLogListener
extends MqttBuildClient
implements ILiveLogListener,
IMqttMessageListener,
MqttCallback {
    private AtomicBoolean fRegisteredWithMqtt = new AtomicBoolean();
    private Lock fSubscribersLock;
    private Map<UUID, WeakReference<ILiveLogMessageCallback>> fBuildListeners = new ConcurrentHashMap<UUID, WeakReference<ILiveLogMessageCallback>>();

    public MqttBuildLiveLogListener(IClientLibraryContext context) {
        this(context, new MqttClientBuilder());
    }

    public MqttBuildLiveLogListener(IClientLibraryContext context, MqttClientBuilder pahoBuilder) {
        super(context, pahoBuilder);
        this.fSubscribersLock = new ReentrantLock();
    }

    @Override
    public void unsubscribeToBuild(IBuildResultHandle buildResult) throws TeamRepositoryException {
        if (buildResult == null) {
            Activator.getLog().warn((Object)Messages.MqttBuildLiveLogListener_NULL_BUILD_UNSUBSCRIBE);
            return;
        }
        String topic = LiveLogMessageFactory.getInstance().generateTopicFromBuild(buildResult);
        this.fSubscribersLock.lock();
        try {
            if (this.fBuildListeners != null) {
                this.fBuildListeners.remove(buildResult.getItemId());
            }
            boolean disconnect = this.fBuildListeners == null || this.fBuildListeners.isEmpty();
            this.unsubscribeTopic(topic, disconnect);
        }
        finally {
            this.fSubscribersLock.unlock();
        }
    }

    @Override
    public void subscribeToBuild(IBuildResultHandle buildResult, ILiveLogMessageCallback callback) throws TeamRepositoryException {
        if (buildResult == null || callback == null) {
            Activator.getLog().warn((Object)Messages.MqttBuildLiveLogListener_INVALID_PARAMS_SUBSCRIBE);
            return;
        }
        String topic = LiveLogMessageFactory.getInstance().generateTopicFromBuild(buildResult);
        this.fSubscribersLock.lock();
        try {
            this.subscribeTopic(topic, this);
            this.fBuildListeners.put(buildResult.getItemId(), new WeakReference<ILiveLogMessageCallback>(callback));
        }
        finally {
            this.fSubscribersLock.unlock();
        }
        if (this.fRegisteredWithMqtt.compareAndSet(false, true)) {
            this.registerMqttEvents(this);
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        ILiveLogMessageCallback liveLogCallback;
        WeakReference<ILiveLogMessageCallback> liveLogCallbackref;
        LiveLogMessageFactory factory = LiveLogMessageFactory.getInstance();
        UUID buildUuid = factory.extractBuildUuidFromTopic(topic);
        ILiveLogMessage llmessage = factory.getTransportInterface().demarshal(message.getPayload());
        if (this.fBuildListeners != null && llmessage != null && (liveLogCallbackref = this.fBuildListeners.get(buildUuid)) != null && (liveLogCallback = (ILiveLogMessageCallback)liveLogCallbackref.get()) != null) {
            liveLogCallback.receiveMessage(llmessage);
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnectedToBroker();
    }

    public void connectionLost(Throwable t) {
        if (this.fBuildListeners != null) {
            Set callbackers = Collections.newSetFromMap(new IdentityHashMap());
            for (WeakReference<ILiveLogMessageCallback> liveLogCallbackref : this.fBuildListeners.values()) {
                ILiveLogMessageCallback callback = (ILiveLogMessageCallback)liveLogCallbackref.get();
                if (callback == null || callbackers.contains(callback)) continue;
                callbackers.add(callback);
                if (!ILiveLogMessageCallback.ILiveLogClientEventsListener.class.isInstance(callback)) continue;
                ((ILiveLogMessageCallback.ILiveLogClientEventsListener)((Object)callback)).connectionLost(new LiveLogConnectionException(t));
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

