/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.logging.client;

import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.build.common.logging.LiveLogMessageFactory;
import com.ibm.team.build.common.logging.LiveLogTransportInterface;
import com.ibm.team.build.internal.logging.client.IMqttBuildClient;
import com.ibm.team.build.internal.logging.client.Messages;
import com.ibm.team.build.internal.logging.client.MqttClientBuilder;
import com.ibm.team.build.logging.client.Activator;
import com.ibm.team.build.logging.client.LiveLogConfigurationException;
import com.ibm.team.build.logging.client.LiveLogConnectionException;
import com.ibm.team.repository.client.IMQTTInfoClientLibrary;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.StringUtils;
import com.ibm.team.repository.common.model.MQTTBrokerConfigDTO;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.osgi.util.NLS;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public abstract class MqttBuildClient
implements IMqttBuildClient {
    private IMqttAsyncClient fMqttClient;
    private final Lock fMqttConnOpsLock = new ReentrantLock();
    private final IClientLibraryContext fContext;
    private IMQTTInfoClientLibrary fMqttClientLib;
    private MqttClientBuilder fPahoBuilder;
    private LiveLogMessageFactory fMessageFactory;
    private LiveLogTransportInterface fTransportInterface;

    public MqttBuildClient(IClientLibraryContext context, MqttClientBuilder pahoBuilder) {
        this(context, pahoBuilder, null, null);
    }

    public MqttBuildClient(IClientLibraryContext context, MqttClientBuilder pahoBuilder, LiveLogMessageFactory msgFactory) {
        this(context, pahoBuilder, msgFactory, null);
    }

    public MqttBuildClient(IClientLibraryContext context, MqttClientBuilder pahoBuilder, LiveLogMessageFactory msgFactory, LiveLogTransportInterface transportInterface) {
        Objects.requireNonNull(context, Messages.MqttBuildClient_NULL_CLIENTLIBCTX_ERROR);
        Objects.requireNonNull(pahoBuilder, Messages.MqttBuildClient_NULL_PAHO_ERROR);
        this.fContext = context;
        this.fPahoBuilder = pahoBuilder;
        this.fMessageFactory = msgFactory;
        this.fTransportInterface = transportInterface;
    }

    @Override
    public void publishMessage(String topic, ILiveLogMessage message) throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        if (StringUtils.isEmpty((String)topic)) {
            Activator.getLog().warn((Object)Messages.MqttBuildClient_EMPTY_TOPIC_PUBLISH);
            return;
        }
        if (message == null) {
            Activator.getLog().warn((Object)Messages.MqttBuildClient_NULL_MESSAGE_PUBLISH);
            return;
        }
        LiveLogTransportInterface transport = this.getMessagingTransportInterface();
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setPayload(transport.marshal(message));
        mqttMessage.setQos(0);
        this.fMqttConnOpsLock.lock();
        try {
            try {
                IMqttAsyncClient mqttClient = this.getMqttClient(true);
                mqttClient.publish(topic, mqttMessage);
            }
            catch (MqttException e) {
                String exMessage = NLS.bind((String)Messages.MqttBuildClient_PUBLISH_MSG_EXCEPTION, (Object)topic);
                Activator.getLog().error((Object)exMessage, (Throwable)e);
                throw new TeamRepositoryException(exMessage, (Throwable)e);
            }
        }
        finally {
            this.fMqttConnOpsLock.unlock();
        }
    }

    @Override
    public void subscribeTopic(String topic, IMqttMessageListener messageListener) throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        if (StringUtils.isEmpty((String)topic)) {
            Activator.getLog().warn((Object)Messages.MqttBuildClient_EMPTY_TOPIC_SUBSCRIBE);
            return;
        }
        if (messageListener == null) {
            Activator.getLog().warn((Object)Messages.MqttBuildClient_NO_LISTENER_SUBSCRIBE);
            return;
        }
        this.fMqttConnOpsLock.lock();
        try {
            try {
                IMqttAsyncClient mqttClient = this.getMqttClient(true);
                mqttClient.subscribe(topic, 0, messageListener);
            }
            catch (MqttException e) {
                String exMessage = NLS.bind((String)Messages.MqttBuildClient_SUBSCRIBE_EXCEPTION, (Object)topic);
                Activator.getLog().error((Object)exMessage, (Throwable)e);
                throw new TeamRepositoryException(exMessage, (Throwable)e);
            }
        }
        finally {
            this.fMqttConnOpsLock.unlock();
        }
    }

    @Override
    public void unsubscribeTopic(String topic) throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        this.unsubscribeTopic(topic, false);
    }

    @Override
    public void unsubscribeTopic(String topic, boolean disconnectOnUnsubscribe) throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        if (StringUtils.isEmpty((String)topic)) {
            Activator.getLog().warn((Object)Messages.MqttBuildClient_EMPTY_TOPIC_UNSUBSCRIBE);
            return;
        }
        this.fMqttConnOpsLock.lock();
        IMqttAsyncClient client = null;
        try {
            try {
                client = this.getMqttClient(true);
                client.unsubscribe(topic);
            }
            catch (MqttException e) {
                String exMessage = NLS.bind((String)Messages.MqttBuildClient_UNSUBSCRIBE_EXCEPTION, (Object)topic);
                Activator.getLog().error((Object)exMessage, (Throwable)e);
                throw new TeamRepositoryException(exMessage, (Throwable)e);
            }
        }
        finally {
            if (disconnectOnUnsubscribe && client != null && client.isConnected()) {
                try {
                    client.setCallback(null);
                    Thread disconnectThread = new Thread(new PahoCliDisconnectRunnable(client));
                    disconnectThread.start();
                    disconnectThread.join();
                }
                catch (Exception e) {
                    Activator.getLog().error((Object)Messages.MqttBuildClient_DISCONNECT_EXCEPTION, (Throwable)e);
                }
            }
            this.fMqttConnOpsLock.unlock();
        }
    }

    private IMqttAsyncClient getMqttClient() throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        return this.getMqttClient(false);
    }

    private synchronized IMqttAsyncClient getMqttClient(boolean tryGetConnect) throws LiveLogConfigurationException, LiveLogConnectionException, TeamRepositoryException {
        if (this.fMqttClient == null) {
            IMQTTInfoClientLibrary mqttInfoClient = this.getMqttInfoClient();
            MQTTBrokerConfigDTO mqttBrokerInfo = mqttInfoClient.getMQTTBrokerInfo();
            this.fMqttClient = this.fPahoBuilder.createPahoClient(mqttBrokerInfo, this.generateInstanceClientId());
        }
        if (tryGetConnect && !this.fMqttClient.isConnected()) {
            this.fPahoBuilder.connectPahoClient((MqttAsyncClient)this.fMqttClient, null, null);
        }
        return this.fMqttClient;
    }

    @Override
    public String getMqttClientId() throws TeamRepositoryException {
        return this.getMqttClient() != null ? this.getMqttClient().getClientId() : "";
    }

    protected final void registerMqttEvents(MqttCallback callback) throws LiveLogConfigurationException {
        try {
            IMqttAsyncClient mqttClient = this.getMqttClient();
            mqttClient.setCallback(callback);
        }
        catch (TeamRepositoryException e) {
            String errMsg = Messages.MqttBuildClient_CALLBACK_REGISTER_EXCEPTION;
            throw new LiveLogConfigurationException(errMsg, e);
        }
    }

    protected final IMQTTInfoClientLibrary getMqttInfoClient() {
        if (this.fMqttClientLib == null) {
            this.fMqttClientLib = (IMQTTInfoClientLibrary)this.fContext.teamRepository().getClientLibrary(IMQTTInfoClientLibrary.class);
        }
        return this.fMqttClientLib;
    }

    @Override
    public boolean isConnectedToBroker() {
        try {
            return this.getMqttClient().isConnected();
        }
        catch (TeamRepositoryException e) {
            return false;
        }
    }

    protected final LiveLogMessageFactory getLiveLogMessageFactory() {
        if (this.fMessageFactory == null) {
            this.fMessageFactory = LiveLogMessageFactory.getInstance();
        }
        return this.fMessageFactory;
    }

    protected final LiveLogTransportInterface getMessagingTransportInterface() {
        if (this.fTransportInterface == null) {
            this.fTransportInterface = this.getLiveLogMessageFactory().getTransportInterface();
        }
        return this.fTransportInterface;
    }

    public String generateInstanceClientId() {
        StringBuilder clientId = new StringBuilder("LiveLogClient_");
        clientId.append(UUID.generate().getUuidValue());
        return clientId.toString();
    }

    protected void finalize() throws Throwable {
        try {
            try {
                if (this.fMqttClient != null && this.fMqttClient.isConnected()) {
                    this.fMqttClient.disconnect();
                }
            }
            catch (MqttException e) {
                try {
                    this.fMqttClient.disconnectForcibly();
                }
                catch (MqttException mqttException) {
                    // empty catch block
                }
                try {
                    if (this.fMqttClient != null) {
                        this.fMqttClient.close();
                    }
                }
                catch (MqttException mqttException) {}
            }
        }
        finally {
            try {
                if (this.fMqttClient != null) {
                    this.fMqttClient.close();
                }
            }
            catch (MqttException mqttException) {}
        }
    }

    private static class PahoCliDisconnectRunnable
    implements Runnable {
        IMqttAsyncClient pahoClient;

        PahoCliDisconnectRunnable(IMqttAsyncClient client) {
            this.pahoClient = client;
        }

        @Override
        public void run() {
            try {
                this.pahoClient.disconnect();
            }
            catch (MqttException e) {
                Activator.getLog().error((Object)Messages.MqttBuildClient_DISCONNECT_EXCEPTION, (Throwable)e);
            }
        }
    }
}

