/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.workitems;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.java.ui.editors.result.junit.IJUnitRunErrorDetailProvider;
import com.ibm.team.build.internal.java.ui.workitems.Messages;
import com.ibm.team.build.internal.ui.actions.BuildResultEditorActionDelegate;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateWorkItemFromJUnitTestAction
extends BuildResultEditorActionDelegate {
    protected ISelection fSelection;

    public void run(IAction action) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ITeamRepository teamRepository = (ITeamRepository)this.fBuildResult.getOrigin();
        TeamBuildJob job = new TeamBuildJob(Messages.CreateWorkItemFromJUnitTestAction_CREATING_WORK_ITEM, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IJUnitRunErrorDetailProvider detailProvider = CreateWorkItemFromJUnitTestAction.this.getJUnitDetailProvider(CreateWorkItemFromJUnitTestAction.this.fSelection);
                final IProjectAreaHandle projectAreaHandle = CreateWorkItemFromJUnitTestAction.this.getProjectAreaHandle((IProgressMonitor)subMonitor.newChild(1));
                final String summary = CreateWorkItemFromJUnitTestAction.this.getSummary(detailProvider);
                final String description = CreateWorkItemFromJUnitTestAction.this.getDescription(detailProvider, (IProgressMonitor)subMonitor.newChild(1));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CreateWorkItemFromJUnitTestAction.this.handleCreateWorkItemAsync(shell, summary, description, projectAreaHandle);
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                CreateWorkItemFromJUnitTestAction.this.handleJobDone(status);
            }
        };
        job.schedule();
    }

    protected void handleJobDone(IStatus status) {
    }

    protected IProjectAreaHandle getProjectAreaHandle(IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildDefinitionHandle buildDefinitionHandle = this.fBuildResult.getBuildDefinition();
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        IBuildDefinition buildDefinition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
        IProcessAreaHandle processAreaHandle = buildDefinition.getProcessArea();
        IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
        return processArea.getProjectArea();
    }

    protected void handleCreateWorkItemAsync(Shell shell, String summary, String description, IProjectAreaHandle projectAreaHandle) {
        if (shell != null && !shell.isDisposed()) {
            WorkItemHelper.getInstance().createAndLinkWorkItem(shell, summary, description, (IBuildResultHandle)this.fBuildResult, projectAreaHandle);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        this.updateEnablement(action, this.fSelection);
    }

    protected String getSummary(IJUnitRunErrorDetailProvider detailProvider) {
        if (detailProvider.getJUnitName().length() == 0) {
            return NLS.bind((String)Messages.CreateWorkItemFromJUnitTestAction_TESTSUITE_FAILURE, (Object)this.fBuildResult.getLabel(), (Object)detailProvider.getJUnitClassName());
        }
        return NLS.bind((String)Messages.CreateWorkItemFromJUnitTestAction_TESTCASE_FAILURE, (Object[])new String[]{this.fBuildResult.getLabel(), detailProvider.getJUnitClassName(), detailProvider.getJUnitName()});
    }

    protected String getDescription(IJUnitRunErrorDetailProvider detailProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        String description = detailProvider.getDetailString();
        if (description == null) {
            ITeamRepository teamRepository = (ITeamRepository)this.fBuildResult.getOrigin();
            description = detailProvider.isError() ? ContentUtil.contentToString((ITeamRepository)teamRepository, (IContent)detailProvider.getErrorData(), (IProgressMonitor)monitor) : ContentUtil.contentToString((ITeamRepository)teamRepository, (IContent)detailProvider.getFailureData(), (IProgressMonitor)monitor);
        }
        return description;
    }

    protected void updateEnablement(IAction action, ISelection selection) {
        IJUnitRunErrorDetailProvider detailProvider = this.getJUnitDetailProvider(selection);
        action.setEnabled(detailProvider != null && (detailProvider.isError() || detailProvider.isFailure()));
    }

    protected IJUnitRunErrorDetailProvider getJUnitDetailProvider(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IJUnitRunErrorDetailProvider) {
            return (IJUnitRunErrorDetailProvider)element;
        }
        return null;
    }
}

