/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.workitems;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.java.ui.editors.result.compile.ICompileDetailProvider;
import com.ibm.team.build.internal.java.ui.workitems.Messages;
import com.ibm.team.build.internal.ui.actions.BuildResultEditorActionDelegate;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.workitem.WorkItemHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateWorkItemFromCompileAction
extends BuildResultEditorActionDelegate {
    protected ISelection fSelection;

    public void run(IAction action) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ITeamRepository teamRepository = (ITeamRepository)this.fBuildResult.getOrigin();
        TeamBuildJob job = new TeamBuildJob(Messages.CreateWorkItemFromCompileAction_JOB_LABEL, true, teamRepository){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                ICompileDetailProvider compileDetail = CreateWorkItemFromCompileAction.this.getCompileDetail(CreateWorkItemFromCompileAction.this.fSelection);
                final IProjectAreaHandle projectAreaHandle = CreateWorkItemFromCompileAction.this.getProjectAreaHandle((IProgressMonitor)subMonitor.newChild(1));
                final String summary = CreateWorkItemFromCompileAction.this.getSummary(compileDetail);
                final String description = CreateWorkItemFromCompileAction.this.getDescription(compileDetail, (IProgressMonitor)subMonitor.newChild(1));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CreateWorkItemFromCompileAction.this.handleCreateWorkItemAsync(shell, summary, description, projectAreaHandle);
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                CreateWorkItemFromCompileAction.this.handleJobDone(status);
            }
        };
        job.schedule();
    }

    protected IProjectAreaHandle getProjectAreaHandle(IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildDefinitionHandle buildDefinitionHandle = this.fBuildResult.getBuildDefinition();
        ITeamRepository teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin();
        IBuildDefinition buildDefinition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
        IProcessAreaHandle processAreaHandle = buildDefinition.getProcessArea();
        IProcessArea processArea = (IProcessArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
        return processArea.getProjectArea();
    }

    protected void handleCreateWorkItemAsync(Shell shell, String summary, String description, IProjectAreaHandle projectAreaHandle) {
        if (shell != null && !shell.isDisposed()) {
            WorkItemHelper.getInstance().createAndLinkWorkItem(shell, summary, description, (IBuildResultHandle)this.fBuildResult, projectAreaHandle);
        }
    }

    protected void handleJobDone(IStatus status) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        this.updateEnablement(action, this.fSelection);
    }

    protected String getSummary(ICompileDetailProvider compileDetail) {
        String sourceName = this.fBuildResult.getLabel();
        if (compileDetail instanceof IDeferredBuildTreeNode) {
            IDeferredBuildTreeNode node = (IDeferredBuildTreeNode)compileDetail;
            sourceName = node.getNodeName();
        }
        return NLS.bind((String)Messages.CreateWorkItemFromCompileAction_SUMMARY, (Object)sourceName);
    }

    protected String getDescription(ICompileDetailProvider compileDetail, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuffer buffer = new StringBuffer();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        buffer.append(compileDetail.getErrorDetails((IProgressMonitor)subMonitor.newChild(1)));
        buffer.append(compileDetail.getWarningDetails((IProgressMonitor)subMonitor.newChild(1)));
        return buffer.toString();
    }

    protected void updateEnablement(IAction action, ISelection selection) {
        ICompileDetailProvider compileDetail = this.getCompileDetail(selection);
        action.setEnabled(compileDetail != null && (compileDetail.hasErrors() || compileDetail.hasWarnings()));
    }

    protected ICompileDetailProvider getCompileDetail(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        ICompileDetailProvider compileDetail = null;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof ICompileDetailProvider) {
            compileDetail = (ICompileDetailProvider)element;
        }
        return compileDetail;
    }
}

