/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IJUnitTestCase;
import com.ibm.team.build.common.model.IJUnitTestClass;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.java.ui.editors.result.junit.IJUnitDetailProvider;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestCaseNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestSuiteNode;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class JUnitTestClassNode
extends AbstractBuildTreeNode
implements IJUnitDetailProvider {
    private IJUnitTestClass fTestClass = null;

    public JUnitTestClassNode(JUnitTestSuiteNode parentNode, IJUnitTestClass testClass) {
        super((IDeferredBuildTreeNode)parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"testClass", (Object)testClass);
        this.fTestClass = testClass;
    }

    public boolean hasChildren() {
        return true;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)this.fTestClass.getOrigin();
        this.fTestClass = (IJUnitTestClass)teamRepository.itemManager().fetchCompleteItem((IItemHandle)this.fTestClass, 0, monitor);
        List testCases = this.fTestClass.getTestCases();
        Object[] testCaseNodes = new JUnitTestCaseNode[testCases.size()];
        int i = 0;
        for (Object testCase : testCases) {
            testCaseNodes[i++] = new JUnitTestCaseNode(this, (IJUnitTestCase)testCase);
        }
        return testCaseNodes;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = BuildUIPlugin.getImage((String)"icons/obj16/test_obj.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fTestClass.getErrorCount() > 0 || this.fTestClass.getFailureCount() > 0) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage((Image)newImage, (BuildStatus)status);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fTestClass.getClassName();
            }
            case 1: {
                return Integer.toString(this.fTestClass.getTestCount());
            }
            case 2: {
                return Integer.toString(this.fTestClass.getFailureCount());
            }
            case 3: {
                return Integer.toString(this.fTestClass.getErrorCount());
            }
            case 4: {
                return TimeFormatHelper.formatAbbreviatedTime((long)this.fTestClass.getTimeTaken());
            }
            case 5: {
                return Integer.toString(this.fTestClass.getOrdinal());
            }
        }
        return null;
    }

    public Long getColumnAsLong(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.fTestClass.getTestCount();
            }
            case 2: {
                return this.fTestClass.getFailureCount();
            }
            case 3: {
                return this.fTestClass.getErrorCount();
            }
            case 4: {
                return this.fTestClass.getTimeTaken();
            }
            case 5: {
                return this.fTestClass.getOrdinal();
            }
        }
        return null;
    }

    public boolean hasProblems() {
        return this.fTestClass.getErrorCount() > 0 || this.fTestClass.getFailureCount() > 0;
    }

    public String getNodeName() {
        return this.getJUnitClassName();
    }

    @Override
    public String getJUnitClassName() {
        return this.fTestClass.getClassName();
    }

    @Override
    public String getJUnitName() {
        return "";
    }

    @Override
    public long getTimeTaken() {
        return this.fTestClass.getTimeTaken();
    }
}

