/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IJUnitTestCase;
import com.ibm.team.build.internal.common.helper.TimeFormatHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.java.ui.editors.result.junit.IJUnitRunErrorDetailProvider;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestClassNode;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.AbstractBuildTreeNode;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.repository.common.IContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class JUnitTestCaseNode
extends AbstractBuildTreeNode
implements IJUnitRunErrorDetailProvider {
    private IJUnitTestCase fTestCase = null;
    private String fDetailString = null;

    public JUnitTestCaseNode(JUnitTestClassNode parentNode, IJUnitTestCase testCase) {
        super((IDeferredBuildTreeNode)parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"testCase", (Object)testCase);
        this.fTestCase = testCase;
    }

    public IJUnitTestCase getTestCase() {
        return this.fTestCase;
    }

    public Object[] doFetchChildren(IProgressMonitor monitor) {
        return null;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = BuildUIPlugin.getImage((String)"icons/obj16/test_obj.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fTestCase.isError() || this.fTestCase.isFailure()) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage((Image)newImage, (BuildStatus)status);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getJUnitName();
            }
            case 1: {
                return "1";
            }
            case 2: {
                return this.isFailure() ? "1" : "0";
            }
            case 3: {
                return this.isError() ? "1" : "0";
            }
            case 4: {
                return TimeFormatHelper.formatAbbreviatedTime((long)this.getTimeTaken());
            }
            case 5: {
                return String.valueOf(Integer.toString(this.fTestCase.getOrdinal())) + "    ";
            }
        }
        return null;
    }

    public Long getColumnAsLong(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return 1L;
            }
            case 2: {
                return this.isFailure() ? 1L : 0L;
            }
            case 3: {
                return this.isError() ? 1L : 0L;
            }
            case 4: {
                return this.getTimeTaken();
            }
            case 5: {
                return this.fTestCase.getOrdinal();
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasProblems() {
        return this.fTestCase.isError() || this.fTestCase.isFailure();
    }

    public String getNodeName() {
        return this.getJUnitClassName();
    }

    @Override
    public String getJUnitClassName() {
        return this.fTestCase.getClassName();
    }

    @Override
    public IContent getErrorData() {
        return this.fTestCase.getErrorData();
    }

    @Override
    public IContent getFailureData() {
        return this.fTestCase.getFailureData();
    }

    @Override
    public String getJUnitName() {
        return this.fTestCase.getName();
    }

    @Override
    public long getTimeTaken() {
        return this.fTestCase.getTimeTaken();
    }

    @Override
    public boolean isError() {
        return this.fTestCase.isError();
    }

    @Override
    public boolean isFailure() {
        return this.fTestCase.isFailure();
    }

    @Override
    public String getDetailString() {
        return this.fDetailString;
    }

    @Override
    public void setDetailString(String detailString) {
        this.fDetailString = detailString;
    }
}

