/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.junit;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IJUnitTestSuiteContribution;
import com.ibm.team.build.internal.java.ui.JdtWorkspaceHelper;
import com.ibm.team.build.internal.java.ui.editors.result.junit.IJUnitDetailProvider;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitBuildResultNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitComponentNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitContentProvider;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitDetailBlock;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestCaseNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestClassNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.JUnitTestSuiteNode;
import com.ibm.team.build.internal.java.ui.editors.result.junit.UntiTestLocationUtils;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildLabelProvider;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.editors.result.BuildResultPage;
import com.ibm.team.build.internal.ui.editors.result.BuildResultsTreeViewerComparator;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JUnitResultsPage
extends BuildResultPage {
    protected IAction fOpenAction;
    public static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.junitPageContextMenu";
    protected boolean fShowSuccessNodes;
    public static final int TEST_COUNT_COLUMN_INDEX = 1;
    public static final int FAILURE_COUNT_COLUMN_INDEX = 2;
    public static final int ERROR_COUNT_COLUMN_INDEX = 3;
    public static final int TIME_TAKEN_COLUMN_INDEX = 4;
    public static final int RUN_ORDER_COLUMN_INDEX = 5;
    private JUnitDetailBlock fDetailBlock;
    private TreeViewer fViewer;
    private Tree fJUnitResultsTree;
    protected ViewerFilter fSuccessNodeFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IDeferredBuildTreeNode) {
                return ((IDeferredBuildTreeNode)element).hasProblems();
            }
            return true;
        }
    };

    public JUnitResultsPage(FormEditor editor, String id, String title, IBuildResultContext buildResultContext) {
        super(editor, id, title, new String[]{IJUnitTestSuiteContribution.EXTENDED_CONTRIBUTION_TYPE_ID}, buildResultContext);
        this.fOpenAction = new Action(BuildResultEditorMessages.JUnitResultsPage_OPEN_ACTION_NAME){

            public void run() {
                JUnitResultsPage.this.openSelection(JUnitResultsPage.this.getSelectedItem());
            }
        };
        this.fShowSuccessNodes = !this.containsFailures(this.getContributions());
    }

    public AbstractBuildResultPage.PageGroup getPageGroup() {
        return AbstractBuildResultPage.PageGroup.TESTS;
    }

    protected boolean addActionsToContextMenu(IMenuManager manager) {
        if (this.getSelectionCount() == 1 && this.getSelectedItem() instanceof IJUnitDetailProvider) {
            manager.add(this.fOpenAction);
            return true;
        }
        return false;
    }

    protected void openSelection(Object selectedItem) {
        IJUnitDetailProvider provider = (IJUnitDetailProvider)selectedItem;
        String locInfo = null;
        if (provider instanceof JUnitTestCaseNode && ((JUnitTestCaseNode)provider).getDetailString() != null) {
            locInfo = UntiTestLocationUtils.getLocationInfo(((JUnitTestCaseNode)provider).getDetailString());
        }
        if (provider.getJUnitName().length() > 0) {
            if (locInfo != null) {
                this.openJUnitSourceFile(locInfo, provider.getJUnitClassName(), provider.getJUnitName(), this.getEditorSite());
            } else {
                this.openJUnitSourceFile(provider.getJUnitClassName(), provider.getJUnitName(), this.getEditorSite());
            }
        } else if (locInfo != null) {
            this.openJavaSourceFile(locInfo, provider.getJUnitClassName(), this.getEditorSite());
        } else {
            this.openJavaSourceFile(provider.getJUnitClassName(), this.getEditorSite());
        }
    }

    protected void openJUnitSourceFile(String className, String testName, IEditorSite editorSite) {
        JdtWorkspaceHelper.openJUnitSourceFile(className, testName, editorSite);
    }

    protected void openJavaSourceFile(String className, IEditorSite editorSite) {
        JdtWorkspaceHelper.openJavaSourceFile(className, 1, editorSite);
    }

    protected boolean openJUnitSourceFile(String locationInfo, String className, String junitTestName, IEditorSite editorSite) {
        return JdtWorkspaceHelper.openJUnitSourceFile(UntiTestLocationUtils.getFilePath(locationInfo), UntiTestLocationUtils.getLineLocation(locationInfo), className, junitTestName, editorSite);
    }

    protected boolean openJavaSourceFile(String locationInfo, String className, IEditorSite editorSite) {
        return JdtWorkspaceHelper.openJavaSourceFile(UntiTestLocationUtils.getFilePath(locationInfo), className, 1, editorSite);
    }

    protected void doCreatePageContent(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.setBorderStyle(2048);
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.addResultTree(parent, toolkit);
        this.addDetails(parent, toolkit);
        this.createContextMenu(CONTEXT_MENU_ID, this.getSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.editor_buildresultjunit");
    }

    private void addResultTree(final Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        section.setText(BuildResultEditorMessages.JUnitResultsPage_JUnitTests);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)section);
        ToolBar toolbar = this.createToolbar(toolkit, (Composite)section);
        section.setTextClient((Control)toolbar);
        Composite treeComposite = toolkit.createComposite(body);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)treeComposite);
        section.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)section, 7);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(50, 0);
        treeComposite.setLayoutData((Object)formData);
        this.fJUnitResultsTree = toolkit.createTree(treeComposite, 268503810);
        this.fJUnitResultsTree.setLinesVisible(true);
        this.fJUnitResultsTree.setHeaderVisible(true);
        this.fJUnitResultsTree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                JUnitResultsPage.this.fJUnitResultsTree.removeListener(36, (Listener)this);
                body.layout(true, true);
            }
        });
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.NAME_COLUMN_TITLE, 50, 16384, 0);
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.TEST_COUNT_COLUMN_TITLE, 10, 131072, 1);
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.FAILURE_COUNT_COLUMN_TITLE, 10, 131072, 2);
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.ERROR_COUNT_COLUMN_TITLE, 10, 131072, 3);
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.TIME_TAKEN_COLUMN_TITLE, 10, 131072, 4);
        this.createTreeColumn(this.fJUnitResultsTree, treeColumnLayout, BuildResultEditorMessages.RUN_ORDER_COLUMN_TITLE, 10, 131072, 5);
        treeComposite.setLayout((Layout)treeColumnLayout);
        this.fViewer = new TreeViewer(this.fJUnitResultsTree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BuildLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new JUnitContentProvider(this.fViewer));
        this.fViewer.setComparator((ViewerComparator)new BuildResultsTreeViewerComparator());
        TreeColumn runOrderColumn = this.fViewer.getTree().getColumn(5);
        this.fViewer.getTree().setSortColumn(runOrderColumn);
        this.fViewer.getTree().setSortDirection(128);
        this.fViewer.addOpenListener(this.createTreeViewerOpenListener());
        Image showSuccessImage = BuildCompositeImageRegistry.getImage((Image)BuildUIPlugin.getImage((String)"icons/obj16/test_obj.gif"), (BuildStatus)BuildStatus.OK, (boolean)true);
        this.createFilterButton(showSuccessImage, BuildResultEditorMessages.JUnitResultsPage_FILTER_TOOLTIP, toolbar, this.fSuccessNodeFilter, (StructuredViewer)this.fViewer, this.fShowSuccessNodes);
        this.fViewer.setInput((Object)new JUnitBuildResultNode(this.getContributions()));
    }

    protected void toggleFilter(boolean buttonSelected, StructuredViewer viewer, ViewerFilter filter) {
        this.fShowSuccessNodes = buttonSelected;
        super.toggleFilter(buttonSelected, viewer, filter);
    }

    protected IOpenListener createTreeViewerOpenListener() {
        return new TreeViewerOpenListener();
    }

    private void addDetails(Composite body, FormToolkit toolkit) {
        Section section = toolkit.createSection(body, 256);
        section.setText(BuildResultEditorMessages.JUnitResultsPage_Details);
        GridLayoutFactory.fillDefaults().applyTo((Composite)section);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(50, 7);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        section.setLayoutData((Object)formData);
        this.fDetailBlock = this.createDetailBlock();
        section.setClient((Control)this.fDetailBlock.createContents((Composite)section, toolkit, this.getEditor()));
        this.fViewer.addSelectionChangedListener(this.createSelectionChangedListener());
    }

    protected JUnitDetailBlock createDetailBlock() {
        return new JUnitDetailBlock();
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected Object getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        return selection.getFirstElement();
    }

    protected int getSelectionCount() {
        return ((IStructuredSelection)this.fViewer.getSelection()).size();
    }

    protected BuildResultPage.CopyStrategy getCopyStrategy(Control control) {
        return BuildResultPage.CopyStrategy.FIRST;
    }

    protected String getCopyActionItemNameForSelectedItem(Control control) {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem instanceof JUnitComponentNode) {
            return BuildResultEditorMessages.JUnitResultsPage_COMPONENT_NAME;
        }
        if (selectedItem instanceof JUnitTestSuiteNode) {
            return BuildResultEditorMessages.JUnitResultsPage_TESTSUITE_NAME;
        }
        if (selectedItem instanceof JUnitTestClassNode) {
            return BuildResultEditorMessages.JUnitResultsPage_CLASS_NAME;
        }
        return BuildResultEditorMessages.JUnitResultsPage_TESTCASE_NAME;
    }

    protected void createTreeColumn(Tree tree, TreeColumnLayout layout, String columnName, int weight, int style, int index) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        treeColumn.addSelectionListener(this.getColumnSelectionListener(tree, treeColumn));
    }

    protected ISelectionChangedListener createSelectionChangedListener() {
        return new TreeViewerSelectionChangedListener();
    }

    protected SelectionListener createTreeColumnSelectionListener(TreeColumn treeColumn, Tree tree) {
        return new TreeColumnSelectionListener(treeColumn, tree);
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_buildresultjunit";
    }

    private final class TreeColumnSelectionListener
    implements SelectionListener {
        private final TreeColumn fTreeColumn;
        private final Tree fTree;

        private TreeColumnSelectionListener(TreeColumn treeColumn, Tree tree) {
            this.fTreeColumn = treeColumn;
            this.fTree = tree;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.fTree.getSortColumn() == this.fTreeColumn) {
                if (this.fTree.getSortDirection() == 1024) {
                    this.fTree.setSortDirection(128);
                } else {
                    this.fTree.setSortDirection(1024);
                }
            } else {
                this.fTree.setSortColumn(this.fTreeColumn);
                this.fTree.setSortDirection(1024);
            }
            Object[] expandedElements = JUnitResultsPage.this.fViewer.getExpandedElements();
            JUnitResultsPage.this.fViewer.refresh(false);
            JUnitResultsPage.this.fViewer.setExpandedElements(expandedElements);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class TreeViewerOpenListener
    implements IOpenListener {
        private TreeViewerOpenListener() {
        }

        public void open(OpenEvent event) {
            Object element = JUnitResultsPage.this.getSelectedItem();
            if (element instanceof JUnitTestCaseNode) {
                JUnitResultsPage.this.openSelection(element);
            }
        }
    }

    private final class TreeViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                Object element = selection.getFirstElement();
                if (JUnitResultsPage.this.inRemoveFilterCall()) {
                    return;
                }
                if (element instanceof IJUnitDetailProvider) {
                    JUnitResultsPage.this.fDetailBlock.setDetailProvider((IJUnitDetailProvider)element, JUnitResultsPage.this.getBuildResultContext().getTeamRepository());
                    return;
                }
            }
            JUnitResultsPage.this.fDetailBlock.setDetailProvider(null, null);
        }
    }
}

