/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.java.ui.editors.result.compile.AbstractCompileTreeNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompileComponentNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompileSourceNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.ICompileTreeNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.Messages;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CompilePackageNode
extends AbstractCompileTreeNode {
    private String fPackageName = null;
    private String fPackageType = null;
    private int fWarningCount = 0;
    private int fErrorCount = 0;
    private List<ICompilePackage> fCompilePackages = new ArrayList<ICompilePackage>();
    private List<CompileSourceNode> fSourceNodes = new ArrayList<CompileSourceNode>();
    private Hashtable<String, CompilePackageNode> fSubPackageNodeMap = new Hashtable();

    public CompilePackageNode(ICompileTreeNode parentNode, String packageName, String packageType) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"packageName", (Object)packageName);
        ValidationHelper.validateNotNull((String)"packageType", (Object)packageType);
        this.fPackageName = packageName;
        this.fPackageType = packageType;
    }

    public void addCompilePackage(ICompilePackage compilePackage) {
        this.fCompilePackages.add(compilePackage);
        this.fWarningCount += compilePackage.getWarningCount();
        this.fErrorCount += compilePackage.getErrorCount();
    }

    public int getPackageCount() {
        return this.fCompilePackages.size();
    }

    public boolean hasChildren() {
        return true;
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        for (ICompilePackage compilePackage : this.fCompilePackages) {
            compilePackage = this.fetchCompilePackage(compilePackage, monitor);
            ITeamRepository teamRepository = (ITeamRepository)compilePackage.getOrigin();
            List subCompilePackages = compilePackage.getSubCompilePackages();
            List fetchedCompilePackages = teamRepository.itemManager().fetchPartialItems(subCompilePackages, 0, (Collection)CompileComponentNode.PARTIAL_COMPILE_PACKAGE_PROPERTIES, monitor);
            for (Object object : fetchedCompilePackages) {
                this.addSubCompilePackageNode((ICompilePackage)object);
            }
            List compileSources = compilePackage.getCompileSources();
            for (Object object : compileSources) {
                this.fSourceNodes.add(new CompileSourceNode(this, (ICompileSource)object));
            }
        }
        ArrayList<AbstractCompileTreeNode> childNodes = new ArrayList<AbstractCompileTreeNode>(this.fSourceNodes.size() + this.fSubPackageNodeMap.size());
        childNodes.addAll(this.fSubPackageNodeMap.values());
        childNodes.addAll(this.fSourceNodes);
        return childNodes.toArray();
    }

    protected ICompilePackage fetchCompilePackage(ICompilePackage compilePackage, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)compilePackage.getOrigin();
        return (ICompilePackage)teamRepository.itemManager().fetchCompleteItem((IItemHandle)compilePackage, 0, monitor);
    }

    private void addSubCompilePackageNode(ICompilePackage compilePackage) {
        String packageName = compilePackage.getPackageName();
        CompilePackageNode node = this.fSubPackageNodeMap.get(packageName);
        if (node == null) {
            node = new CompilePackageNode(this, packageName, compilePackage.getPackageType());
            this.fSubPackageNodeMap.put(packageName, node);
        }
        node.addCompilePackage(compilePackage);
    }

    public String getPackageType() {
        return this.fPackageType;
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image newImage = null;
            newImage = this.fPackageType.equals("plugin") ? BuildUIPlugin.getImage((String)"icons/obj16/plugin_obj.gif") : (this.fPackageType.equals("project") ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT") : (this.fPackageType.equals("folder") ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER") : JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif")));
            BuildStatus status = BuildStatus.OK;
            if (this.hasWarnings()) {
                status = BuildStatus.WARNING;
            }
            if (this.hasErrors()) {
                status = BuildStatus.ERROR;
            }
            return BuildCompositeImageRegistry.getImage((Image)newImage, (BuildStatus)status, (boolean)false);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String packageName = this.fPackageName;
                if (this.fPackageType.equals("plugin")) {
                    if (packageName.indexOf(95) != -1) {
                        packageName = packageName.substring(0, packageName.indexOf(95));
                    }
                } else if (this.fPackageType.equals("package") && packageName.length() == 0) {
                    packageName = Messages.CompilePackageNode_DEFAULT_PACKAGE_LABEL;
                }
                return packageName;
            }
            case 2: {
                return Integer.toString(this.fWarningCount);
            }
            case 1: {
                return Integer.toString(this.fErrorCount);
            }
        }
        return null;
    }

    public Long getColumnAsLong(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.fWarningCount;
            }
            case 1: {
                return this.fErrorCount;
            }
        }
        return null;
    }

    public boolean hasProblems() {
        return this.fErrorCount > 0 || this.fWarningCount > 0;
    }

    public String getNodeName() {
        return this.fPackageName;
    }

    @Override
    public boolean hasWarnings() {
        return this.fWarningCount > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.fErrorCount > 0;
    }
}

