/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompileContributionHandle;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompileResultsPage;
import com.ibm.team.build.internal.java.ui.editors.result.compile.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.repository.client.ITeamRepository;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.forms.editor.FormEditor;

public class CompileContributionProvider
extends AbstractBuildResultContributionProvider {
    private int fErrorCount;
    private int fWarningCount;
    private IBuildResultContribution[] fContributions;

    public CompileContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fErrorCount = 0;
        this.fWarningCount = 0;
        this.fContributions = new IBuildResultContribution[0];
        ITeamRepository teamRepository = this.getBuildResultContext().getTeamRepository();
        ArrayList<ICompileContributionHandle> compileHandles = new ArrayList<ICompileContributionHandle>();
        this.fContributions = this.getContributions();
        IBuildResultContribution[] iBuildResultContributionArray = this.fContributions;
        int n = this.fContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            compileHandles.add((ICompileContributionHandle)contribution.getExtendedContribution());
            ++n2;
        }
        if (this.fContributions.length > 0) {
            List<String> properties = Arrays.asList(ICompileContribution.PROPERTY_ERROR_COUNT, ICompileContribution.PROPERTY_WARNING_COUNT);
            List compiles = teamRepository.itemManager().fetchPartialItems(compileHandles, 0, properties, monitor);
            for (Object object : compiles) {
                if (object == null) continue;
                ICompileContribution compile = (ICompileContribution)object;
                this.fErrorCount += compile.getErrorCount();
                this.fWarningCount += compile.getWarningCount();
            }
        }
    }

    public BuildStatus getStatus() {
        if (this.fErrorCount > 0) {
            return BuildStatus.ERROR;
        }
        if (this.fWarningCount > 0) {
            return BuildStatus.WARNING;
        }
        return BuildStatus.OK;
    }

    public String getSummaryText() {
        if (this.fContributions.length > 0) {
            return MessageFormat.format(Messages.CompileContributionProvider_SUMMARY_TEXT, String.valueOf(this.fErrorCount), this.getErrorString(), String.valueOf(this.fWarningCount), this.getWarningString());
        }
        return Messages.CompileContributionProvider_NO_COMPILES;
    }

    private String getWarningString() {
        if (this.fWarningCount == 1) {
            return Messages.CompileContributionProvider_ONE_WARNING;
        }
        return Messages.CompileContributionProvider_MULTIPLE_WARNINGS;
    }

    private String getErrorString() {
        if (this.fErrorCount == 1) {
            return Messages.CompileContributionProvider_ONE_ERROR;
        }
        return Messages.CompileContributionProvider_MULTIPLE_ERRORS;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID};
    }

    public boolean isSummaryLink() {
        return this.fContributions.length > 0;
    }

    public void summaryLinkActivated() {
        this.getBuildResultEditor().setActivePage(this.getExtensionId());
    }

    public String getSummaryTitle() {
        return Messages.CompileContributionProvider_SUMMARY_TITLE;
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return new CompileResultsPage(this.getBuildResultEditor(), this.getExtensionId(), Messages.CompileContributionProvider_PAGE_TITLE, this.getBuildResultContext());
    }
}

