/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui.editors.result.compile;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.java.ui.editors.result.compile.AbstractCompileTreeNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompileBuildResultNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompilePackageNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.ICompileTreeNode;
import com.ibm.team.build.internal.java.ui.editors.result.compile.SimpleCompileContributionNode;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class CompileComponentNode
extends AbstractCompileTreeNode {
    static final List PARTIAL_COMPILE_PACKAGE_PROPERTIES = new LinkedList();
    private List<ICompileContribution> fCompileContributions = new ArrayList<ICompileContribution>();
    private List<IBuildResultContribution> fBuildResultContributions = new ArrayList<IBuildResultContribution>();
    private Hashtable<String, CompilePackageNode> fPackageNodeMap = new Hashtable();
    private List<ICompileTreeNode> fChildNodeList = new ArrayList<ICompileTreeNode>();
    private String fComponentName = null;
    private int fWarningCount = 0;
    private int fErrorCount = 0;

    static {
        PARTIAL_COMPILE_PACKAGE_PROPERTIES.add(ICompilePackage.PROPERTY_ERROR_COUNT);
        PARTIAL_COMPILE_PACKAGE_PROPERTIES.add(ICompilePackage.PROPERTY_WARNING_COUNT);
        PARTIAL_COMPILE_PACKAGE_PROPERTIES.add(ICompilePackage.PROPERTY_CLASS_COUNT);
        PARTIAL_COMPILE_PACKAGE_PROPERTIES.add(ICompilePackage.PROPERTY_PACKAGE_NAME);
        PARTIAL_COMPILE_PACKAGE_PROPERTIES.add(ICompilePackage.PROPERTY_PACKAGE_TYPE);
    }

    public CompileComponentNode(CompileBuildResultNode parentNode, String componentName) {
        super(parentNode);
        ValidationHelper.validateNotNull((String)"parentNode", (Object)parentNode);
        ValidationHelper.validateNotNull((String)"componentName", (Object)componentName);
        this.fComponentName = componentName.length() == 0 ? BuildResultEditorMessages.NO_COMPONENT_LABEL : componentName;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getContributionCount() {
        return this.fBuildResultContributions.size();
    }

    public void addCompileContribution(IBuildResultContribution buildResultContribution, ICompileContribution compileContribution) {
        this.fBuildResultContributions.add(buildResultContribution);
        this.fCompileContributions.add(compileContribution);
        this.fWarningCount += compileContribution.getWarningCount();
        this.fErrorCount += compileContribution.getErrorCount();
    }

    protected Object[] doFetchChildren(IProgressMonitor monitor) throws TeamRepositoryException {
        this.fChildNodeList.clear();
        this.fPackageNodeMap.clear();
        Object[] children = null;
        int i = 0;
        while (i < this.fBuildResultContributions.size()) {
            IBuildResultContribution buildResultContribution = this.fBuildResultContributions.get(i);
            ICompileContribution compileContribution = this.fCompileContributions.get(i);
            if (this.isSimpleContribution(compileContribution = this.fetchCompileContribution(compileContribution, monitor))) {
                this.fChildNodeList.add(new SimpleCompileContributionNode(this, buildResultContribution, compileContribution));
            } else {
                ITeamRepository teamRepository = (ITeamRepository)compileContribution.getOrigin();
                List compilePackages = compileContribution.getCompilePackages();
                List fetchedCompilePackages = teamRepository.itemManager().fetchPartialItems(compilePackages, 0, (Collection)PARTIAL_COMPILE_PACKAGE_PROPERTIES, monitor);
                for (Object object : fetchedCompilePackages) {
                    this.addCompilePackageNode((ICompilePackage)object);
                }
            }
            ++i;
        }
        this.fChildNodeList.addAll(this.fPackageNodeMap.values());
        children = this.fChildNodeList.toArray(new ICompileTreeNode[this.fChildNodeList.size()]);
        return children;
    }

    protected ICompileContribution fetchCompileContribution(ICompileContribution compileContribution, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)compileContribution.getOrigin();
        return (ICompileContribution)teamRepository.itemManager().fetchCompleteItem((IItemHandle)compileContribution, 0, monitor);
    }

    protected void logException(TeamRepositoryException exception) {
        BuildUIPlugin.log((Throwable)exception);
    }

    private boolean isSimpleContribution(ICompileContribution compileContribution) {
        return compileContribution.getClassCount() == 0;
    }

    private void addCompilePackageNode(ICompilePackage compilePackage) {
        String packageName = compilePackage.getPackageName();
        CompilePackageNode node = this.fPackageNodeMap.get(packageName);
        if (node == null) {
            node = new CompilePackageNode(this, packageName, compilePackage.getPackageType());
            this.fPackageNodeMap.put(packageName, node);
        }
        node.addCompilePackage(compilePackage);
    }

    public Image getColumnImage(int columnIndex) {
        if (columnIndex == 0) {
            Image image = BuildUIPlugin.getImage((String)"icons/obj16/component_obj.gif");
            BuildStatus status = BuildStatus.OK;
            if (this.fErrorCount > 0) {
                status = BuildStatus.ERROR;
            } else if (this.fWarningCount > 0) {
                status = BuildStatus.WARNING;
            }
            return BuildCompositeImageRegistry.getImage((Image)image, (BuildStatus)status, (boolean)false);
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fComponentName;
            }
            case 2: {
                return Integer.toString(this.fWarningCount);
            }
            case 1: {
                return Integer.toString(this.fErrorCount);
            }
        }
        return null;
    }

    public Long getColumnAsLong(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return this.fWarningCount;
            }
            case 1: {
                return this.fErrorCount;
            }
        }
        return null;
    }

    public boolean hasProblems() {
        return this.fErrorCount > 0 || this.fWarningCount > 0;
    }

    public String getNodeName() {
        return this.fComponentName;
    }

    @Override
    public boolean hasWarnings() {
        return this.fWarningCount > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.fErrorCount > 0;
    }
}

