/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui;

import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.java.ui.JdtWorkspaceHelper;
import com.ibm.team.build.internal.java.ui.editors.result.compile.CompileSourceNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class OpenCompileSourceActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            if (action != null) {
                action.setEnabled(this.fSelection.size() == 1);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fSelection.getFirstElement() instanceof CompileSourceNode) {
            ICompileSource compileSource = ((CompileSourceNode)this.fSelection.getFirstElement()).getCompileSource();
            this.openCompileSource(compileSource, 1, this.fTargetPart.getSite().getPage());
        }
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected IWorkbenchPart getActivePart() {
        return this.fTargetPart;
    }

    protected void openCompileSource(ICompileSource compileSource, int lineNumber, IWorkbenchPage workbenchPage) {
        this.openSourceFile(compileSource, lineNumber, workbenchPage);
    }

    protected void openSourceFile(ICompileSource compileSource, int lineNumber, IWorkbenchPage workbenchPage) {
        JdtWorkspaceHelper.openSourceFile(compileSource, lineNumber, workbenchPage.getActiveEditor().getEditorSite());
    }
}

