/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.java.ui;

import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.common.helper.FileHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.CompileSourceHelper;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.dialogs.OpenResourceDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JdtWorkspaceHelper
extends WorkspaceHelper {
    private static JdtWorkspaceHelper SINGLETON_WORKSPACE_HELPER = new JdtWorkspaceHelper();

    public static boolean openJavaSourceFile(String fullyQualifiedTypeName, int lineNumber, IEditorSite editorSite) {
        ValidationHelper.validateNotEmpty((String)"fullyQualifiedTypeName", (String)fullyQualifiedTypeName);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.doOpenJavaSourceFile(fullyQualifiedTypeName, lineNumber, editorSite);
    }

    public static boolean openJUnitSourceFile(String fullyQualifiedTypeName, String testCaseName, IEditorSite editorSite) {
        ValidationHelper.validateNotEmpty((String)"fullyQualifiedTypeName", (String)fullyQualifiedTypeName);
        ValidationHelper.validateNotEmpty((String)"testCaseName", (String)testCaseName);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.doOpenJUnitSourceFile(fullyQualifiedTypeName, testCaseName, editorSite);
    }

    protected boolean doOpenJavaSourceFile(String className, int lineNumber, IEditorSite editorSite) {
        IFile javaFile = this.findJavaSourceFile(className);
        if (javaFile == null) {
            return false;
        }
        return this.openWorkspaceFileToLocation(javaFile, lineNumber, editorSite);
    }

    protected boolean doOpenJUnitSourceFile(String className, String testCaseName, IEditorSite editorSite) {
        IFile javaFile = this.findJavaSourceFile(className);
        if (javaFile == null) {
            return false;
        }
        return this.openWorkspaceFileToLocation(javaFile, testCaseName, editorSite);
    }

    protected boolean doOpenJavaSourceFile(String filePath, String className, int lineNumber, IEditorSite editorSite) {
        IFile javaFile = this.findJavaSourceFile(className, false);
        if (javaFile != null) {
            return this.openWorkspaceFileToLocation(javaFile, lineNumber, editorSite);
        }
        return this.openSourceFileToLocation(filePath, className, lineNumber, editorSite);
    }

    protected boolean doOpenJUnitSourceFile(String filePath, int lineNum, String className, String testCaseName, IEditorSite editorSite) {
        IFile javaFile = this.findJavaSourceFile(className, false);
        if (javaFile != null) {
            return this.openWorkspaceFileToLocation(javaFile, testCaseName, editorSite);
        }
        return this.openSourceFileToLocation(filePath, className, lineNum > 0 ? lineNum : 1, editorSite);
    }

    public static boolean openJavaSourceFile(String filePath, String fullyQualifiedTypeName, int lineNumber, IEditorSite editorSite) {
        ValidationHelper.validateNotEmpty((String)"fullyQualifiedTypeName", (String)fullyQualifiedTypeName);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.doOpenJavaSourceFile(filePath, fullyQualifiedTypeName, lineNumber, editorSite);
    }

    public static boolean openJUnitSourceFile(String filePath, int lineNumber, String fullyQualifiedTypeName, String testCaseName, IEditorSite editorSite) {
        ValidationHelper.validateNotEmpty((String)"fullyQualifiedTypeName", (String)fullyQualifiedTypeName);
        ValidationHelper.validateNotEmpty((String)"testCaseName", (String)testCaseName);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.doOpenJUnitSourceFile(filePath, lineNumber, fullyQualifiedTypeName, testCaseName, editorSite);
    }

    protected IFile findJavaSourceFile(String className) {
        return this.findJavaSourceFile(className, true);
    }

    protected IFile findJavaSourceFile(String className, boolean showErrorDlg) {
        IFile javaFile = null;
        try {
            javaFile = this.doFindJavaFile(className);
        }
        catch (JavaModelException exception) {
            this.showErrorDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_ERROR_OPENING_FILE_MESSAGE, (Object)className), null, (Exception)((Object)exception));
            return null;
        }
        if (javaFile == null && showErrorDlg) {
            this.showErrorDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_JAVA_SOURCE_FILE_NOT_FOUND_ERROR_MESSAGE, (Object)className), BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_DIALOG_TITLE, null);
            return null;
        }
        return javaFile;
    }

    public static boolean openWorkspaceFile(IFile file, int lineNumber, IEditorSite editorSite) {
        ValidationHelper.validateNotNull((String)"file", (Object)file);
        ValidationHelper.validateNotNull((String)"editorSite", (Object)editorSite);
        return SINGLETON_WORKSPACE_HELPER.openWorkspaceFileToLocation(file, lineNumber, editorSite);
    }

    private boolean openSourceFileToLocation(String filePath, String fileName, int lineNumber, IEditorSite editorSite) {
        IFile iFile = this.findFileInWorkspace(filePath);
        if (iFile != null) {
            return JdtWorkspaceHelper.openWorkspaceFile(iFile, lineNumber, editorSite);
        }
        OpenResourceDialog dialog = new OpenResourceDialog(editorSite.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        String fileNameFromFilePath = this.getFileName(filePath);
        fileName = fileNameFromFilePath != null ? fileNameFromFilePath : fileName;
        dialog.setInitialPattern(fileName);
        if (dialog.open() == 0) {
            if (dialog.getResult().length > 0) {
                if (dialog.getResult()[0] instanceof IFile) {
                    IFile file = (IFile)dialog.getResult()[0];
                    return JdtWorkspaceHelper.openWorkspaceFile(file, lineNumber, editorSite);
                }
            } else {
                IEditorPart activeEditor = editorSite.getPage().getActiveEditor();
                SINGLETON_WORKSPACE_HELPER.positionToLocationInEditor(activeEditor, lineNumber, fileName);
                return true;
            }
        }
        return false;
    }

    private String getFileName(String filePath) {
        try {
            if (filePath != null) {
                filePath = filePath.replace("\\", "/");
                File f = new File(filePath);
                return f.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private IFile findFileInWorkspace(String filePath) {
        if (filePath != null) {
            return this.findFileInWorkspace((IContainer)ResourcesPlugin.getWorkspace().getRoot(), filePath, this.getFileName(filePath));
        }
        return null;
    }

    private IFile findFileInWorkspace(IContainer container, String filePath, String fileName) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    return this.findFileInWorkspace((IContainer)member, filePath, fileName);
                }
                if (member instanceof IFile && ((IFile)member).getName().equals(fileName)) {
                    return (IFile)member;
                }
                ++n2;
            }
            return null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    protected boolean openWorkspaceFileToLocation(IFile file, Object location, IEditorSite editorSite) {
        if (!file.exists()) {
            String errorMessage = NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_ERROR_MESSAGE, (Object)file.getName());
            this.showErrorDialog(errorMessage, BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_DIALOG_TITLE, null);
            return false;
        }
        try {
            IEditorPart editorPart = this.openEditor(editorSite.getPage(), file);
            String fileName = file.getName();
            this.positionToLocationInEditor(editorPart, location, fileName);
            return true;
        }
        catch (CoreException exception) {
            BuildUIPlugin.log((IStatus)exception.getStatus());
            this.showErrorDialog(BuildUIHelperMessages.WorkspaceHelper_ERROR_OPENING_FILE_MESSAGE, null, (Exception)((Object)exception));
            return false;
        }
    }

    protected void navigateToLineNumber(ITextEditor textEditor, IDocument document, int lineNumber, String fileName) {
        try {
            int editorLineNumber = lineNumber;
            if (editorLineNumber != 0) {
                --editorLineNumber;
            }
            IRegion line = document.getLineInformation(editorLineNumber);
            textEditor.selectAndReveal(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            this.openWarningDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_ERROR_MESSAGE, (Object[])new String[]{Integer.toString(lineNumber), fileName}), BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_DIALOG_TITLE);
        }
    }

    protected void navigateToTestMethod(ITextEditor textEditor, IDocument document, String testCaseName, String fileName) {
        Pattern testCasePattern = Pattern.compile("public[\\s]*void[\\s]*" + testCaseName + "[\\s]*\\(");
        Matcher testCaseMatcher = testCasePattern.matcher(document.get());
        if (testCaseMatcher.find()) {
            int start = testCaseMatcher.start() + testCaseMatcher.group().indexOf(testCaseName);
            textEditor.selectAndReveal(start, testCaseName.length());
        } else {
            this.openWarningDialog(NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_JUNIT_TESTCASE_NOT_FOUND_ERROR_MESSAGE, (Object[])new String[]{testCaseName, fileName}), BuildUIHelperMessages.WorkspaceHelper_LOCATION_NOT_FOUND_DIALOG_TITLE);
        }
    }

    public static IFile findJavaFile(String qualifiedTypeName) throws JavaModelException {
        ValidationHelper.validateNotEmpty((String)"qualifiedTypeName", (String)qualifiedTypeName);
        return SINGLETON_WORKSPACE_HELPER.doFindJavaFile(qualifiedTypeName);
    }

    protected IFile doFindJavaFile(String typeName) throws JavaModelException {
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        final IFile[] file = new IFile[1];
        TypeNameRequestor requestor = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageNameChars, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                file[0] = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            }
        };
        engine.searchAllTypeNames(this.getPackageName(typeName).toCharArray(), 0, this.getClassName(typeName).toCharArray(), 0, 0, scope, requestor, 3, null);
        return file[0];
    }

    public static IType findJavaType(String qualifiedTypeName) throws JavaModelException {
        ValidationHelper.validateNotEmpty((String)"qualifiedTypeName", (String)qualifiedTypeName);
        return SINGLETON_WORKSPACE_HELPER.doFindJavaType(qualifiedTypeName);
    }

    protected IType doFindJavaType(String typeName) throws JavaModelException {
        final ArrayList typeNameMatches = new ArrayList();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                typeNameMatches.add(match);
            }
        };
        new SearchEngine().searchAllTypeNames(this.getPackageName(typeName).toCharArray(), 8, this.getClassName(typeName).toCharArray(), 8, 5, scope, requestor, 3, null);
        if (!typeNameMatches.isEmpty()) {
            return ((TypeNameMatch)typeNameMatches.get(0)).getType();
        }
        return null;
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IFile file) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    protected void connectProvider(IDocumentProvider provider, IEditorInput editorInput) throws CoreException {
        provider.connect((Object)editorInput);
    }

    protected void showErrorDialog(String message, String title, Exception exception) {
        BuildUIHelper.showErrorDialog((String)message, (String)title, (Exception)exception);
    }

    protected MessageDialog createWarningDialog(String message, String title) {
        return new MessageDialog(null, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected void openWarningDialog(String message, String title) {
        this.createWarningDialog(message, title).open();
    }

    private String getPackageName(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String packageName = typeName.substring(0, index);
        return packageName;
    }

    private String getClassName(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            return typeName;
        }
        String className = typeName.substring(index + 1);
        return className;
    }

    public static boolean openSourceFile(ICompileSource compileSource, int lineNumber, IEditorSite editorSite) {
        if (JdtWorkspaceHelper.isJavaSource(compileSource)) {
            String fullTypeName = CompileSourceHelper.getFullyQualifiedTypeName((ICompileSource)compileSource);
            return JdtWorkspaceHelper.openJavaSourceFile(fullTypeName, lineNumber, editorSite);
        }
        String initialPattern = compileSource.getSourceName();
        OpenResourceDialog dialog = new OpenResourceDialog(editorSite.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setInitialPattern(initialPattern);
        if (dialog.open() == 0) {
            if (dialog.getResult().length > 0) {
                if (dialog.getResult()[0] instanceof IFile) {
                    IFile file = (IFile)dialog.getResult()[0];
                    return JdtWorkspaceHelper.openWorkspaceFile(file, lineNumber, editorSite);
                }
            } else {
                IEditorPart activeEditor = editorSite.getPage().getActiveEditor();
                SINGLETON_WORKSPACE_HELPER.positionToLocationInEditor(activeEditor, lineNumber, initialPattern);
            }
        }
        return false;
    }

    private static boolean isJavaSource(ICompileSource compileSource) {
        return "package".equals(compileSource.getCompilePackage().getPackageType()) && FileHelper.hasFileSuffix((String)compileSource.getSourceName(), (String[])new String[]{".java"});
    }
}

