/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.util;

import com.ibm.team.build.extensions.common.nls.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Verification {
    private static final String EMPTY = "";
    private static final String FALSE = "false";
    private static final String NO = "no";
    private static final String ONE = "1";
    private static final String TRUE = "true";
    private static final String YES = "yes";
    private static final String ZERO = "0";
    private static final List<String> t = Arrays.asList("true", "yes", "1");
    private static final List<String> f = Arrays.asList("false", "no", "0");
    private static final int UUID_LENGTH = 23;
    private static final String UUID_REGEXP = "_[a-zA-Z0-9_-]{22}";
    private static final String UUID_STARTS = "_";
    private static final String REGEX_AN = "^[a-zA-Z0-9]+$";
    private static final String REGEX_ANA = "^[a-zA-Z]([a-zA-Z0-9]+)?$";
    private static final String REGEX_ANX = "^[a-zA-Z][a-zA-Z0-9\\.\\_\\@\\#\\$]*$";
    private static final String REGEX_ANZ = "^[a-zA-Z][a-zA-Z0-9\\.\\_\\%1$s\\%2$s\\%3$s]*$";
    private static final String REGEX_DSN = "^[@#\\$A-Z][@#\\$\\-A-Z0-9]{0,7}$";
    private static final String REGEX_MBR = "^[@#\\$A-Z][@#\\$A-Z0-9]{0,7}$";

    private static boolean findNonBlank(String[] s) {
        int i = 0;
        while (i < s.length) {
            if (!s[i].equals(EMPTY)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasBalancedParenthesis(String s) {
        int count = 0;
        if (s.contains("(") || s.contains(")")) {
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == "(".charAt(0)) {
                    ++count;
                }
                if (s.charAt(i) == ")".charAt(0)) {
                    --count;
                }
                ++i;
            }
        }
        return count == 0;
    }

    public static boolean isAlphaAlphaNumeric(String s) {
        return s != null && s.matches(REGEX_ANA);
    }

    public static boolean isNonAlphaAlphaNumeric(String s) {
        return s == null || !s.matches(REGEX_ANA);
    }

    public static boolean isAlphaNumeric(String s) {
        return s != null && s.matches(REGEX_AN);
    }

    public static boolean isNonAlphaNumeric(String s) {
        return s == null || !s.matches(REGEX_AN);
    }

    public static boolean isAlphaNumericExtended(String s) {
        return Verification.xisAlphaNumericExtended(s, REGEX_ANX);
    }

    public static boolean isAlphaNumericExtended(String s, String nc) {
        String r = String.format(REGEX_ANZ, nc.substring(0, 1), nc.substring(1, 2), nc.substring(2));
        return Verification.xisAlphaNumericExtended(s, r);
    }

    private static boolean xisAlphaNumericExtended(String s, String regex) {
        return s != null && s.matches(regex);
    }

    public static boolean isNonAlphaNumericExtended(String s) {
        return s == null || !s.matches(REGEX_ANX);
    }

    public static boolean isBlank(String s) {
        return s != null && s.equals(EMPTY);
    }

    public static boolean isBlank(String[] s) {
        return s == null || s.length == 0 || !Verification.findNonBlank(s);
    }

    public static boolean isNonBlank(String s) {
        return s != null && !s.trim().equals(EMPTY);
    }

    public static boolean isNonBlank(String[] s) {
        return s != null && s.length != 0 && Verification.findNonBlank(s);
    }

    public static boolean isDatasetName(String s) {
        if (s == null) {
            return false;
        }
        if (!s.contains(".")) {
            return s.matches(REGEX_DSN);
        }
        if (s.startsWith(".")) {
            return false;
        }
        if (s.endsWith(".")) {
            return false;
        }
        Pattern p = Pattern.compile("(.*)(\\$\\{?.*?(?:}|$))");
        Matcher m = p.matcher(s);
        StringBuffer scrubbed = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(scrubbed, (String.valueOf(m.group(1)) + m.group(2).replace(".", "++||++")).replace("\\", "\\\\").replace("$", "\\$"));
        }
        m.appendTail(scrubbed);
        String[] tokens = scrubbed.toString().split("\\.");
        int length = 0;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith("${") && token.endsWith("}")) {
                ++length;
            } else {
                if (!token.matches(REGEX_DSN)) {
                    return false;
                }
                length += token.length();
            }
            ++n2;
        }
        return length + tokens.length - 1 <= 44;
    }

    public static boolean isNonDatasetName(String s) {
        return !Verification.isDatasetName(s);
    }

    public static boolean isAccountNumber(String s, String nc) {
        if (s == null) {
            return false;
        }
        if (s.length() > 40) {
            return false;
        }
        if (s.contains(";")) {
            return false;
        }
        if (!Verification.isAlphaNumericExtended(s, nc)) {
            return false;
        }
        return Verification.hasBalancedParenthesis(s);
    }

    public static boolean isEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNonEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public static boolean isNonEmpty(Object[] a) {
        return a != null && a.length != 0;
    }

    public static boolean isEmpty(List<?> l) {
        return l == null || l.isEmpty();
    }

    public static boolean isNonEmpty(List<?> l) {
        return l != null && !l.isEmpty();
    }

    public static boolean isEmpty(List<?> l, int i) {
        return l == null || l.isEmpty() || l.size() <= i;
    }

    public static boolean isNonEmpty(List<?> l, int i) {
        return l != null && !l.isEmpty() && l.size() > i;
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNonEmpty(Map<?, ?> m) {
        return m != null && !m.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isInteger(String s) {
        if (s == null) {
            return false;
        }
        i = 0;
        l = s.length();
        if (l != 0) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            c = s.charAt(i);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++i;
lbl11:
            // 2 sources

            ** while (i < l)
        }
lbl12:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isNonInteger(String s) {
        if (s == null) {
            return true;
        }
        i = 0;
        l = s.length();
        if (l != 0) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            c = s.charAt(i);
            if (c <= '/' || c >= ':') {
                return true;
            }
            ++i;
lbl11:
            // 2 sources

            ** while (i < l)
        }
lbl12:
        // 1 sources

        return false;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNull(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNull(List<?> l, int i) {
        return l == null || l.isEmpty() || l.size() <= i || l.get(i) == null;
    }

    public static boolean isNonNull(Object o) {
        return o != null;
    }

    public static boolean isNonNull(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNonNull(List<?> l, int i) {
        return l != null && !l.isEmpty() && l.size() > i && l.get(i) != null;
    }

    public static boolean isMemberName(String s) {
        return s != null && s.matches(REGEX_MBR);
    }

    public static boolean isNonMemberName(String s) {
        return s == null || !s.matches(REGEX_MBR);
    }

    public static boolean isTrue(String s) {
        return s != null && (s.equalsIgnoreCase(TRUE) || s.equalsIgnoreCase(YES) || s.equals(ONE));
    }

    public static boolean isFalse(String s) {
        return s != null && (s.equalsIgnoreCase(FALSE) || s.equalsIgnoreCase(NO) || s.equals(ZERO));
    }

    public static boolean isOneZero(String s) {
        return s != null && (s.equals(ONE) || s.equals(ZERO));
    }

    public static boolean isYesNo(String s) {
        return s != null && (s.equalsIgnoreCase(YES) || s.equalsIgnoreCase(NO));
    }

    public static boolean isTrueFalse(String s) {
        return s != null && (s.equalsIgnoreCase(TRUE) || s.equalsIgnoreCase(FALSE));
    }

    public static boolean isTrueFalseEmpty(String s) {
        return s != null && (s.equalsIgnoreCase(TRUE) || s.equalsIgnoreCase(FALSE) || s.equalsIgnoreCase(EMPTY));
    }

    public static boolean isTrueFalseIsh(String s) {
        return s != null && (t.contains(s.toLowerCase()) || f.contains(s.toLowerCase()));
    }

    public static boolean isTrueFalseEmptyIsh(String s) {
        return s != null && (t.contains(s.toLowerCase()) || f.contains(s.toLowerCase()) || s.equalsIgnoreCase(EMPTY));
    }

    public static boolean isUUID(String s) {
        if (s.length() != 23) {
            return false;
        }
        if (!s.startsWith(UUID_STARTS)) {
            return false;
        }
        return s.matches(UUID_REGEXP);
    }

    public static String toNonNull(Boolean b) {
        return b != null ? b.toString() : "null";
    }

    public static String toNonNull(Integer i) {
        return i != null ? i.toString() : "null";
    }

    public static String toNonNull(Integer i, String d) {
        return i != null ? i.toString() : d;
    }

    public static String toNonNull(String s) {
        return s != null ? s : EMPTY;
    }

    public static String toNonNull(String s, String d) {
        return s != null ? s : d;
    }

    public static Boolean toBoolean(String s) {
        return (Boolean)(s == null ? s : Boolean.valueOf(Verification.isTrue(s)));
    }

    public static Boolean toBooleanTrueFalse(String s) {
        if (s != null && t.contains(s.toLowerCase())) {
            return true;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return false;
        }
        return false;
    }

    public static Boolean toBooleanTrueFalse(String s, Boolean d) {
        if (s != null && t.contains(s.toLowerCase())) {
            return true;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return false;
        }
        return d;
    }

    public static Integer toInteger(String s) {
        return s == null || !Verification.isInteger(s) ? null : Integer.valueOf(s);
    }

    public static String toOneZero(boolean b) {
        if (b) {
            return ONE;
        }
        return ZERO;
    }

    public static String toOneZero(String s) {
        if (s != null && t.contains(s.toLowerCase())) {
            return ONE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return ZERO;
        }
        return s != null ? ZERO : null;
    }

    public static String toOneZero(String s, Boolean d) {
        if (s != null && t.contains(s.toLowerCase())) {
            return ONE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return ZERO;
        }
        return d != false ? ONE : ZERO;
    }

    public static String toYesNo(String s) {
        if (s != null && t.contains(s.toLowerCase())) {
            return YES;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return NO;
        }
        return s != null ? NO : null;
    }

    public static String toYesNo(String s, Boolean d) {
        if (s != null && t.contains(s.toLowerCase())) {
            return YES;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return NO;
        }
        return d != false ? YES : NO;
    }

    public static String toTrueFalse(String s) {
        if (s != null && t.contains(s.toLowerCase())) {
            return TRUE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return FALSE;
        }
        return s != null ? FALSE : null;
    }

    public static String toTrueFalse(String s, Boolean d) {
        if (s != null && t.contains(s.toLowerCase())) {
            return TRUE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return FALSE;
        }
        return d != false ? TRUE : FALSE;
    }

    public static String toTrueFalse(Boolean b) {
        if (b != null && b.booleanValue()) {
            return TRUE;
        }
        if (b != null && !b.booleanValue()) {
            return FALSE;
        }
        return b != null ? FALSE : null;
    }

    public static String toTrueFalse(Boolean b, Boolean d) {
        if (b != null && b.booleanValue()) {
            return TRUE;
        }
        if (b != null && !b.booleanValue()) {
            return FALSE;
        }
        return d != false ? TRUE : FALSE;
    }

    public static Boolean toStrictBooleanTrueFalse(String s) throws Exception {
        if (s != null && t.contains(s.toLowerCase())) {
            return true;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return false;
        }
        throw new Exception(Messages.VER_EXCEPTION_toStrictBooleanTrueFalse);
    }

    public static String toStrictOneZero(String s) throws Exception {
        if (s != null && t.contains(s.toLowerCase())) {
            return ONE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return ZERO;
        }
        throw new Exception(Messages.VER_EXCEPTION_toStrictOneZero);
    }

    public static String toStrictYesNo(String s) throws Exception {
        if (s != null && t.contains(s.toLowerCase())) {
            return YES;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return NO;
        }
        throw new Exception(Messages.VER_EXCEPTION_toStrictYesNo);
    }

    public static String toStrictTrueFalse(String s) throws Exception {
        if (s != null && t.contains(s.toLowerCase())) {
            return TRUE;
        }
        if (s != null && f.contains(s.toLowerCase())) {
            return FALSE;
        }
        throw new Exception(Messages.VER_EXCEPTION_toStrictTrueFalse);
    }

    public static String toStrictTrueFalse(Boolean b) throws Exception {
        if (b != null && b.booleanValue()) {
            return TRUE;
        }
        if (b != null && !b.booleanValue()) {
            return FALSE;
        }
        throw new Exception(Messages.VER_EXCEPTION_toStrictTrueFalse);
    }
}

