/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.util;

import java.util.List;

public class StringUtil {
    public static final char[] HexArray = "0123456789ABCDEF".toCharArray();

    public static String copies(char c, int n) {
        StringBuilder r = new StringBuilder(Math.max(n, 0));
        int i = 0;
        while (i < n) {
            r.append(c);
            ++i;
        }
        return r.toString();
    }

    public static String copies(String s, int n) {
        StringBuilder r = new StringBuilder(Math.max(n, 0));
        int i = 0;
        while (i < n) {
            r.append(s);
            ++i;
        }
        return r.toString();
    }

    public static String right(String s, int l) {
        return StringUtil.right(s, l, null);
    }

    public static String right(String s, int l, String p) {
        String pad = p == null ? " " : p;
        String right = s.substring(Math.max(0, s.length() - l));
        if (right.length() < l) {
            StringBuilder r = new StringBuilder(Math.max(l, 0));
            int i = 0;
            while (i < l - right.length()) {
                r.append(pad);
                ++i;
            }
            r.append(right);
            right = r.toString();
        }
        return right;
    }

    public static String space(String s) {
        return s.replaceAll("\\s+", " ").trim();
    }

    public static String space(String s, String p) {
        return s.replaceAll("\\s+", p).trim();
    }

    public static String strip(String s) {
        return StringUtil.stripLeading(StringUtil.stripTrailing(s));
    }

    public static String strip(String s, String c) {
        return StringUtil.stripBoth(s, c);
    }

    public static String stripBoth(String s) {
        return StringUtil.stripLeading(StringUtil.stripTrailing(s));
    }

    public static String stripBoth(String s, String c) {
        return StringUtil.stripLeading(StringUtil.stripTrailing(s, c), c);
    }

    public static String stripLeading(String s) {
        return s.replaceFirst("^\\s+", "");
    }

    public static String stripLeading(String s, String c) {
        return s.replaceFirst("^" + c + "+", "");
    }

    public static String stripTrailing(String s) {
        return s.replaceFirst("\\s+$", "");
    }

    public static String stripTrailing(String s, String c) {
        return s.replaceFirst(String.valueOf(c) + "+" + "$", "");
    }

    public static String toCsv(List<String> l) {
        return (String)(l == null ? l : l.toString().replace("[", "").replace("]", "").replaceAll("\\s+", ""));
    }

    public static String toCondensed(String s) {
        return s.replaceAll("\\s+", "");
    }

    public static String toHex(String s) {
        byte[] bytes = s.getBytes();
        char[] hexChars = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            int j = bytes[i] & 0xFF;
            hexChars[i * 2] = HexArray[j >>> 4];
            hexChars[i * 2 + 1] = HexArray[j & 0xF];
            ++i;
        }
        return new String(hexChars);
    }

    public static String toLower(String s) {
        return s == null ? s : s.toLowerCase();
    }

    public static String toProperty(String name) {
        return String.format("${%s}", name);
    }

    public static String toSeparateLines(String s, int l, int o) {
        StringBuilder sb = new StringBuilder();
        while (s.length() > l) {
            int i = s.indexOf(",", l - o);
            if (i != -1 && i < l + o) {
                sb.append(s.substring(0, i + 1));
                sb.append(System.lineSeparator());
                s = s.substring(Math.min(i + 1, s.length()));
                continue;
            }
            i = s.indexOf(",", l - o * 2);
            if (i == -1 || i >= l + o * 2) break;
            sb.append(s.substring(0, i + 1));
            sb.append(System.lineSeparator());
            s = s.substring(Math.min(i + 1, s.length()));
        }
        sb.append(s);
        return sb.toString();
    }

    public static String toString(String s) {
        return StringUtil.toString(s, "null");
    }

    public static String toString(String s, String d) {
        return s == null ? d : s;
    }

    public static String toTitle(String s) {
        return s == null ? s : StringUtil._toTitle(s.toLowerCase());
    }

    private static String _toTitle(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean tc = true;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (Character.isSpaceChar(c.charValue())) {
                tc = true;
            } else if (tc) {
                tc = false;
                c = Character.valueOf(Character.toUpperCase(c.charValue()));
            }
            sb.append(c);
            ++n2;
        }
        return sb.toString();
    }

    public static String toUncondensed(String s) {
        return s.replace(",", ", ");
    }

    public static String toUpper(String s) {
        return s == null ? s : s.toUpperCase();
    }

    public static String valueOf(String o) {
        return o == null ? "" : o;
    }
}

