/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.util;

import com.ibm.team.build.extensions.common.ExtendedArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringParser {
    public static final String className = StringParser.class.getSimpleName();
    private static final String STRING_EMPTY = "";
    private static final String STRING_PAREN_C = ")";
    private static final String STRING_PAREN_O = "(";

    private StringParser() {
    }

    public static Map<String, ExtendedArrayList<String>> convertToExtended(Map<String, List<String>> m) {
        HashMap<String, ExtendedArrayList<String>> result = new HashMap<String, ExtendedArrayList<String>>();
        for (String key : m.keySet()) {
            result.put(key, new ExtendedArrayList(m.get(key)));
        }
        return result;
    }

    public static String getPropertyName(String s) {
        String result = s;
        Pattern p = Pattern.compile("\\$\\{(.*)}");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            result = m.group(1);
        }
        return result;
    }

    public static String parseArgument(String s) {
        String result = null;
        Pattern p = Pattern.compile(".*?[(](.*?)[)]");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            result = m.group(1);
        }
        return result;
    }

    public static List<String> parseArguments(String s) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p1 = Pattern.compile("(.*?)([,(])");
        Pattern p2 = Pattern.compile("(.*?)([)])[,]?");
        Matcher m1 = p1.matcher(s);
        int i = 0;
        while (m1.find(i)) {
            i = m1.end();
            String arg = m1.group(1).trim();
            if (m1.groupCount() == 2 && m1.group(2).equals(STRING_PAREN_O)) {
                Matcher m2 = p2.matcher(s.substring(m1.end()));
                if (m2.find()) {
                    i += m2.end();
                    arg = String.valueOf(arg) + STRING_PAREN_O + m2.group(1) + STRING_PAREN_C;
                } else {
                    i = s.length();
                    arg = String.valueOf(arg) + STRING_PAREN_O + s.substring(m1.end());
                }
            }
            result.add(arg);
        }
        if (!s.substring(i).trim().equals(STRING_EMPTY)) {
            result.add(s.substring(i).trim());
        }
        return result;
    }

    public static Map<String, List<String>> parseArgumentsAndOptions(String s) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Pattern p1 = Pattern.compile("(.*?)([,(])");
        Pattern p2 = Pattern.compile("(.*?)([)])[,]?");
        Matcher m1 = p1.matcher(s);
        int i = 0;
        while (m1.find(i)) {
            i = m1.end();
            String key = m1.group(1).trim();
            List<String> value = null;
            if (m1.groupCount() == 2 && m1.group(2).equals(STRING_PAREN_O)) {
                Matcher m2 = p2.matcher(s.substring(m1.end()));
                if (m2.find()) {
                    i += m2.end();
                    value = Arrays.asList(m2.group(1).replaceAll("\\s+", STRING_EMPTY).split(","));
                } else {
                    i = s.length();
                    value = new ArrayList<String>();
                    value.add(s.substring(m1.end()));
                }
            }
            result.put(key, value);
        }
        if (!s.substring(i).trim().equals(STRING_EMPTY)) {
            result.put(s.substring(i).trim(), null);
        }
        return result;
    }
}

