/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.StatisticsBlock;

public class StatisticsCounter {
    public static final String Data_Average = "Average:  ";
    public static final String Data_Count = "Count:    ";
    public static final String Data_CpuTime = "CpuTime:  ";
    public static final String Data_Elapsed = "Elapsed:  ";
    public static final String Data_Maximum = "Maximum:  ";
    public static final String Data_Minimum = "Minimum:  ";
    public static final String Header_Results = "Results:";
    public static final String Section_CpuTime = "CpuTime:";
    public static final String Section_Elapsed = "Elapsed:";
    public static final String Section_Overall = "Overall:";
    public int cnt = 0;
    public long elapsed = 0L;
    public long cputime = 0L;
    public long avg = 0L;
    public long min = Long.MAX_VALUE;
    public long max = Long.MIN_VALUE;
    public long cpuAvg = 0L;
    public long cpuMin = Long.MAX_VALUE;
    public long cpuMax = Long.MIN_VALUE;
    public String label = null;

    public synchronized void init(StatisticsBlock block) {
        this.label = block.getLabel();
    }

    public synchronized void mark(StatisticsBlock block) {
        long current = block.timingLeave - block.timingEnter;
        long cpucrnt = block.cpuTimeLeave - block.cpuTimeEnter;
        ++this.cnt;
        this.elapsed += current;
        this.cputime += cpucrnt;
        this.avg = this.elapsed / (long)this.cnt;
        this.min = Math.min(this.min, current);
        this.max = Math.max(this.max, current);
        this.cpuAvg = this.cputime / (long)this.cnt;
        this.cpuMin = Math.min(this.cpuMin, cpucrnt);
        this.cpuMax = Math.max(this.cpuMax, cpucrnt);
    }

    public synchronized void reset(StatisticsBlock block) {
        this.cnt = 0;
        this.elapsed = 0L;
        this.cputime = 0L;
        this.avg = 0L;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.cpuAvg = 0L;
        this.cpuMin = Long.MAX_VALUE;
        this.cpuMax = Long.MIN_VALUE;
        this.label = block.getLabel();
    }

    public int getCnt() {
        return this.cnt;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public long getCputime() {
        return this.cputime;
    }

    public long getAvg() {
        return this.avg;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getCpuAvg() {
        return this.cpuAvg;
    }

    public long getCpuMin() {
        return this.cpuMin;
    }

    public long getCpuMax() {
        return this.cpuMax;
    }

    public String getLabel() {
        return this.label;
    }
}

