/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.util.ArrayList;
import java.util.List;

public class StatisticsBlock {
    public IDebugger dbg;
    public boolean intervalsSet = false;
    public long timingEnter = 0L;
    public long timingLeave = 0L;
    public long cpuTimeEnter = 0L;
    public long cpuTimeLeave = 0L;
    public long intervalCpuTime = 0L;
    public long intervalCurrent = 0L;
    public String simpleName = null;
    public String methodName = null;
    public String blockLabel = null;
    public List<Interval> intervals;

    public StatisticsBlock(IDebugger dbg) {
        this.dbg = dbg;
    }

    public IDebugger getDbg() {
        return this.dbg;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.simpleName != null) {
            sb.append(this.simpleName);
            if (this.methodName != null) {
                sb.append(".");
                sb.append(this.methodName);
            }
        }
        if (this.blockLabel != null) {
            sb.append("[");
            sb.append(this.blockLabel);
            sb.append("]");
        }
        return sb.toString();
    }

    public long getTimingEnter() {
        return this.timingEnter;
    }

    public void setTimingEnter(long timingEnter) {
        this.timingEnter = timingEnter;
    }

    public long getTimingLeave() {
        return this.timingLeave;
    }

    public void setTimingLeave(long timingLeave) {
        this.timingLeave = timingLeave;
    }

    public long getCpuTimeEnter() {
        return this.cpuTimeEnter;
    }

    public void setCpuTimeEnter(long cpuTimeEnter) {
        this.cpuTimeEnter = cpuTimeEnter;
    }

    public long getCpuTimeLeave() {
        return this.cpuTimeLeave;
    }

    public void setCpuTimeLeave(long cpuTimeLeave) {
        this.cpuTimeLeave = cpuTimeLeave;
    }

    public long getIntervalCpuTime() {
        return this.intervalCpuTime;
    }

    public void setIntervalCpuTime(long intervalCpuTime) {
        this.intervalCpuTime = intervalCpuTime;
    }

    public long getIntervalCurrent() {
        return this.intervalCurrent;
    }

    public void setIntervalCurrent(long intervalCurrent) {
        this.intervalCurrent = intervalCurrent;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getBlockLabel() {
        return this.blockLabel;
    }

    public void setBlockLabel(String blockLabel) {
        this.blockLabel = blockLabel;
    }

    public List<Interval> getIntervals() {
        if (this.intervals == null) {
            this.intervals = new ArrayList<Interval>();
            this.intervalsSet = true;
        }
        return this.intervals;
    }

    public Interval getInterval() {
        return new Interval();
    }

    public boolean isIntervalsSet() {
        return this.intervalsSet;
    }

    class Interval {
        public long timingEnter = 0L;
        public long timingLeave = 0L;
        public long cpuTimeEnter = 0L;
        public long cpuTimeLeave = 0L;
        public String label;

        Interval() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public long getTimingEnter() {
            return this.timingEnter;
        }

        public void setTimingEnter(long timingEnter) {
            this.timingEnter = timingEnter;
        }

        public long getTimingLeave() {
            return this.timingLeave;
        }

        public void setTimingLeave(long timingLeave) {
            this.timingLeave = timingLeave;
        }

        public long getCpuTimeEnter() {
            return this.cpuTimeEnter;
        }

        public void setCpuTimeEnter(long cpuTimeEnter) {
            this.cpuTimeEnter = cpuTimeEnter;
        }

        public long getCpuTimeLeave() {
            return this.cpuTimeLeave;
        }

        public void setCpuTimeLeave(long cpuTimeLeave) {
            this.cpuTimeLeave = cpuTimeLeave;
        }
    }
}

