/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugInstance;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.StatisticsBlock;
import com.ibm.team.build.extensions.common.debug.StatisticsCounter;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.repository.common.util.NLS;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.Date;

public class Statistics {
    public static final String CTR_LABEL = "Count: ";
    public static final String CTR_FORMAT = "#0.000000s";
    public static final String TMR_FORMAT = "#0.000000s";
    public static final String TMR_LABEL = "Timer: ";
    public static final String TMR_LABEL_SUBSET = "Timer:   ";

    public static final long cpuTime() {
        ThreadMXBean mxbean = ManagementFactory.getThreadMXBean();
        long threadId = Thread.currentThread().getId();
        long result = 0L;
        if (mxbean.isThreadCpuTimeSupported()) {
            result = mxbean.getThreadCpuTime(threadId);
        }
        return result;
    }

    public static final long currentTime() {
        return System.nanoTime();
    }

    public static final String getInit() {
        return Common.COMMON_TIMING_SIMPLE_INIT;
    }

    public static final String getInit(String token) {
        return token == null ? Common.COMMON_TIMING_SHARED_INIT : NLS.bind((String)Common.COMMON_TIMING_EXTEND_INIT, (Object)token, (Object[])new Object[0]);
    }

    public static final String getStep(String text) {
        return NLS.bind((String)Common.COMMON_TIMING_SIMPLE_STEP, (Object)text, (Object[])new Object[0]);
    }

    public static final String getStep(String token, String text) {
        return token == null ? NLS.bind((String)Common.COMMON_TIMING_SHARED_STEP, (Object)text, (Object[])new Object[0]) : NLS.bind((String)Common.COMMON_TIMING_EXTEND_STEP, (Object)token, (Object[])new Object[]{text});
    }

    public static final String getTerm() {
        return Common.COMMON_TIMING_SIMPLE_TERM;
    }

    public static final String getTerm(String token) {
        return token == null ? Common.COMMON_TIMING_SHARED_TERM : NLS.bind((String)Common.COMMON_TIMING_EXTEND_TERM, (Object)token, (Object[])new Object[0]);
    }

    public static final StatisticsBlock getBlock(IDebugger dbg, String sName, String mName, String label) {
        return new StatisticsBlock(dbg, sName, mName, label){
            {
                this.timingEnter = Statistics.currentTime();
                this.cpuTimeEnter = Statistics.cpuTime();
                this.simpleName = string;
                this.methodName = string2;
                this.blockLabel = string3;
            }
        };
    }

    public static final StatisticsBlock getTime(IDebugger dbg) {
        return dbg.isTimerOn() ? new StatisticsBlock(dbg){
            {
                this.timingEnter = Statistics.currentTime();
                this.cpuTimeEnter = Statistics.cpuTime();
            }
        } : null;
    }

    public static final StatisticsBlock getTime(IDebugger dbg, String label) {
        return dbg.isTimerOn() ? new StatisticsBlock(dbg, label){
            {
                this.timingEnter = Statistics.currentTime();
                this.cpuTimeEnter = Statistics.cpuTime();
                this.blockLabel = string;
            }
        } : null;
    }

    public static final StatisticsBlock getTime(IDebugger dbg, String sName, String label) {
        return dbg.isTimerOn() ? new StatisticsBlock(dbg, sName, label){
            {
                this.timingEnter = Statistics.currentTime();
                this.cpuTimeEnter = Statistics.cpuTime();
                this.simpleName = string;
                this.blockLabel = string2;
            }
        } : null;
    }

    public static final StatisticsBlock getTime(IDebugger dbg, String sName, String mName, String label) {
        return dbg.isTimerOn() ? new StatisticsBlock(dbg, sName, mName, label){
            {
                this.timingEnter = Statistics.currentTime();
                this.cpuTimeEnter = Statistics.cpuTime();
                this.simpleName = string;
                this.methodName = string2;
                this.blockLabel = string3;
            }
        } : null;
    }

    public static final StatisticsBlock getTime(IDebugger dbg, String sName, String mName, String label, boolean counter) {
        StatisticsBlock block = Statistics.getTime(dbg, sName, mName, label);
        if (block != null && counter) {
            DebugInstance instance = DebugInstance.getInstance();
            String blockLabel = block.getLabel();
            if (!instance.getCounters().containsKey(blockLabel)) {
                instance.getCounters().put(blockLabel, new StatisticsCounter());
            }
            StatisticsCounter statisticsCounter = instance.getCounters().get(blockLabel);
            statisticsCounter.init(block);
        }
        return block;
    }

    public static final void logCounter(StatisticsBlock block) {
        StatisticsCounter statisticsCounter;
        if (block.getDbg().isTimerOn() && (statisticsCounter = DebugInstance.getInstance().getCounters().get(block.getLabel())) != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(Statistics.formatBlank(block, block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Overall:", block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Count:    ", statisticsCounter.getCnt(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Elapsed:  ", statisticsCounter.getElapsed(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "CpuTime:  ", statisticsCounter.getCputime(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatBlank(block, block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Elapsed:", block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Average:  ", statisticsCounter.getAvg(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Maximum:  ", statisticsCounter.getMax(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Minimum:  ", statisticsCounter.getMin(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatBlank(block, block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "CpuTime:", block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Average:  ", statisticsCounter.getCpuAvg(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Maximum:  ", statisticsCounter.getCpuMax(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatCounter(block, "Minimum:  ", statisticsCounter.getCpuMin(), block.getDbg()));
            sb.append("\n");
            sb.append(Statistics.formatBlank(block, block.getDbg()));
            block.getDbg().log(sb.toString());
        }
    }

    public static final void logTiming(StatisticsBlock block) {
        if (block.cpuTimeLeave == 0L) {
            block.setCpuTimeLeave(Statistics.cpuTime());
        }
        if (block.timingLeave == 0L) {
            block.setTimingLeave(Statistics.currentTime());
        }
        if (block.getDbg().isTimerOn()) {
            block.getDbg().log(Statistics.formatTiming(block, block.getDbg()));
            if (block.intervalsSet) {
                for (StatisticsBlock.Interval interval : block.getIntervals()) {
                    block.getDbg().log(Statistics.formatTimingInterval(block, interval, block.getDbg()));
                }
            }
        }
    }

    public static final void logTiming(StatisticsBlock block, boolean counter) {
        Statistics.logTiming(block);
        if (counter) {
            Statistics.setCounter(block);
        }
    }

    public static final void logTiming(StatisticsBlock block, String label) {
        block.setBlockLabel(label);
        Statistics.logTiming(block);
    }

    public static final void logTiming(String label, boolean verbose, IDebugger dbg) {
        if (verbose) {
            dbg.log(Statistics.formatTiming(label, dbg));
        }
    }

    public static final void logTiming(String label, boolean verbose, long sta, long end, IDebugger dbg) {
        if (verbose) {
            dbg.log(Statistics.formatTiming(label, sta, end, dbg));
        }
    }

    public static final void logTiming(String label, boolean verbose, long sta, long end, long staCpu, long endCpu, IDebugger dbg) {
        if (verbose) {
            dbg.log(Statistics.formatTiming(label, sta, end, staCpu, endCpu, dbg));
        }
    }

    public static final void logTiming(String label, IDebugger dbg) {
        if (dbg.isTimerOn()) {
            dbg.log(Statistics.formatTiming(label, dbg));
        }
    }

    public static final void logTiming(String label, long sta, long end, IDebugger dbg) {
        if (dbg.isTimerOn()) {
            dbg.log(Statistics.formatTiming(label, sta, end, dbg));
        }
    }

    public static final void logTiming(String label, long sta, long end, long staCpu, long endCpu, IDebugger dbg) {
        if (dbg.isTimerOn()) {
            dbg.log(Statistics.formatTiming(label, sta, end, staCpu, endCpu, dbg));
        }
    }

    public static final void logTimingSubset(String label, IDebugger dbg) {
        if (dbg.isTimerOn()) {
            dbg.log(Statistics.formatTimingSubset(label, dbg));
        }
    }

    public static final void logTimingSubset(String label, boolean verbose, IDebugger dbg) {
        if (verbose) {
            dbg.log(Statistics.formatTimingSubset(label, dbg));
        }
    }

    public static final void setInterval(StatisticsBlock block, String label) {
        long cpuTime = Statistics.cpuTime();
        long current = Statistics.currentTime();
        StatisticsBlock.Interval interval = block.getInterval();
        interval.setLabel(label);
        interval.setCpuTimeEnter(block.getIntervalCpuTime() == 0L ? block.getCpuTimeEnter() : block.getIntervalCpuTime());
        interval.setCpuTimeLeave(cpuTime);
        interval.setTimingEnter(block.getIntervalCurrent() == 0L ? block.getTimingEnter() : block.getIntervalCurrent());
        interval.setTimingLeave(current);
        block.setIntervalCpuTime(cpuTime);
        block.setIntervalCurrent(current);
        block.getIntervals().add(interval);
    }

    public static final void setTime(StatisticsBlock block) {
        block.cpuTimeLeave = Statistics.cpuTime();
        block.timingLeave = Statistics.currentTime();
    }

    public static final void setTime(StatisticsBlock block, boolean counter) {
        Statistics.setTime(block);
        if (counter) {
            Statistics.setCounter(block);
        }
    }

    private static final void setCounter(StatisticsBlock block) {
        StatisticsCounter statisticsCounter = DebugInstance.getInstance().getCounters().get(block.getLabel());
        if (statisticsCounter != null) {
            statisticsCounter.mark(block);
        }
    }

    private static String addThreadId(boolean id) {
        return id ? String.format("[%d] ", Thread.currentThread().getId()) : "";
    }

    private static String addTimeStamp(boolean ts) {
        return ts ? Debug.SDF.format(new Date()) : "";
    }

    private static String addBlockLabel(StatisticsBlock block) {
        return block.getLabel();
    }

    private static String formatBlank(StatisticsBlock block, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + CTR_LABEL + Statistics.addBlockLabel(block);
    }

    private static String formatCounter(StatisticsBlock block, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + CTR_LABEL + Statistics.addBlockLabel(block) + " " + "Results:";
    }

    private static String formatCounter(StatisticsBlock block, String label, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + CTR_LABEL + Statistics.addBlockLabel(block) + "    " + label;
    }

    private static String formatCounter(StatisticsBlock block, String label, long data, IDebugger dbg) {
        double value = Double.valueOf(data) / 1.0E9;
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + CTR_LABEL + Statistics.addBlockLabel(block) + "    " + " " + " " + label + "    " + new DecimalFormat("#0.000000s").format(value);
    }

    private static String formatCounter(StatisticsBlock block, String label, int data, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + CTR_LABEL + Statistics.addBlockLabel(block) + "    " + " " + " " + label + "    " + Integer.toString(data);
    }

    private static String formatTiming(StatisticsBlock block, IDebugger dbg) {
        double elapsed = ((double)block.timingLeave - (double)block.timingEnter) / 1.0E9;
        double cputime = ((double)block.cpuTimeLeave - (double)block.cpuTimeEnter) / 1.0E9;
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL + Statistics.addBlockLabel(block) + " " + "[" + new DecimalFormat("#0.000000s").format(elapsed) + "]" + "[" + new DecimalFormat("#0.000000s").format(cputime) + "]";
    }

    private static String formatTiming(String label, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL + label;
    }

    private static String formatTiming(String label, long sta, long end, IDebugger dbg) {
        double duration = ((double)end - (double)sta) / 1.0E9;
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL + label + " " + "[" + new DecimalFormat("#0.000000s").format(duration) + "]";
    }

    private static String formatTiming(String label, long sta, long end, long staCpu, long endCpu, IDebugger dbg) {
        double duration = ((double)end - (double)sta) / 1.0E9;
        double cputime = ((double)endCpu - (double)staCpu) / 1.0E9;
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL + label + " " + "[" + new DecimalFormat("#0.000000s").format(duration) + "]" + "[" + new DecimalFormat("#0.000000s").format(cputime) + "]";
    }

    private static String formatTimingSubset(String label, IDebugger dbg) {
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL_SUBSET + label;
    }

    private static String formatTimingInterval(StatisticsBlock block, StatisticsBlock.Interval interval, IDebugger dbg) {
        double elapsed = ((double)interval.timingLeave - (double)interval.timingEnter) / 1.0E9;
        double cputime = ((double)interval.cpuTimeLeave - (double)interval.cpuTimeEnter) / 1.0E9;
        return String.valueOf(Statistics.addThreadId(dbg.isMulti())) + Statistics.addTimeStamp(dbg.isTimer()) + TMR_LABEL_SUBSET + interval.label + " " + "[" + new DecimalFormat("#0.000000s").format(elapsed) + "]" + "[" + new DecimalFormat("#0.000000s").format(cputime) + "]";
    }
}

