/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Statistics;
import com.ibm.team.build.extensions.common.debug.StatisticsBlock;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;

public class Mnm {
    private IDebugger dbg;
    private Method method;
    private boolean init = false;
    private String cls;
    private String mnm;
    private String[] names;

    public final String get() {
        if (this.mnm != null) {
            return this.mnm;
        }
        this.method = this.getClass().getEnclosingMethod();
        return this.method == null ? "unknown" : this.method.getName();
    }

    public final Mnm put(IDebugger dbg, String cls) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        return this;
    }

    public final IDebugger getDbg() {
        return this.dbg;
    }

    public final void fatal(String ... args) {
        if (this.init && this.dbg.isFatal()) {
            Debug.fatal(this.dbg, this.concat(args));
        }
    }

    public final void fatal(Throwable t, String ... args) {
        if (this.init && this.dbg.isFatal()) {
            Debug.fatal(this.dbg, t, this.concat(args));
        }
    }

    public final void error(String ... args) {
        if (this.init && this.dbg.isError()) {
            Debug.error(this.dbg, this.concat(args));
        }
    }

    public final void error(Throwable t, String ... args) {
        if (this.init && this.dbg.isError()) {
            Debug.error(this.dbg, t, this.concat(args));
        }
    }

    public final void warn(String ... args) {
        if (this.init && this.dbg.isWarn()) {
            Debug.warn(this.dbg, this.concat(args));
        }
    }

    public final void warn(Throwable t, String ... args) {
        if (this.init && this.dbg.isWarn()) {
            Debug.warn(this.dbg, t, this.concat(args));
        }
    }

    public final void info(String ... args) {
        if (this.init && this.dbg.isInfo()) {
            Debug.info(this.dbg, this.concat(args));
        }
    }

    public final void info(Throwable t, String ... args) {
        if (this.init && this.dbg.isInfo()) {
            Debug.info(this.dbg, t, this.concat(args));
        }
    }

    public final void debug(String ... args) {
        if (this.init && this.dbg.isDebug()) {
            Debug.debug(this.dbg, this.concat(args));
        }
    }

    public final void trace(String ... args) {
        if (this.init && this.dbg.isTrace()) {
            Debug.trace(this.dbg, this.concat(args));
        }
    }

    public final void items(String ... args) {
        if (this.init && this.dbg.isItems()) {
            Debug.items(this.dbg, this.concat(args));
        }
    }

    public final void fatal(Object ... args) {
        if (this.init && this.dbg.isFatal()) {
            Debug.fatal(this.dbg, this.concat(args));
        }
    }

    public final void fatal(Throwable t, Object ... args) {
        if (this.init && this.dbg.isFatal()) {
            Debug.fatal(this.dbg, t, this.concat(args));
        }
    }

    public final void error(Object ... args) {
        if (this.init && this.dbg.isError()) {
            Debug.error(this.dbg, this.concat(args));
        }
    }

    public final void error(Throwable t, Object ... args) {
        if (this.init && this.dbg.isError()) {
            Debug.error(this.dbg, t, this.concat(args));
        }
    }

    public final void warn(Object ... args) {
        if (this.init && this.dbg.isWarn()) {
            Debug.warn(this.dbg, this.concat(args));
        }
    }

    public final void warn(Throwable t, Object ... args) {
        if (this.init && this.dbg.isWarn()) {
            Debug.warn(this.dbg, t, this.concat(args));
        }
    }

    public final void info(Object ... args) {
        if (this.init && this.dbg.isInfo()) {
            Debug.info(this.dbg, this.concat(args));
        }
    }

    public final void info(Throwable t, Object ... args) {
        if (this.init && this.dbg.isInfo()) {
            Debug.info(this.dbg, t, this.concat(args));
        }
    }

    public final void debug(Object ... args) {
        if (this.init && this.dbg.isDebug()) {
            Debug.debug(this.dbg, this.concat(args));
        }
    }

    public final void trace(Object ... args) {
        if (this.init && this.dbg.isTrace()) {
            Debug.trace(this.dbg, this.concat(args));
        }
    }

    public final void items(Object ... args) {
        if (this.init && this.dbg.isItems()) {
            Debug.items(this.dbg, this.concat(args));
        }
    }

    public final Mnm setup(IDebugger dbg, String cls, String ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.setup(dbg, this.concat(args));
        }
        return this;
    }

    public final void setup(String ... args) {
        if (this.isFlow()) {
            Debug.setup(this.dbg, this.concat(args));
        }
    }

    public final Mnm enter(IDebugger dbg, String cls, String ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.enter(dbg, this.concat(args));
        }
        return this;
    }

    public final void enter(String ... args) {
        if (this.isFlow()) {
            Debug.enter(this.dbg, this.concat(args));
        }
    }

    public final void leave(String ... args) {
        if (this.isFlow()) {
            Debug.leave(this.dbg, this.concat(args));
        }
    }

    public final Mnm inout(IDebugger dbg, String cls, String ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.inout(dbg, this.concat(args));
        }
        return this;
    }

    public final void start(String ... args) {
        if (this.isFlow()) {
            Debug.start(this.dbg, this.concat(args));
        }
    }

    public final void stops(String ... args) {
        if (this.isFlow()) {
            Debug.stops(this.dbg, this.concat(args));
        }
    }

    public final void inter(String ... args) {
        if (this.isFlow()) {
            Debug.inter(this.dbg, this.concat(args));
        }
    }

    public final Mnm setup(IDebugger dbg, String cls, Object ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.setup(dbg, this.concat(args));
        }
        return this;
    }

    public final Mnm enter(IDebugger dbg, String cls, Object ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.enter(dbg, this.concat(args));
        }
        return this;
    }

    public final void leave(Object ... args) {
        if (this.isFlow()) {
            Debug.leave(this.dbg, this.concat(args));
        }
    }

    public final Mnm inout(IDebugger dbg, String cls, Object ... args) {
        if (!this.init) {
            this.init(dbg, cls);
        }
        if (this.isFlow()) {
            Debug.inout(dbg, this.concat(args));
        }
        return this;
    }

    public final void start(Object ... args) {
        if (this.isFlow()) {
            Debug.start(this.dbg, this.concat(args));
        }
    }

    public final void stops(Object ... args) {
        if (this.isFlow()) {
            Debug.stops(this.dbg, this.concat(args));
        }
    }

    public final void inter(Object ... args) {
        if (this.isFlow()) {
            Debug.inter(this.dbg, this.concat(args));
        }
    }

    public void log(String msg) {
        if (this.init) {
            this.dbg.log(Debug.format(this.dbg.getInfoLevel(), this.concat(msg)), this.dbg.getInfoLevel());
        }
    }

    public void log(Throwable t) {
        if (this.init) {
            this.dbg.log(Debug.format(this.dbg.getInfoLevel(), this.concat(t.getMessage())), this.dbg.getInfoLevel());
        }
    }

    public void log(String msg, int msgLevel) {
        if (this.init) {
            this.dbg.log(Debug.format(msgLevel, this.concat(msg)), msgLevel);
        }
    }

    public void log(Throwable t, int msgLevel) {
        if (this.init) {
            this.dbg.log(Debug.format(msgLevel, this.concat(t.getMessage())), t, msgLevel);
        }
    }

    public void log(String msg, Throwable t, int msgLevel) {
        if (this.init) {
            this.dbg.log(Debug.format(msgLevel, this.concat(msg)), t, msgLevel);
        }
    }

    public final StatisticsBlock getTime(String label) {
        return this.getTime(label, false);
    }

    public final StatisticsBlock getTime(String label, boolean counter) {
        StatisticsBlock result = null;
        if (this.isStatistics()) {
            result = Statistics.getTime(this.dbg, this.cls, this.mnm, label, counter);
        }
        return result;
    }

    public final void setTime(StatisticsBlock block) {
        this.setTime(block, false);
    }

    public final void setTime(StatisticsBlock block, boolean counter) {
        if (this.isStatistics(block)) {
            Statistics.setTime(block, counter);
        }
    }

    public final void logCounter(StatisticsBlock block) {
        if (this.isStatistics(block)) {
            Statistics.logCounter(block);
        }
    }

    public final void logTiming(StatisticsBlock block) {
        if (this.isStatistics(block)) {
            Statistics.logTiming(block, false);
        }
    }

    public final void logTiming(StatisticsBlock block, boolean counter) {
        if (this.isStatistics(block)) {
            Statistics.logTiming(block, counter);
        }
    }

    public final void setInterval(StatisticsBlock block, String label) {
        if (this.isStatistics(block)) {
            Statistics.setInterval(block, label);
        }
    }

    private final String[] concat(Object ... args) {
        if (args != null && args.length > 0) {
            String[] sargs = new String[args.length];
            int i = 0;
            while (i < args.length) {
                sargs[i] = LogString.value(args[i]);
                ++i;
            }
            return (String[])Stream.concat(Arrays.stream(this.names), Arrays.stream(sargs)).toArray(String[]::new);
        }
        return this.names;
    }

    private final String[] concat(String ... args) {
        if (args != null && args.length > 0) {
            return (String[])Stream.concat(Arrays.stream(this.names), Arrays.stream(args)).toArray(String[]::new);
        }
        return this.names;
    }

    public final void init(IDebugger dbg, String cls) {
        Assert.isNotNull((Object)dbg);
        Assert.isNotNull((Object)cls);
        this.mnm = this.get();
        this.dbg = this.method != null ? dbg.getDbg(dbg, this.method) : dbg;
        this.cls = cls;
        this.names = new String[]{cls, this.mnm};
        this.init = true;
    }

    private final boolean isFlow() {
        return this.init && this.dbg.isFlow();
    }

    private final boolean isStatistics() {
        return this.init && this.dbg.isTimerOn();
    }

    private final boolean isStatistics(StatisticsBlock block) {
        return block != null && this.init && this.dbg.isTimerOn();
    }
}

