/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugLog;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Logger;

public class LogWrapper
implements IDebugLog {
    private Log log;
    private Logger logger;

    public LogWrapper(Log log) {
        this(log, null);
    }

    public LogWrapper(Log log, IDebugClass debugClass) {
        this.logger = debugClass != null ? debugClass.getLogger() : null;
        this.log = log;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isFlowEnabled() {
        return this.logger != null ? this.logger.getLevel().isLessSpecificThan(IDebugger.LevelFlow) : this.log.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isItemsEnabled() {
        return this.logger != null ? this.logger.getLevel().isLessSpecificThan(IDebugger.LevelItems) : this.log.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log.fatal(message, t);
    }

    @Override
    public void error(Object message) {
        this.log.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log.error(message, t);
    }

    @Override
    public void warn(Object message) {
        this.log.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log.warn(message, t);
    }

    @Override
    public void info(Object message) {
        this.log.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log.info(message, t);
    }

    @Override
    public void flow(Object message) {
        if (this.logger != null) {
            this.logger.log(IDebugger.LevelFlow, message);
        } else {
            this.log.info(message);
        }
    }

    @Override
    public void flow(Object message, Throwable t) {
        if (this.logger != null) {
            this.logger.log(IDebugger.LevelFlow, message, t);
        } else {
            this.log.info(message, t);
        }
    }

    @Override
    public void debug(Object message) {
        this.log.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log.debug(message, t);
    }

    @Override
    public void trace(Object message) {
        this.log.trace(message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log.trace(message, t);
    }

    @Override
    public void items(Object message) {
        if (this.logger != null) {
            this.logger.log(IDebugger.LevelItems, message);
        } else {
            this.log.trace(message);
        }
    }

    @Override
    public void items(Object message, Throwable t) {
        if (this.logger != null) {
            this.logger.log(IDebugger.LevelItems, message, t);
        } else {
            this.log.trace(message, t);
        }
    }
}

