/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.repository.common.IHelper;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Helper;
import java.math.BigDecimal;
import java.security.Timestamp;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LogField {
    private static final String nullString = "null";
    private static final String trueString = "true";
    private static final String falseString = "false";
    private static final String FormatField = "  %1$-32s = %2$s \n";
    private static final int Class_BigDecimal = 0;
    private static final int Class_boolean = 1;
    private static final int Class_Boolean = 2;
    private static final int Class_byte = 3;
    private static final int Class_byteArray = 4;
    private static final int Class_char = 5;
    private static final int Class_charArray = 6;
    private static final int Class_Collection = 7;
    private static final int Class_Date = 8;
    private static final int Class_double = 9;
    private static final int Class_Double = 10;
    private static final int Class_Enum = 11;
    private static final int Class_float = 12;
    private static final int Class_Float = 13;
    private static final int Class_Helper = 14;
    private static final int Class_IHelper = 15;
    private static final int Class_IItem = 16;
    private static final int Class_IItemHandle = 17;
    private static final int Class_int = 18;
    private static final int Class_Integer = 19;
    private static final int Class_List = 20;
    private static final int Class_long = 21;
    private static final int Class_Long = 22;
    private static final int Class_Map = 23;
    private static final int Class_Object = 24;
    private static final int Class_ObjectArray = 25;
    private static final int Class_short = 26;
    private static final int Class_Short = 27;
    private static final int Class_String = 28;
    private static final int Class_Time = 29;
    private static final int Class_Timestamp = 30;
    private static final int Class_UUID = 31;
    static final Map<Class<?>, Integer> classMap = new HashMap<Class<?>, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(BigDecimal.class, 0);
            this.put(Boolean.TYPE, 1);
            this.put(Boolean.class, 2);
            this.put(Byte.TYPE, 3);
            this.put(byte[].class, 4);
            this.put(Character.TYPE, 5);
            this.put(char[].class, 6);
            this.put(Collection.class, 7);
            this.put(Date.class, 8);
            this.put(Double.TYPE, 9);
            this.put(Double.class, 10);
            this.put(Enum.class, 11);
            this.put(Float.TYPE, 12);
            this.put(Float.class, 13);
            this.put(Helper.class, 14);
            this.put(IHelper.class, 15);
            this.put(IItem.class, 16);
            this.put(IItemHandle.class, 17);
            this.put(Integer.TYPE, 18);
            this.put(Integer.class, 19);
            this.put(List.class, 20);
            this.put(Long.TYPE, 21);
            this.put(Long.class, 22);
            this.put(Map.class, 23);
            this.put(Object.class, 24);
            this.put(Object[].class, 25);
            this.put(Short.TYPE, 26);
            this.put(Short.class, 27);
            this.put(String.class, 28);
            this.put(Time.class, 29);
            this.put(Timestamp.class, 30);
            this.put(UUID.class, 31);
        }
    };

    public static String format(String n, Object o) {
        return String.format(FormatField, n, LogField.value(o));
    }

    public static String format(String n, Object o, boolean items) {
        StringBuffer sb = new StringBuffer();
        sb.append(LogField.format(n, o));
        if (items) {
            String s;
            if (o instanceof List) {
                for (Object object : (List)o) {
                    sb.append(String.format(FormatField, " ", LogField.value(object)));
                }
            }
            if (o instanceof Map) {
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    s = String.valueOf(LogField.value(entry.getKey())) + " - " + LogField.value(entry.getValue());
                    sb.append(String.format(FormatField, " ", s));
                }
            }
            if (o instanceof Properties) {
                for (Map.Entry entry : ((Properties)o).entrySet()) {
                    s = String.valueOf(LogField.value(entry.getKey())) + " - " + LogField.value(entry.getValue());
                    sb.append(String.format(FormatField, " ", s));
                }
            }
        }
        return sb.toString();
    }

    public static String nonNull(Object o) {
        return o == null ? falseString : trueString;
    }

    public static String value(Object o) {
        if (o != null) {
            Class<?> cls = o.getClass();
            Integer i = classMap.containsKey(cls) ? classMap.get(cls) : -1;
            if (i == -1) {
                if (List.class.isAssignableFrom(cls)) {
                    i = 20;
                } else if (Map.class.isAssignableFrom(cls)) {
                    i = 23;
                }
            }
            switch (i) {
                case 0: {
                    return LogField.valueOf((BigDecimal)o);
                }
                case 1: {
                    return LogField.valueOf((boolean)((Boolean)o));
                }
                case 2: {
                    return LogField.valueOf((Boolean)o);
                }
                case 3: {
                    return LogField.valueOf((Byte)o);
                }
                case 4: {
                    return LogField.valueOf((byte[])o);
                }
                case 5: {
                    return LogField.valueOf(((Character)o).charValue());
                }
                case 6: {
                    return LogField.valueOf((char[])o);
                }
                case 7: {
                    return LogField.valueOf((Collection)o);
                }
                case 8: {
                    return LogField.valueOf((Date)o);
                }
                case 9: {
                    return LogField.valueOf((double)((Double)o));
                }
                case 10: {
                    return LogField.valueOf((Double)o);
                }
                case 11: {
                    return LogField.valueOf((Enum)o);
                }
                case 12: {
                    return LogField.valueOf(((Float)o).floatValue());
                }
                case 13: {
                    return LogField.valueOf((Float)o);
                }
                case 14: {
                    return LogField.valueOf((Helper)o);
                }
                case 15: {
                    return LogField.valueOf((IHelper)o);
                }
                case 16: {
                    return LogField.valueOf((IItem)o);
                }
                case 17: {
                    return LogField.valueOf((IItemHandle)o);
                }
                case 18: {
                    return LogField.valueOf((int)((Integer)o));
                }
                case 19: {
                    return LogField.valueOf((Integer)o);
                }
                case 20: {
                    return LogField.valueOf((List)o);
                }
                case 21: {
                    return LogField.valueOf((long)((Long)o));
                }
                case 22: {
                    return LogField.valueOf((Long)o);
                }
                case 23: {
                    return LogField.valueOf((Map)o);
                }
                case 24: {
                    return LogField.valueOf(o);
                }
                case 25: {
                    return LogField.valueOf((Object[])o);
                }
                case 26: {
                    return LogField.valueOf((short)((Short)o));
                }
                case 27: {
                    return LogField.valueOf((Short)o);
                }
                case 28: {
                    return LogField.valueOf((String)o);
                }
                case 29: {
                    return LogField.valueOf((Time)o);
                }
                case 30: {
                    return LogField.valueOf((Timestamp)o);
                }
                case 31: {
                    return LogField.valueOf((UUID)o);
                }
            }
            return o.toString();
        }
        return nullString;
    }

    public static String valueOf(BigDecimal o) {
        return o == null ? nullString : o.toPlainString();
    }

    public static String valueOf(boolean o) {
        return o ? trueString : falseString;
    }

    public static String valueOf(Boolean o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(byte o) {
        return String.valueOf(o);
    }

    public static String valueOf(byte[] o) {
        return String.valueOf(o);
    }

    public static String valueOf(char o) {
        return String.valueOf(o);
    }

    public static String valueOf(char[] o) {
        return String.valueOf(o);
    }

    public static String valueOf(Collection<?> o) {
        return o == null ? nullString : Integer.toString(o.size());
    }

    public static String valueOf(Date o) {
        return o == null ? nullString : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(o);
    }

    public static String valueOf(double o) {
        return Double.toString(o);
    }

    public static String valueOf(Double o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(Enum o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(float o) {
        return Float.toString(o);
    }

    public static String valueOf(Float o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(Helper o) {
        return o == null ? nullString : (o.getInternalId() == null ? nullString : o.getInternalId().getUuidValue());
    }

    public static String valueOf(IHelper o) {
        return o == null ? nullString : (!(o instanceof Helper) ? nullString : LogField.valueOf((Helper)o));
    }

    public static String valueOf(IItem o) {
        return o == null ? nullString : o.getItemId().getUuidValue();
    }

    public static String valueOf(IItemHandle o) {
        return o == null ? nullString : o.getItemId().getUuidValue();
    }

    public static String valueOf(int o) {
        return Integer.toString(o);
    }

    public static String valueOf(Integer o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(List<?> o) {
        return o == null ? nullString : Integer.toString(o.size());
    }

    public static String valueOf(long o) {
        return Long.toString(o);
    }

    public static String valueOf(Long o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(Map<?, ?> o) {
        return o == null ? nullString : Integer.toString(o.size());
    }

    public static String valueOf(Object o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(Object[] o) {
        return o == null ? nullString : Integer.toString(o.length);
    }

    public static String valueOf(short o) {
        return Short.toString(o);
    }

    public static String valueOf(Short o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(String o) {
        return o == null ? nullString : o;
    }

    public static String valueOf(Time o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(Timestamp o) {
        return o == null ? nullString : o.toString();
    }

    public static String valueOf(UUID o) {
        return o == null ? nullString : o.getUuidValue();
    }
}

