/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugLogMsg;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;

public interface IDebugger {
    public static final boolean DEBUG_DEFAULT = false;
    public static final int Order_Fatal = 0;
    public static final int Order_Error = 1;
    public static final int Order_Warn = 2;
    public static final int Order_Info = 3;
    public static final int Order_Flow = 4;
    public static final int Order_Debug = 5;
    public static final int Order_Trace = 6;
    public static final int Order_Items = 7;
    public static final int Message_Off = 0;
    public static final int Message_Fatal = 100;
    public static final int Message_Error = 200;
    public static final int Message_Warn = 300;
    public static final int Message_Info = 400;
    public static final int Message_Flow = 450;
    public static final int Message_Debug = 500;
    public static final int Message_Trace = 600;
    public static final int Message_Items = 650;
    public static final int Message_All = Integer.MAX_VALUE;
    public static final int FlowType_Setup = 1;
    public static final int FlowType_Enter = 2;
    public static final int FlowType_Leave = 3;
    public static final int FlowType_InOut = 4;
    public static final int FlowType_Start = 5;
    public static final int FlowType_Stops = 6;
    public static final int FlowType_Inter = 7;
    public static final int Off_LogLevel = 0;
    public static final int Fatal_LogLevel = 100;
    public static final int Error_LogLevel = 200;
    public static final int Warn_LogLevel = 300;
    public static final int Info_LogLevel = 400;
    public static final int Flow_LogLevel = 450;
    public static final int Debug_LogLevel = 500;
    public static final int Trace_LogLevel = 600;
    public static final int Items_LogLevel = 650;
    public static final int All_LogLevel = Integer.MAX_VALUE;
    public static final String Fatal_Value = "fatal";
    public static final String Error_Value = "error";
    public static final String Warn_Value = "warn";
    public static final String Info_Value = "info";
    public static final String Flow_Value = "flow";
    public static final String Debug_Value = "debug";
    public static final String Trace_Value = "trace";
    public static final String Items_Value = "items";
    public static final String Verbs_Value = "verbose";
    public static final String Diag_Value = "diag";
    public static final String Debug_False = "false";
    public static final String Debug_True = "true";
    public static final boolean ANT_PROPERTY_DEFAULT = false;
    public static final String ANT_PROPERTY_NAME_DEBUGON = "debugOn";
    public static final String ANT_PROPERTY_NAME_TIMERON = "timerOn";
    public static final String ANT_PROPERTY_NAME_MULTI = "multi";
    public static final String ANT_PROPERTY_NAME_TIMER = "timer";
    public static final String ANT_PROPERTY_NAME_FATAL = "fatal";
    public static final String ANT_PROPERTY_NAME_ERROR = "error";
    public static final String ANT_PROPERTY_NAME_WARN = "warn";
    public static final String ANT_PROPERTY_NAME_INFO = "info";
    public static final String ANT_PROPERTY_NAME_FLOW = "flow";
    public static final String ANT_PROPERTY_NAME_DEBUG = "debug";
    public static final String ANT_PROPERTY_NAME_TRACE = "trace";
    public static final String ANT_PROPERTY_NAME_ITEMS = "items";
    public static final String EXT_PROPERTY_DEFAULT = Boolean.toString(false);
    public static final String EXT_PROPERTY_NAME_CLSPFX = "team.build.extensions.debug.class.";
    public static final String EXT_PROPERTY_NAME_GRPPFX = "team.build.extensions.debug.group.";
    public static final String EXT_PROPERTY_NAME_DEBUGON = "team.build.extensions.debugOn";
    public static final String EXT_PROPERTY_NAME_TIMERON = "team.build.extensions.timerOn";
    public static final String EXT_PROPERTY_NAME_MULTI = "team.build.extensions.multi";
    public static final String EXT_PROPERTY_NAME_TIMER = "team.build.extensions.timer";
    public static final String EXT_PROPERTY_NAME_FATAL = "team.build.extensions.fatal";
    public static final String EXT_PROPERTY_NAME_ERROR = "team.build.extensions.error";
    public static final String EXT_PROPERTY_NAME_WARN = "team.build.extensions.warn";
    public static final String EXT_PROPERTY_NAME_INFO = "team.build.extensions.info";
    public static final String EXT_PROPERTY_NAME_FLOW = "team.build.extensions.flow";
    public static final String EXT_PROPERTY_NAME_DEBUG = "team.build.extensions.debug";
    public static final String EXT_PROPERTY_NAME_TRACE = "team.build.extensions.trace";
    public static final String EXT_PROPERTY_NAME_ITEMS = "team.build.extensions.items";
    public static final String ENV_PROPERTY_DEFAULT = Boolean.toString(false);
    public static final String ENV_PROPERTY_NAME_DEBUGON = "TEAM_BUILD_EXTENSIONS_DEBUG_DEBUGON";
    public static final String ENV_PROPERTY_NAME_TIMERON = "TEAM_BUILD_EXTENSIONS_DEBUG_TIMERON";
    public static final String ENV_PROPERTY_NAME_MULTI = "TEAM_BUILD_EXTENSIONS_DEBUG_MULTI";
    public static final String ENV_PROPERTY_NAME_TIMER = "TEAM_BUILD_EXTENSIONS_DEBUG_TIMER";
    public static final String ENV_PROPERTY_NAME_FATAL = "TEAM_BUILD_EXTENSIONS_DEBUG_FATAL";
    public static final String ENV_PROPERTY_NAME_ERROR = "TEAM_BUILD_EXTENSIONS_DEBUG_ERROR";
    public static final String ENV_PROPERTY_NAME_WARN = "TEAM_BUILD_EXTENSIONS_DEBUG_WARN";
    public static final String ENV_PROPERTY_NAME_INFO = "TEAM_BUILD_EXTENSIONS_DEBUG_INFO";
    public static final String ENV_PROPERTY_NAME_FLOW = "TEAM_BUILD_EXTENSIONS_DEBUG_FLOW";
    public static final String ENV_PROPERTY_NAME_DEBUG = "TEAM_BUILD_EXTENSIONS_DEBUG_DEBUG";
    public static final String ENV_PROPERTY_NAME_TRACE = "TEAM_BUILD_EXTENSIONS_DEBUG_TRACE";
    public static final String ENV_PROPERTY_NAME_ITEMS = "TEAM_BUILD_EXTENSIONS_DEBUG_ITEMS";
    public static final String JVM_PROPERTY_DEFAULT = Boolean.toString(false);
    public static final String JVM_PROPERTY_NAME_CLSPFX = "team.build.extensions.debug.class.";
    public static final String JVM_PROPERTY_NAME_GRPPFX = "team.build.extensions.debug.group.";
    public static final String JVM_PROPERTY_NAME_DEBUGON = "team.build.extensions.debug.debugOn";
    public static final String JVM_PROPERTY_NAME_TIMERON = "team.build.extensions.debug.timerOn";
    public static final String JVM_PROPERTY_NAME_MULTI = "team.build.extensions.debug.multi";
    public static final String JVM_PROPERTY_NAME_TIMER = "team.build.extensions.debug.timer";
    public static final String JVM_PROPERTY_NAME_FATAL = "team.build.extensions.debug.fatal";
    public static final String JVM_PROPERTY_NAME_ERROR = "team.build.extensions.debug.error";
    public static final String JVM_PROPERTY_NAME_WARN = "team.build.extensions.debug.warn";
    public static final String JVM_PROPERTY_NAME_INFO = "team.build.extensions.debug.info";
    public static final String JVM_PROPERTY_NAME_FLOW = "team.build.extensions.debug.flow";
    public static final String JVM_PROPERTY_NAME_DEBUG = "team.build.extensions.debug.debug";
    public static final String JVM_PROPERTY_NAME_TRACE = "team.build.extensions.debug.trace";
    public static final String JVM_PROPERTY_NAME_ITEMS = "team.build.extensions.debug.items";
    public static final String LOG4J_LOGICAL_LOG_NAME = "com.ibm.team.build.extensions.common.debug.Debug";
    public static final String LOG4J_LOGFACTORY_CLASS = "org/apache/commons/logging/LogFactory";
    public static final String LOG4J_LOGFACTORY_ERROR = "java.lang.NoClassDefFoundError";
    public static final Level LevelFlow = Level.forName((String)"flow".toUpperCase(), (int)450);
    public static final Level LevelItems = Level.forName((String)"items".toUpperCase(), (int)650);

    public static String getClassPropertyName(Class<?> clazz) {
        return "team.build.extensions.debug.class." + clazz.getCanonicalName();
    }

    public static String getClassPropertyValue(String level) {
        return IDebugger.getPropertyValue(level);
    }

    public static String getClassPropertyValue(String level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        return IDebugger.getPropertyValue(level, debugOn, timerOn, multi, timer);
    }

    public static String getClassPropertyValue(int level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        return IDebugger.getPropertyValue(level, debugOn, timerOn, multi, timer);
    }

    public static String getGroupPropertyName(String group) {
        return "team.build.extensions.debug.group." + group;
    }

    public static String getGroupPropertyValue(String level) {
        return IDebugger.getPropertyValue(level);
    }

    public static String getGroupPropertyValue(String level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        return IDebugger.getPropertyValue(level, debugOn, timerOn, multi, timer);
    }

    public static String getGroupPropertyValue(int level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        return IDebugger.getPropertyValue(level, debugOn, timerOn, multi, timer);
    }

    public static String getPropertyValue(String level) {
        StringBuilder result = new StringBuilder();
        result.append(level);
        result.append(",").append(Debug_True);
        result.append(",").append(Debug_True);
        result.append(",").append(Debug_True);
        result.append(",").append(Debug_True);
        return result.toString();
    }

    public static String getPropertyValue(String level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        StringBuilder result = new StringBuilder();
        result.append(level);
        result.append(",").append(Boolean.toString(debugOn));
        result.append(",").append(Boolean.toString(timerOn));
        result.append(",").append(Boolean.toString(multi));
        result.append(",").append(Boolean.toString(timer));
        return result.toString();
    }

    public static String getPropertyValue(int level, boolean debugOn, boolean timerOn, boolean multi, boolean timer) {
        StringBuilder result = new StringBuilder();
        switch (level) {
            case 0: {
                result.append("fatal");
                break;
            }
            case 1: {
                result.append("error");
                break;
            }
            case 2: {
                result.append("warn");
                break;
            }
            case 3: {
                result.append("info");
                break;
            }
            case 4: {
                result.append("flow");
                break;
            }
            case 5: {
                result.append("debug");
                break;
            }
            case 6: {
                result.append("trace");
                break;
            }
            case 7: {
                result.append("items");
                break;
            }
            default: {
                result.append("info");
            }
        }
        result.append(",").append(Boolean.toString(debugOn));
        result.append(",").append(Boolean.toString(timerOn));
        result.append(",").append(Boolean.toString(multi));
        result.append(",").append(Boolean.toString(timer));
        return result.toString();
    }

    public static Level getLevel(int level) {
        Level result;
        switch (level) {
            case 0: {
                result = Level.OFF;
                break;
            }
            case 100: {
                result = Level.FATAL;
                break;
            }
            case 200: {
                result = Level.ERROR;
                break;
            }
            case 300: {
                result = Level.WARN;
                break;
            }
            case 400: {
                result = Level.INFO;
                break;
            }
            case 450: {
                result = LevelFlow;
                break;
            }
            case 500: {
                result = Level.DEBUG;
                break;
            }
            case 600: {
                result = Level.TRACE;
                break;
            }
            case 650: {
                result = LevelItems;
                break;
            }
            case 0x7FFFFFFF: {
                result = Level.ALL;
                break;
            }
            default: {
                result = Level.OFF;
            }
        }
        return result;
    }

    public IDebugger getDbg(IDebugger var1, Class<?> var2);

    public IDebugger getDbg(IDebugger var1, Method var2);

    public IDebugger getDbg(IDebugger var1, Field var2);

    public IDebugger init();

    public void init(IDebugClass var1);

    public Class<?> getClazz();

    public void setClazz(Class<?> var1);

    public String getClassName();

    public void setClassName(String var1);

    public String getGroupName();

    public void setGroupName(String var1);

    public boolean isGroup();

    public void setGroup(boolean var1);

    public boolean isUtility();

    public void setUtility(boolean var1);

    public int getClassVersion();

    public void setClassVersion(int var1);

    public int getGroupVersion();

    public void setGroupVersion(int var1);

    public void log(String var1);

    public void log(String var1, int var2);

    public void log(Throwable var1);

    public void log(Throwable var1, int var2);

    public void log(String var1, Throwable var2);

    public void log(String var1, Throwable var2, int var3);

    public void logMsg(String var1);

    public void logMsg(String var1, int var2);

    public void logMsg(Throwable var1);

    public void logMsg(Throwable var1, int var2);

    public void logMsg(String var1, Throwable var2);

    public void logMsg(String var1, Throwable var2, int var3);

    public int getFatalLevel();

    public int getErrorLevel();

    public int getWarnLevel();

    public int getInfoLevel();

    public int getFlowLevel();

    public int getDebugLevel();

    public int getTraceLevel();

    public int getItemsLevel();

    public int getLogLevel();

    public IDebugLogger getLogger();

    public boolean isOn();

    public boolean isDebugOn();

    public boolean isTimerOn();

    public boolean isMulti();

    public boolean isTimer();

    public boolean isFatal();

    public boolean isError();

    public boolean isWarn();

    public boolean isInfo();

    public boolean isFlow();

    public boolean isDebug();

    public boolean isTrace();

    public boolean isItems();

    public void setDebugOn(boolean var1);

    public void setTimerOn(boolean var1);

    public void setMulti(boolean var1);

    public void setTimer(boolean var1);

    public void setFatal(boolean var1);

    public void setError(boolean var1);

    public void setWarn(boolean var1);

    public void setInfo(boolean var1);

    public void setFlow(boolean var1);

    public void setDebug(boolean var1);

    public void setTrace(boolean var1);

    public void setItems(boolean var1);

    public void setLogLevel(int var1);

    public void setLogger(IDebugLogger var1);

    public void setLogMsg(IDebugLogMsg var1);

    public int toFormatLevel(int var1);
}

