/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugLog;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogWrapper;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;

public class DebuggerLoggerBasic
implements IDebugLogger {
    private final Log log;
    private final IDebugLog logger;
    private boolean debugOn;
    private final boolean fatal;
    private final boolean error;
    private final boolean warn;
    private final boolean info;
    private final boolean flow;
    private final boolean debug;
    private final boolean trace;
    private final boolean items;

    public DebuggerLoggerBasic(Log logger) {
        this(logger, new Debugger());
    }

    public DebuggerLoggerBasic(Log log, IDebugger dbg) {
        this.log = log;
        if (log != null) {
            this.logger = new LogWrapper(log);
            this.fatal = this.logger.isFatalEnabled();
            this.error = this.logger.isErrorEnabled();
            this.warn = this.logger.isWarnEnabled();
            this.info = this.logger.isInfoEnabled();
            this.flow = this.logger.isFlowEnabled();
            this.debug = this.logger.isDebugEnabled();
            this.trace = this.logger.isTraceEnabled();
            this.items = this.logger.isItemsEnabled();
            if (Stream.of(this.logger.isFatalEnabled(), this.logger.isErrorEnabled(), this.logger.isWarnEnabled(), this.logger.isInfoEnabled(), this.logger.isFlowEnabled(), this.logger.isDebugEnabled(), this.logger.isTraceEnabled(), this.logger.isItemsEnabled()).anyMatch(x -> x)) {
                this.debugOn = true;
            }
        } else {
            this.logger = null;
            this.fatal = dbg.isFatal();
            this.error = dbg.isError();
            this.warn = dbg.isWarn();
            this.info = dbg.isInfo();
            this.flow = dbg.isFlow();
            this.debug = dbg.isDebug();
            this.trace = dbg.isTrace();
            this.items = dbg.isItems();
            this.debugOn = dbg.isDebugOn();
        }
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public void log(String s) {
        if (this.logger != null) {
            this.logger.info(s);
        }
    }

    @Override
    public void log(String s, int level) {
        this.log(s);
    }

    @Override
    public void log(Throwable t) {
        if (this.logger != null) {
            this.logger.info(t);
        }
    }

    @Override
    public void log(Throwable t, int level) {
        this.log(t);
    }

    @Override
    public void log(String s, Throwable t) {
        if (this.logger != null) {
            this.logger.info(s, t);
        }
    }

    @Override
    public void log(String s, Throwable t, int level) {
        this.log(s, t);
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger == null ? this.fatal : this.logger.isFatalEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger == null ? this.error : this.logger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger == null ? this.warn : this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger == null ? this.info : this.logger.isInfoEnabled();
    }

    @Override
    public boolean isFlowEnabled() {
        return this.logger == null ? this.flow : this.logger.isFlowEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger == null ? this.debug : this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger == null ? this.trace : this.logger.isTraceEnabled();
    }

    @Override
    public boolean isItemsEnabled() {
        return this.logger == null ? this.items : this.logger.isItemsEnabled();
    }
}

