/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugLog;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.LogWrapper;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;

public class DebuggerLogger
implements IDebugLogger {
    private final Log log;
    private final IDebugLog logger;
    private boolean debugOn;

    public DebuggerLogger(Log log) {
        this(log, null, null);
    }

    public DebuggerLogger(Log log, IDebugClass debugClass) {
        this(log, debugClass, null);
    }

    public DebuggerLogger(Log log, IDebugClass debugClass, IDebugLog debugLog) {
        this.log = log;
        if (log != null) {
            this.logger = debugLog != null ? debugLog : new LogWrapper(log, debugClass);
            this.debugOn = debugClass != null ? debugClass.isDebugOn() : Stream.of(this.logger.isFatalEnabled(), this.logger.isErrorEnabled(), this.logger.isWarnEnabled(), this.logger.isInfoEnabled(), this.logger.isFlowEnabled(), this.logger.isDebugEnabled(), this.logger.isTraceEnabled(), this.logger.isItemsEnabled()).anyMatch(x -> x);
        } else {
            this.logger = null;
        }
    }

    @Override
    public final Log getLog() {
        return this.log;
    }

    @Override
    public final void log(String s) {
        if (this.logger != null) {
            this.logger.info(s);
        }
    }

    @Override
    public final void log(String s, int level) {
        if (this.logger != null) {
            switch (level) {
                case 100: {
                    this.logger.fatal(s);
                    break;
                }
                case 200: {
                    this.logger.error(s);
                    break;
                }
                case 300: {
                    this.logger.warn(s);
                    break;
                }
                case 400: {
                    this.logger.info(s);
                    break;
                }
                case 450: {
                    this.logger.flow(s);
                    break;
                }
                case 500: {
                    this.logger.debug(s);
                    break;
                }
                case 600: {
                    this.logger.trace(s);
                    break;
                }
                case 650: {
                    this.logger.items(s);
                }
            }
        }
    }

    @Override
    public final void log(Throwable t) {
        if (this.logger != null) {
            this.logger.info(t);
        }
    }

    @Override
    public final void log(Throwable t, int level) {
        if (this.logger != null) {
            switch (level) {
                case 100: {
                    this.logger.fatal(t);
                    break;
                }
                case 200: {
                    this.logger.error(t);
                    break;
                }
                case 300: {
                    this.logger.warn(t);
                    break;
                }
                case 400: {
                    this.logger.info(t);
                    break;
                }
                case 450: {
                    this.logger.flow(t);
                    break;
                }
                case 500: {
                    this.logger.debug(t);
                    break;
                }
                case 600: {
                    this.logger.trace(t);
                    break;
                }
                case 650: {
                    this.logger.items(t);
                }
            }
        }
    }

    @Override
    public final void log(String s, Throwable t) {
        if (this.logger != null) {
            this.logger.info(s, t);
        }
    }

    @Override
    public final void log(String s, Throwable t, int level) {
        if (this.logger != null) {
            switch (level) {
                case 100: {
                    this.logger.fatal(s, t);
                    break;
                }
                case 200: {
                    this.logger.error(s, t);
                    break;
                }
                case 300: {
                    this.logger.warn(s, t);
                    break;
                }
                case 400: {
                    this.logger.info(s, t);
                    break;
                }
                case 450: {
                    this.logger.flow(s, t);
                    break;
                }
                case 500: {
                    this.logger.debug(s, t);
                    break;
                }
                case 600: {
                    this.logger.trace(s, t);
                    break;
                }
                case 650: {
                    this.logger.items(s, t);
                }
            }
        }
    }

    @Override
    public final boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public final boolean isFatalEnabled() {
        return this.logger == null ? false : this.logger.isFatalEnabled();
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.logger == null ? false : this.logger.isErrorEnabled();
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.logger == null ? false : this.logger.isWarnEnabled();
    }

    @Override
    public final boolean isInfoEnabled() {
        return this.logger == null ? false : this.logger.isInfoEnabled();
    }

    @Override
    public final boolean isFlowEnabled() {
        return this.logger == null ? false : this.logger.isFlowEnabled();
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.logger == null ? false : this.logger.isDebugEnabled();
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.logger == null ? false : this.logger.isTraceEnabled();
    }

    @Override
    public final boolean isItemsEnabled() {
        return this.logger == null ? false : this.logger.isItemsEnabled();
    }
}

