/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.debug.AbstractDebuggerCom;
import com.ibm.team.build.extensions.common.debug.DebuggerLogger;
import com.ibm.team.build.extensions.common.nls.Messages;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.repository.common.util.NLS;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class DebuggerJoint
extends AbstractDebuggerCom {
    private static boolean configAvailable = false;
    public boolean fatal = false;
    public boolean error = false;
    public boolean warn = false;
    public boolean info = false;
    public boolean flow = false;
    public boolean debug = false;
    public boolean trace = false;
    public boolean items = false;

    static {
        try {
            if (((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggers().get("com.ibm.team.build.extensions.common.debug.Debug") != null) {
                configAvailable = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DebuggerJoint() {
        try {
            String items;
            String trace;
            String debug;
            String flow;
            String info;
            String warn;
            String error;
            String fatal;
            block15: {
                fatal = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_FATAL");
                error = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_ERROR");
                warn = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_WARN");
                info = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_INFO");
                flow = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_FLOW");
                debug = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_DEBUG");
                trace = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_TRACE");
                items = System.getenv("TEAM_BUILD_EXTENSIONS_DEBUG_ITEMS");
                if (fatal == null) {
                    fatal = System.getProperty("team.build.extensions.debug.fatal");
                }
                if (error == null) {
                    error = System.getProperty("team.build.extensions.debug.error");
                }
                if (warn == null) {
                    warn = System.getProperty("team.build.extensions.debug.warn");
                }
                if (info == null) {
                    info = System.getProperty("team.build.extensions.debug.info");
                }
                if (flow == null) {
                    flow = System.getProperty("team.build.extensions.debug.flow");
                }
                if (debug == null) {
                    debug = System.getProperty("team.build.extensions.debug.debug");
                }
                if (trace == null) {
                    trace = System.getProperty("team.build.extensions.debug.trace");
                }
                if (items == null) {
                    items = System.getProperty("team.build.extensions.debug.items");
                }
                if (Stream.of(fatal, error, warn, info, flow, debug, trace, items).allMatch(x -> x == null) && configAvailable) {
                    try {
                        Log log = LogFactory.getLog((String)"com.ibm.team.build.extensions.common.debug.Debug");
                        if (log != null) {
                            this.setLogger(new DebuggerLogger(log));
                        }
                    }
                    catch (Throwable t) {
                        if ("org/apache/commons/logging/LogFactory".equals(t.getMessage()) && "java.lang.NoClassDefFoundError".equals(t.getClass().getName())) break block15;
                        t.printStackTrace();
                        System.out.println(NLS.bind((String)Messages.DBG_EXCEPTION_GENERAL_CONTINUES_DEFAULTS, (Object)this.cls, (Object[])new Object[0]));
                    }
                }
            }
            this.fatal = Verification.toBooleanTrueFalse(fatal, false);
            this.error = Verification.toBooleanTrueFalse(error, false);
            this.warn = Verification.toBooleanTrueFalse(warn, false);
            this.info = Verification.toBooleanTrueFalse(info, false);
            this.flow = Verification.toBooleanTrueFalse(flow, false);
            this.debug = Verification.toBooleanTrueFalse(debug, false);
            this.trace = Verification.toBooleanTrueFalse(trace, false);
            this.items = Verification.toBooleanTrueFalse(items, false);
            String[] states = new String[]{fatal, error, warn, info, flow, debug, trace, items};
            List statesOn = IntStream.range(0, states.length).filter(i -> Boolean.parseBoolean(states[i])).mapToObj(i -> i).collect(Collectors.toList());
            if (!statesOn.isEmpty()) {
                this.setStates((Integer)statesOn.get(statesOn.size() - 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(NLS.bind((String)Messages.DBG_EXCEPTION_GENERAL_CONTINUES_DEFAULTS, (Object)this.cls, (Object[])new Object[0]));
            this.fatal = false;
            this.error = false;
            this.warn = false;
            this.info = false;
            this.flow = false;
            this.debug = false;
            this.trace = false;
            this.items = false;
        }
        this.setInfoLevel();
        this.setLogLevel();
    }

    @Override
    public boolean isFatal() {
        return this.isDebugOn() && (this.getLogger() == null ? this.fatal : this.getLogger().isFatalEnabled());
    }

    @Override
    public boolean isError() {
        return this.isDebugOn() && (this.getLogger() == null ? this.error : this.getLogger().isErrorEnabled());
    }

    @Override
    public boolean isWarn() {
        return this.isDebugOn() && (this.getLogger() == null ? this.warn : this.getLogger().isWarnEnabled());
    }

    @Override
    public boolean isInfo() {
        return this.isDebugOn() && (this.getLogger() == null ? this.info : this.getLogger().isInfoEnabled());
    }

    @Override
    public boolean isFlow() {
        return this.isDebugOn() && (this.getLogger() == null ? this.flow : this.getLogger().isFlowEnabled());
    }

    @Override
    public boolean isDebug() {
        return this.isDebugOn() && (this.getLogger() == null ? this.debug : this.getLogger().isDebugEnabled());
    }

    @Override
    public boolean isTrace() {
        return this.isDebugOn() && (this.getLogger() == null ? this.trace : this.getLogger().isTraceEnabled());
    }

    @Override
    public boolean isItems() {
        return this.isDebugOn() && (this.getLogger() == null ? this.items : this.getLogger().isItemsEnabled());
    }

    @Override
    public void setFatal(boolean fatal) {
        this.fatal = fatal;
        this.setLogLevel();
    }

    @Override
    public void setError(boolean error) {
        this.error = error;
        this.setLogLevel();
    }

    @Override
    public void setWarn(boolean warn) {
        this.warn = warn;
        this.setLogLevel();
    }

    @Override
    public void setInfo(boolean info) {
        this.info = info;
        this.setLogLevel();
    }

    @Override
    public void setFlow(boolean flow) {
        this.flow = flow;
        this.setLogLevel();
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
        this.setLogLevel();
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
        this.setLogLevel();
    }

    @Override
    public void setItems(boolean items) {
        this.items = items;
        this.setLogLevel();
    }
}

