/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.extensions.common.debug;

import com.ibm.team.build.extensions.common.Assert;
import com.ibm.team.build.extensions.common.PropertyTools;
import com.ibm.team.build.extensions.common.debug.DebugClass;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugInstance;
import com.ibm.team.build.extensions.common.debug.DebuggerClass;
import com.ibm.team.build.extensions.common.debug.DebuggerJoint;
import com.ibm.team.build.extensions.common.debug.DebuggerLogMsg;
import com.ibm.team.build.extensions.common.debug.DebuggerLogger;
import com.ibm.team.build.extensions.common.debug.IDebugClass;
import com.ibm.team.build.extensions.common.debug.IDebugLog;
import com.ibm.team.build.extensions.common.debug.IDebugLogMsg;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class Debugger
implements IDebugger {
    private IDebugger delegate;

    public static void initDbg() {
        if (!DebugInstance.getInstance(null).isDbgSet()) {
            DebugInstance.getInstance().setDbg(new Debugger());
        }
    }

    public Debugger() {
        this.delegate = new DebuggerJoint();
    }

    public Debugger(IDebugLogger logger) {
        this();
        this.setLogger(logger);
    }

    public Debugger(Log log) {
        this();
        this.setLogger(new DebuggerLogger(log));
    }

    public Debugger(Class<?> clazz, IDebugLogger logger) {
        this(clazz);
        this.setLogger(logger);
    }

    public Debugger(Class<?> clazz, Log log) {
        this(clazz);
        if (this.delegate instanceof DebuggerClass) {
            IDebugClass dc = ((DebuggerClass)this.delegate).getDebugClass();
            log = dc.addLogger(log, this.getLogLevel());
            this.setLogger(new DebuggerLogger(log, dc));
        } else {
            this.setLogger(new DebuggerLogger(log));
        }
    }

    public Debugger(Class<?> clazz, IDebugLog debugLog) {
        this(clazz);
        if (this.delegate instanceof DebuggerClass) {
            IDebugClass dc = ((DebuggerClass)this.delegate).getDebugClass();
            Log log = dc.addLogger(debugLog.getLog(), this.getLogLevel());
            debugLog.setLog(dc.getLog());
            debugLog.setLogger(dc.getLogger());
            this.setLogger(new DebuggerLogger(log, dc, debugLog));
        } else {
            this.setLogger(new DebuggerLogger(debugLog.getLog()));
        }
    }

    public Debugger(Class<?> clazz) {
        DebugInstance instance = DebugInstance.getInstance();
        if (!instance.isDebugClassesSet()) {
            instance.setDebugClasses(PropertyTools.containsProperty(System.getProperties(), "team.build.extensions.debug.class."));
        }
        if (instance.isDebugClasses()) {
            this.delegate = this.getClassDebugger(instance, clazz);
            if (this.delegate == null) {
                this.delegate = this.getDefaultClass(instance, clazz);
            }
        } else if (instance.isDebugGroups()) {
            this.delegate = this.getGroupDebugger(instance, clazz);
            if (this.delegate == null) {
                this.delegate = this.getDefaultGroup(instance, clazz);
            }
        } else {
            this.delegate = new DebuggerJoint();
        }
    }

    @Override
    public IDebugger getDbg(IDebugger dbg, Class<?> clazz) {
        Assert.isNotNull(dbg);
        Assert.isNotNull(clazz);
        IDebugger result = dbg;
        DebugInstance instance = DebugInstance.getInstance();
        if (instance.isDebugActive()) {
            boolean found = false;
            if (instance.isDebugClasses()) {
                if (this.isClassDebugger(dbg, clazz)) {
                    if (instance.getClassVersion() != dbg.getClassVersion()) {
                        dbg.init(instance.getClassEntry(clazz));
                    }
                    found = true;
                } else if (instance.hasClassEntry(clazz)) {
                    result = this.getClassDebugger(instance, clazz);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found && instance.isDebugGroups()) {
                if (this.isGroupDebugger(dbg, clazz) && dbg.getGroupName().equals(IDebugger.getGroupPropertyName(this.getGroupClass(instance, clazz)))) {
                    if (instance.getGroupVersion() != dbg.getGroupVersion()) {
                        dbg.init(instance.getDebugGroups().get(this.getGroupName()));
                    }
                    found = true;
                }
                if (!found && instance.hasGroupEntry(clazz.getAnnotation(DebugGroup.class))) {
                    result = this.getGroupDebugger(instance, clazz);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found) {
                if (instance.isDebugClasses()) {
                    result = this.getDefaultClass(instance, clazz);
                    this.resetLogger(dbg, result);
                } else {
                    result = this.getDefaultGroup(instance, clazz);
                    this.resetLogger(dbg, result);
                }
            }
        }
        return result;
    }

    @Override
    public IDebugger getDbg(IDebugger dbg, Method method) {
        DebugInstance instance;
        Assert.isNotNull(dbg);
        Assert.isNotNull(method);
        IDebugger result = dbg;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isAnonymousClass()) {
            clazz = clazz.getEnclosingClass();
        }
        if ((instance = DebugInstance.getInstance()).isDebugActive()) {
            boolean found = false;
            if (instance.isDebugClasses()) {
                if (this.isClassDebugger(dbg, clazz)) {
                    if (instance.getClassVersion() != dbg.getClassVersion()) {
                        dbg.init(instance.getClassEntry(clazz));
                    }
                    found = true;
                } else if (instance.hasClassEntry(clazz)) {
                    result = this.getClassDebugger(instance, clazz);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found && instance.isDebugGroups()) {
                if (this.isGroupDebugger(dbg, clazz)) {
                    if (dbg.getGroupName().equals(IDebugger.getGroupPropertyName(this.getGroupMethod(instance, method)))) {
                        if (instance.getGroupVersion() != dbg.getGroupVersion()) {
                            dbg.init(instance.getDebugGroups().get(this.getGroupName()));
                        }
                        found = true;
                    } else if (dbg.getGroupName().equals(IDebugger.getGroupPropertyName(this.getGroupClass(instance, clazz)))) {
                        if (instance.getGroupVersion() != dbg.getGroupVersion()) {
                            dbg.init(instance.getDebugGroups().get(this.getGroupName()));
                        }
                        found = true;
                    }
                }
                if (!found && instance.hasGroupEntry(method.getAnnotation(DebugGroup.class))) {
                    result = this.getGroupDebugger(instance, clazz, method);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found) {
                if (instance.isDebugClasses()) {
                    result = this.getDefaultClass(instance, clazz);
                    this.resetLogger(dbg, result);
                } else {
                    result = this.getDefaultGroup(instance, clazz);
                    this.resetLogger(dbg, result);
                }
            }
        }
        return result;
    }

    @Override
    public IDebugger getDbg(IDebugger dbg, Field field) {
        DebugInstance instance;
        Assert.isNotNull(dbg);
        Assert.isNotNull(field);
        IDebugger result = dbg;
        Class<?> clazz = field.getDeclaringClass();
        if (clazz.isAnonymousClass()) {
            clazz = clazz.getEnclosingClass();
        }
        if ((instance = DebugInstance.getInstance()).isDebugActive()) {
            boolean found = false;
            if (instance.isDebugClasses()) {
                if (this.isClassDebugger(dbg, clazz)) {
                    if (instance.getClassVersion() != dbg.getClassVersion()) {
                        dbg.init(instance.getClassEntry(clazz));
                    }
                    found = true;
                } else if (instance.hasClassEntry(clazz)) {
                    result = this.getClassDebugger(instance, clazz);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found && instance.isDebugGroups()) {
                if (this.isGroupDebugger(dbg, clazz)) {
                    if (dbg.getGroupName().equals(IDebugger.getGroupPropertyName(this.getGroupField(instance, field)))) {
                        if (instance.getGroupVersion() != dbg.getGroupVersion()) {
                            dbg.init(instance.getDebugGroups().get(this.getGroupName()));
                        }
                        found = true;
                    } else if (dbg.getGroupName().equals(IDebugger.getGroupPropertyName(this.getGroupClass(instance, clazz)))) {
                        if (instance.getGroupVersion() != dbg.getGroupVersion()) {
                            dbg.init(instance.getDebugGroups().get(this.getGroupName()));
                        }
                        found = true;
                    }
                }
                if (!found && instance.hasGroupEntry(field.getAnnotation(DebugGroup.class))) {
                    result = this.getGroupDebugger(instance, clazz, field);
                    this.resetLogger(dbg, result);
                    found = true;
                }
            }
            if (!found) {
                if (instance.isDebugClasses()) {
                    result = this.getDefaultClass(instance, clazz);
                    this.resetLogger(dbg, result);
                } else {
                    result = this.getDefaultGroup(instance, clazz);
                    this.resetLogger(dbg, result);
                }
            }
        }
        return result;
    }

    private boolean isClassDebugger(IDebugger dbg, Class<?> clazz) {
        return clazz.equals(dbg.getClazz()) && !dbg.isGroup();
    }

    private boolean isGroupDebugger(IDebugger dbg, Class<?> clazz) {
        return clazz.equals(dbg.getClazz()) && dbg.isGroup();
    }

    private IDebugger getClassDebugger(DebugInstance instance, Class<?> clazz) {
        DebuggerClass result = null;
        if (instance.hasClassEntry(clazz)) {
            IDebugClass entry = instance.getClassEntry(clazz);
            result = new DebuggerClass(entry);
        } else {
            String clsProp = System.getProperty(IDebugger.getClassPropertyName(clazz));
            if (clsProp != null) {
                DebugClass entry = new DebugClass(clazz, clsProp);
                entry.setClassVersion(instance.getClassVersion());
                instance.addClassEntry(clazz, (IDebugClass)entry);
                result = new DebuggerClass(entry);
            }
        }
        return result;
    }

    private IDebugger getDefaultClass(DebugInstance instance, Class<?> clazz) {
        IDebugClass entry = IDebugClass.getDefault(clazz);
        entry.setClassVersion(instance.getClassVersion());
        instance.addClassEntry(clazz, entry);
        return new DebuggerClass(entry);
    }

    private IDebugger getGroupDebugger(DebugInstance instance, Class<?> clazz) {
        DebuggerClass result = null;
        String group = this.getGroupClass(instance, clazz);
        if (group != null) {
            IDebugClass entry = instance.getDebugGroups().get(group).copy();
            entry.setClazz(clazz);
            result = new DebuggerClass(entry);
        }
        return result;
    }

    private IDebugger getDefaultGroup(DebugInstance instance, Class<?> clazz) {
        IDebugClass entry = IDebugClass.getDefault(clazz);
        entry.setGroup(true);
        entry.setGroupName(clazz.getCanonicalName());
        entry.setGroupVersion(instance.getGroupVersion());
        return new DebuggerClass(entry);
    }

    private String getGroupClass(DebugInstance instance, Class<?> clazz) {
        String result = null;
        if (this.isGroupClass(clazz)) {
            String[] stringArray = clazz.getAnnotation(DebugGroup.class).value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (instance.getDebugGroups().containsKey(group)) {
                    result = group;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isGroupClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(DebugGroup.class);
    }

    private IDebugger getGroupDebugger(DebugInstance instance, Class<?> clazz, Method method) {
        DebuggerClass result = null;
        String group = this.getGroupMethod(instance, method);
        if (group != null) {
            IDebugClass entry = instance.getDebugGroups().get(group).copy();
            entry.setClazz(clazz);
            result = new DebuggerClass(entry);
        }
        return result;
    }

    private String getGroupMethod(DebugInstance instance, Method method) {
        String result = null;
        if (this.isGroupMethod(method)) {
            String[] stringArray = method.getAnnotation(DebugGroup.class).value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (instance.getDebugGroups().containsKey(group)) {
                    result = group;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isGroupMethod(Method method) {
        return method.isAnnotationPresent(DebugGroup.class);
    }

    private IDebugger getGroupDebugger(DebugInstance instance, Class<?> clazz, Field field) {
        DebuggerClass result = null;
        String group = this.getGroupField(instance, field);
        if (group != null) {
            IDebugClass entry = instance.getDebugGroups().get(group).copy();
            entry.setClazz(clazz);
            result = new DebuggerClass(entry);
        }
        return result;
    }

    private String getGroupField(DebugInstance instance, Field field) {
        String result = null;
        if (this.isGroupField(field)) {
            String[] stringArray = field.getAnnotation(DebugGroup.class).value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (instance.getDebugGroups().containsKey(group)) {
                    result = group;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isGroupField(Field field) {
        return field.isAnnotationPresent(DebugGroup.class);
    }

    private void resetLogger(IDebugger dbg, IDebugger result) {
        if (result != null) {
            result.setLogger(dbg.getLogger());
            result.setLogMsg(new DebuggerLogMsg(result));
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public IDebugger init() {
        DebugInstance instance = DebugInstance.getInstance();
        if (instance.isDebugClasses()) {
            if (instance.getClassVersion() != this.getClassVersion()) {
                this.init(instance.getClassEntry(this.getClazz()));
            }
        } else if (instance.isDebugGroups() && instance.getGroupVersion() != this.getGroupVersion()) {
            this.init(instance.getDebugGroups().get(this.getGroupName()));
        }
        return this;
    }

    @Override
    public void init(IDebugClass dc) {
        this.delegate.init(dc);
    }

    @Override
    public Class<?> getClazz() {
        return this.delegate.getClazz();
    }

    @Override
    public void setClazz(Class<?> clazz) {
        this.delegate.setClazz(clazz);
    }

    @Override
    public String getClassName() {
        return this.delegate.getClassName();
    }

    @Override
    public void setClassName(String className) {
        this.delegate.setClassName(className);
    }

    @Override
    public String getGroupName() {
        return this.delegate.getGroupName();
    }

    @Override
    public void setGroupName(String groupName) {
        this.delegate.setGroupName(groupName);
    }

    @Override
    public boolean isGroup() {
        return this.delegate.isGroup();
    }

    @Override
    public void setGroup(boolean group) {
        this.delegate.setGroup(group);
    }

    @Override
    public boolean isUtility() {
        return this.delegate.isUtility();
    }

    @Override
    public void setUtility(boolean utility) {
        this.delegate.setUtility(utility);
    }

    @Override
    public int getClassVersion() {
        return this.delegate.getClassVersion();
    }

    @Override
    public void setClassVersion(int classVersion) {
        this.delegate.setClassVersion(classVersion);
    }

    @Override
    public int getGroupVersion() {
        return this.delegate.getGroupVersion();
    }

    @Override
    public void setGroupVersion(int groupVersion) {
        this.delegate.setGroupVersion(groupVersion);
    }

    @Override
    public int getFatalLevel() {
        return this.delegate.getFatalLevel();
    }

    @Override
    public int getErrorLevel() {
        return this.delegate.getErrorLevel();
    }

    @Override
    public int getWarnLevel() {
        return this.delegate.getWarnLevel();
    }

    @Override
    public int getInfoLevel() {
        return this.delegate.getInfoLevel();
    }

    @Override
    public int getFlowLevel() {
        return this.delegate.getFlowLevel();
    }

    @Override
    public int getDebugLevel() {
        return this.delegate.getDebugLevel();
    }

    @Override
    public int getTraceLevel() {
        return this.delegate.getTraceLevel();
    }

    @Override
    public int getItemsLevel() {
        return this.delegate.getItemsLevel();
    }

    @Override
    public int getLogLevel() {
        return this.delegate.getLogLevel();
    }

    @Override
    public IDebugLogger getLogger() {
        return this.delegate.getLogger();
    }

    @Override
    public boolean isOn() {
        return this.delegate.isOn();
    }

    @Override
    public boolean isDebugOn() {
        return this.delegate.isDebugOn();
    }

    @Override
    public boolean isTimerOn() {
        return this.delegate.isTimerOn();
    }

    @Override
    public boolean isMulti() {
        return this.delegate.isMulti();
    }

    @Override
    public boolean isTimer() {
        return this.delegate.isTimer();
    }

    @Override
    public boolean isFatal() {
        return this.delegate.isFatal();
    }

    @Override
    public boolean isError() {
        return this.delegate.isError();
    }

    @Override
    public boolean isWarn() {
        return this.delegate.isWarn();
    }

    @Override
    public boolean isInfo() {
        return this.delegate.isInfo();
    }

    @Override
    public boolean isFlow() {
        return this.delegate.isFlow();
    }

    @Override
    public boolean isDebug() {
        return this.delegate.isDebug();
    }

    @Override
    public boolean isTrace() {
        return this.delegate.isTrace();
    }

    @Override
    public boolean isItems() {
        return this.delegate.isItems();
    }

    @Override
    public void log(String msg) {
        this.delegate.log(msg);
    }

    @Override
    public void log(String msg, int msgLevel) {
        this.delegate.log(msg, msgLevel);
    }

    @Override
    public void log(Throwable t) {
        this.delegate.log(t);
    }

    @Override
    public void log(Throwable t, int msgLevel) {
        this.delegate.log(t, msgLevel);
    }

    @Override
    public void log(String msg, Throwable t) {
        this.delegate.log(msg, t);
    }

    @Override
    public void log(String msg, Throwable t, int msgLevel) {
        this.delegate.log(msg, t, msgLevel);
    }

    @Override
    public void logMsg(String s) {
        this.delegate.logMsg(s);
    }

    @Override
    public void logMsg(String s, int level) {
        this.delegate.logMsg(s, level);
    }

    @Override
    public void logMsg(Throwable t) {
        this.delegate.logMsg(t);
    }

    @Override
    public void logMsg(Throwable t, int level) {
        this.delegate.logMsg(t, level);
    }

    @Override
    public void logMsg(String s, Throwable t) {
        this.delegate.logMsg(s, t);
    }

    @Override
    public void logMsg(String s, Throwable t, int level) {
        this.delegate.logMsg(s, t, level);
    }

    @Override
    public void setDebugOn(boolean debugOn) {
        this.delegate.setDebugOn(debugOn);
    }

    @Override
    public void setTimerOn(boolean timerOn) {
        this.delegate.setTimerOn(timerOn);
    }

    @Override
    public void setMulti(boolean multi) {
        this.delegate.setMulti(multi);
    }

    @Override
    public void setTimer(boolean timer) {
        this.delegate.setTimer(timer);
    }

    @Override
    public void setFatal(boolean fatal) {
        this.delegate.setFatal(fatal);
    }

    @Override
    public void setError(boolean error) {
        this.delegate.setError(error);
    }

    @Override
    public void setWarn(boolean warn) {
        this.delegate.setWarn(warn);
    }

    @Override
    public void setInfo(boolean info) {
        this.delegate.setInfo(info);
    }

    @Override
    public void setFlow(boolean flow) {
        this.delegate.setFlow(flow);
    }

    @Override
    public void setDebug(boolean debug) {
        this.delegate.setDebug(debug);
    }

    @Override
    public void setTrace(boolean trace) {
        this.delegate.setTrace(trace);
    }

    @Override
    public void setItems(boolean items) {
        this.delegate.setItems(items);
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.delegate.setLogLevel(logLevel);
    }

    @Override
    public void setLogger(IDebugLogger logger) {
        this.delegate.setLogger(logger);
    }

    @Override
    public void setLogMsg(IDebugLogMsg logMsg) {
        this.delegate.setLogMsg(logMsg);
    }

    @Override
    public int toFormatLevel(int level) {
        return this.delegate.toFormatLevel(level);
    }
}

